/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.util.Date;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;

public class BcPGPKeyPair
extends PGPKeyPair {
    private static PGPPublicKey getPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        return BcPGPKeyPair.getPublicKey(4, n, pGPAlgorithmParameters, asymmetricKeyParameter, date);
    }

    private static PGPPublicKey getPublicKey(int n, int n2, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        return new BcPGPKeyConverter().getPGPPublicKey(n, n2, pGPAlgorithmParameters, asymmetricKeyParameter, date);
    }

    private static PGPPrivateKey getPrivateKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        return new BcPGPKeyConverter().getPGPPrivateKey(pGPPublicKey, asymmetricKeyParameter);
    }

    public BcPGPKeyPair(int n, AsymmetricCipherKeyPair asymmetricCipherKeyPair, Date date) throws PGPException {
        this(4, n, asymmetricCipherKeyPair, date);
    }

    public BcPGPKeyPair(int n, int n2, AsymmetricCipherKeyPair asymmetricCipherKeyPair, Date date) throws PGPException {
        this.pub = BcPGPKeyPair.getPublicKey(n, n2, null, asymmetricCipherKeyPair.getPublic(), date);
        this.priv = BcPGPKeyPair.getPrivateKey(this.pub, asymmetricCipherKeyPair.getPrivate());
    }

    public BcPGPKeyPair(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricCipherKeyPair asymmetricCipherKeyPair, Date date) throws PGPException {
        this(4, n, pGPAlgorithmParameters, asymmetricCipherKeyPair, date);
    }

    public BcPGPKeyPair(int n, int n2, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricCipherKeyPair asymmetricCipherKeyPair, Date date) throws PGPException {
        this.pub = BcPGPKeyPair.getPublicKey(n, n2, pGPAlgorithmParameters, asymmetricCipherKeyPair.getPublic(), date);
        this.priv = BcPGPKeyPair.getPrivateKey(this.pub, asymmetricCipherKeyPair.getPrivate());
    }
}

