/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public abstract class AbstractPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    public final byte[] recoverSessionData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) throws PGPException {
        byte[] byArray = this.recoverSessionData(publicKeyEncSessionPacket.getAlgorithm(), publicKeyEncSessionPacket.getEncSessionKey(), publicKeyEncSessionPacket.getVersion());
        return this.prependSKAlgorithmToSessionData(publicKeyEncSessionPacket, inputStreamPacket, byArray);
    }

    public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
        return this.recoverSessionData(n, byArray, 3);
    }

    protected byte[] prependSKAlgorithmToSessionData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket, byte[] byArray) throws PGPException {
        if (!this.containsSKAlg(publicKeyEncSessionPacket.getVersion())) {
            if (!(inputStreamPacket instanceof SymmetricEncIntegrityPacket) || ((SymmetricEncIntegrityPacket)inputStreamPacket).getVersion() != 2) {
                throw new PGPException("v6 PKESK packet MUST precede v2 SEIPD packet");
            }
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)inputStreamPacket;
            return Arrays.prepend((byte[])byArray, (byte)((byte)(symmetricEncIntegrityPacket.getCipherAlgorithm() & 0xFF)));
        }
        switch (publicKeyEncSessionPacket.getAlgorithm()) {
            case 25: {
                return Arrays.prepend((byte[])byArray, (byte)publicKeyEncSessionPacket.getEncSessionKey()[0][33]);
            }
            case 26: {
                return Arrays.prepend((byte[])byArray, (byte)publicKeyEncSessionPacket.getEncSessionKey()[0][57]);
            }
        }
        return byArray;
    }

    protected boolean containsSKAlg(int n) {
        return n != 6;
    }

    protected static void checkRange(int n, byte[] byArray) throws PGPException {
        if (n > byArray.length) {
            throw new PGPException("encoded length out of range");
        }
    }
}

