/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.AEADUtil;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean useOldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private byte[] salt = new byte[32];
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private boolean forceSessionKey = false;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder) {
        this(pGPDataEncryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder, boolean bl) {
        this.dataEncryptorBuilder = pGPDataEncryptorBuilder;
        this.useOldFormat = bl;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        this.rand.nextBytes(this.salt);
    }

    public void setForceSessionKey(boolean bl) {
        this.forceSessionKey = bl;
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator) {
        this.methods.add(pGPKeyEncryptionMethodGenerator);
    }

    private void addCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        byArray[byArray.length - 2] = (byte)(n >> 8);
        byArray[byArray.length - 1] = (byte)n;
    }

    private byte[] createSessionInfo(int n, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 3];
        byArray2[0] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.addCheckSum(byArray2);
        return byArray2;
    }

    private OutputStream open(OutputStream outputStream, long l, byte[] byArray) throws IOException, PGPException, IllegalStateException {
        Object object;
        Object object2;
        byte[] byArray2;
        byte[] byArray3;
        boolean bl;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        this.pOut = new BCPGOutputStream(outputStream, !this.useOldFormat);
        boolean bl2 = bl = !this.forceSessionKey && this.methods.size() == 1 && this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator;
        if (bl) {
            byArray3 = ((PBEKeyEncryptionMethodGenerator)this.methods.get(0)).getKey(this.defAlgorithm);
            byArray2 = null;
        } else {
            byArray3 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            byArray2 = this.createSessionInfo(this.defAlgorithm, byArray3);
        }
        byte[] byArray4 = byArray3;
        boolean bl3 = this.dataEncryptorBuilder.isV5StyleAEAD();
        if (this.dataEncryptorBuilder.getAeadAlgorithm() != -1 && !bl3) {
            object2 = SymmetricEncIntegrityPacket.createAAData(2, this.defAlgorithm, this.dataEncryptorBuilder.getAeadAlgorithm(), this.dataEncryptorBuilder.getChunkSize());
            byArray4 = AEADUtil.deriveMessageKeyAndIv(this.dataEncryptorBuilder.getAeadAlgorithm(), this.defAlgorithm, byArray3, this.salt, (byte[])object2);
        }
        object2 = this.dataEncryptorBuilder.build(byArray4);
        this.digestCalc = object2.getIntegrityCalculator();
        for (int i = 0; i < this.methods.size(); ++i) {
            object = (PGPKeyEncryptionMethodGenerator)this.methods.get(i);
            if (object2 instanceof PGPAEADDataEncryptor) {
                PGPAEADDataEncryptor pGPAEADDataEncryptor = (PGPAEADDataEncryptor)object2;
                if (bl3) {
                    this.writeOpenPGPv5ESKPacket((PGPKeyEncryptionMethodGenerator)object, byArray2);
                    continue;
                }
                this.writeOpenPGPv6ESKPacket((PGPKeyEncryptionMethodGenerator)object, pGPAEADDataEncryptor.getAEADAlgorithm(), byArray2);
                continue;
            }
            this.writeOpenPGPv4ESKPacket((PGPKeyEncryptionMethodGenerator)object, byArray2);
        }
        try {
            if (object2 instanceof PGPAEADDataEncryptor) {
                long l2;
                InputStreamPacket inputStreamPacket;
                object = (PGPAEADDataEncryptor)object2;
                if (bl3) {
                    byte[] byArray5 = object.getIV();
                    inputStreamPacket = new AEADEncDataPacket(this.dataEncryptorBuilder.getAlgorithm(), object.getAEADAlgorithm(), object.getChunkSize(), byArray5);
                    l2 = byArray5.length;
                } else {
                    inputStreamPacket = SymmetricEncIntegrityPacket.createVersion2Packet(this.dataEncryptorBuilder.getAlgorithm(), object.getAEADAlgorithm(), object.getChunkSize(), this.salt);
                    l2 = this.salt.length;
                }
                if (byArray != null) {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), byArray);
                } else {
                    long l3 = 1L << object.getChunkSize() + 6;
                    long l4 = (l + l3 - 1L) / l3 * 16L + 16L;
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), l + l4 + 4L + l2);
                }
                this.genOut = this.cOut = object2.getOutputStream(this.pOut);
            } else {
                InputStreamPacket inputStreamPacket;
                if (this.digestCalc != null) {
                    inputStreamPacket = SymmetricEncIntegrityPacket.createVersion1Packet();
                    if (this.useOldFormat) {
                        throw new PGPException("symmetric-enc-integrity packets not supported in old PGP format");
                    }
                } else {
                    inputStreamPacket = new SymmetricEncDataPacket();
                }
                if (byArray == null) {
                    long l5 = this.digestCalc == null ? l + (long)object2.getBlockSize() + 2L : l + (long)object2.getBlockSize() + 2L + 1L + 22L;
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), l5, this.useOldFormat);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), byArray);
                }
                this.genOut = this.cOut = object2.getOutputStream(this.pOut);
                if (this.digestCalc != null) {
                    this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
                }
                byte[] byArray6 = new byte[object2.getBlockSize() + 2];
                this.rand.nextBytes(byArray6);
                byArray6[byArray6.length - 1] = byArray6[byArray6.length - 3];
                byArray6[byArray6.length - 2] = byArray6[byArray6.length - 4];
                this.genOut.write(byArray6);
            }
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    private void writeOpenPGPv4ESKPacket(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator, byte[] byArray) throws IOException, PGPException {
        if (pGPKeyEncryptionMethodGenerator instanceof PBEKeyEncryptionMethodGenerator) {
            PBEKeyEncryptionMethodGenerator pBEKeyEncryptionMethodGenerator = (PBEKeyEncryptionMethodGenerator)pGPKeyEncryptionMethodGenerator;
            ContainedPacket containedPacket = pGPKeyEncryptionMethodGenerator.generate(pBEKeyEncryptionMethodGenerator.getSessionKeyWrapperAlgorithm(this.defAlgorithm), byArray);
            this.pOut.writePacket(containedPacket);
        } else {
            this.pOut.writePacket(pGPKeyEncryptionMethodGenerator.generate(this.defAlgorithm, byArray));
        }
    }

    private void writeOpenPGPv5ESKPacket(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator, byte[] byArray) throws IOException, PGPException {
        if (pGPKeyEncryptionMethodGenerator instanceof PBEKeyEncryptionMethodGenerator) {
            PBEKeyEncryptionMethodGenerator pBEKeyEncryptionMethodGenerator = (PBEKeyEncryptionMethodGenerator)pGPKeyEncryptionMethodGenerator;
            ContainedPacket containedPacket = pGPKeyEncryptionMethodGenerator.generateV5(pBEKeyEncryptionMethodGenerator.getSessionKeyWrapperAlgorithm(this.defAlgorithm), this.dataEncryptorBuilder.getAeadAlgorithm(), byArray);
            this.pOut.writePacket(containedPacket);
        } else {
            this.pOut.writePacket(pGPKeyEncryptionMethodGenerator.generate(this.defAlgorithm, byArray));
        }
    }

    private void writeOpenPGPv6ESKPacket(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator, int n, byte[] byArray) throws IOException, PGPException {
        if (pGPKeyEncryptionMethodGenerator instanceof PBEKeyEncryptionMethodGenerator) {
            PBEKeyEncryptionMethodGenerator pBEKeyEncryptionMethodGenerator = (PBEKeyEncryptionMethodGenerator)pGPKeyEncryptionMethodGenerator;
            ContainedPacket containedPacket = pGPKeyEncryptionMethodGenerator.generateV6(pBEKeyEncryptionMethodGenerator.getSessionKeyWrapperAlgorithm(this.defAlgorithm), n, byArray);
            this.pOut.writePacket(containedPacket);
        } else {
            this.pOut.writePacket(pGPKeyEncryptionMethodGenerator.generate(this.defAlgorithm, byArray));
        }
    }

    public OutputStream open(OutputStream outputStream, long l) throws IOException, PGPException {
        return this.open(outputStream, l, null);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        return this.open(outputStream, 0L, byArray);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(this.genOut, 19, 20L);
                bCPGOutputStream.flush();
                byte[] byArray = this.digestCalc.getDigest();
                this.cOut.write(byArray);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private static class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, byte[] byArray) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), byArray);
            bCPGHeaderObject.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, long l, boolean bl) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), l, bl);
            bCPGHeaderObject.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, long l) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), l);
            bCPGHeaderObject.encode(this);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

