/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.openpgp.ExtendedPGPSecretKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;

public class OpenedPGPKeyData {
    private final List headerList;
    private final SExpression keyExpression;

    public OpenedPGPKeyData(List list, SExpression sExpression) {
        this.headerList = Collections.unmodifiableList(list);
        this.keyExpression = sExpression;
    }

    public List getHeaderList() {
        return this.headerList;
    }

    public SExpression getKeyExpression() {
        return this.keyExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyType() {
        return null;
    }

    public ExtendedPGPSecretKey getKeyData(PGPPublicKey pGPPublicKey, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator, int n) throws PGPException, IOException {
        int n2 = SExprParser.getProtectionType(this.keyExpression.getString(0));
        ArrayList<PGPExtendedKeyAttribute> arrayList = new ArrayList<PGPExtendedKeyAttribute>();
        if (n2 == 1 || n2 == 2 || n2 == 3) {
            SExpression sExpression = this.getKeyExpression().getExpression(1);
            String string = sExpression.getString(0);
            PublicKeyAlgorithmTags[] publicKeyAlgorithmTagsArray = SExprParser.getPGPSecretKey(pBEProtectionRemoverFactory, keyFingerPrintCalculator, pGPPublicKey, n, n2, sExpression, string, pGPDigestCalculatorProvider);
            if (string.equals("rsa")) {
                Iterator iterator = sExpression.filterOut(new String[]{"rsa", "e", "n", "d", "p", "q", "u", "protected"}).getValues().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof SExpression) {
                        arrayList.add(((SExpression)e).toAttribute());
                        continue;
                    }
                    arrayList.add(PGPExtendedKeyAttribute.builder().addAttribute(e).build());
                }
            }
            return new ExtendedPGPSecretKey(this.headerList, arrayList, (SecretKeyPacket)publicKeyAlgorithmTagsArray[0], (PGPPublicKey)publicKeyAlgorithmTagsArray[1]);
        }
        return null;
    }

    public static class Builder {
        private List headerList = new ArrayList();
        private SExpression keyExpression;

        public Builder setHeaderList(List list) {
            this.headerList = list;
            return this;
        }

        public Builder setKeyExpression(SExpression sExpression) {
            this.keyExpression = sExpression;
            return this;
        }

        public OpenedPGPKeyData build() {
            return new OpenedPGPKeyData(this.headerList, this.keyExpression);
        }

        public void add(PGPExtendedKeyHeader pGPExtendedKeyHeader) {
            this.headerList.add(pGPExtendedKeyHeader);
        }
    }
}

