/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.util.Characters;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public class SExpression {
    private static final Set labelStop = new HashSet(){
        {
            this.add(Characters.valueOf((char)' '));
            this.add(Characters.valueOf((char)')'));
            this.add(Characters.valueOf((char)'('));
            this.add(Characters.valueOf((char)'#'));
            this.add(Characters.valueOf((char)'\"'));
            this.add(Characters.valueOf((char)':'));
        }
    };
    private static final Set stringLabels = new HashSet(){
        {
            this.add("protected");
            this.add("protected-at");
            this.add("curve");
        }
    };
    private final ArrayList values = new ArrayList();
    private boolean canonical = false;
    private boolean parseCanonical = false;

    public SExpression(List list) {
        this.values.addAll(list);
    }

    public SExpression() {
    }

    public static SExpression parse(byte[] byArray, int n) throws IOException {
        return SExpression.parse(new ByteArrayInputStream(byArray), n);
    }

    public static SExpression parse(InputStream inputStream, int n) throws IOException {
        return SExpression.parseExpression(inputStream, null, new ByteArrayOutputStream(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SExpression parseExpression(InputStream inputStream, SExpression sExpression, ByteArrayOutputStream byteArrayOutputStream, int n) throws IOException {
        if (byteArrayOutputStream == null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        try {
            if (--n < 0) {
                throw new IllegalStateException("S-Expression exceeded maximum depth");
            }
            while (true) {
                int n2;
                if ((n2 = SExpression.consumeUntilSkipCRorLF(inputStream, byteArrayOutputStream, labelStop)) == 58) {
                    try {
                        int n3 = Integer.parseInt(Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray()));
                        byte[] byArray = new byte[n3];
                        Streams.readFully((InputStream)inputStream, (byte[])byArray);
                        if (sExpression.parseCanonical) {
                            int n4 = sExpression.values.size();
                            if (n4 > 0) {
                                Object e = sExpression.values.get(n4 - 1);
                                if (e instanceof String && stringLabels.contains(e)) {
                                    sExpression.addValue(Strings.fromUTF8ByteArray((byte[])byArray));
                                    continue;
                                }
                                sExpression.addValue(byArray);
                                continue;
                            }
                            sExpression.addValue(Strings.fromUTF8ByteArray((byte[])byArray));
                            continue;
                        }
                        sExpression.addValue(byArray);
                        sExpression.setCanonical(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        sExpression.addValue(byteArrayOutputStream.toByteArray());
                    }
                    continue;
                }
                if (byteArrayOutputStream.size() > 0) {
                    sExpression.addValue(Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray()));
                }
                if (n2 == 40) {
                    if (sExpression == null) {
                        sExpression = new SExpression();
                        SExpression.parseExpression(inputStream, sExpression, byteArrayOutputStream, n);
                        SExpression sExpression2 = sExpression;
                        return sExpression2;
                    }
                    SExpression sExpression3 = new SExpression();
                    sExpression3.parseCanonical = sExpression.parseCanonical;
                    sExpression.addValue(SExpression.parseExpression(inputStream, sExpression3, byteArrayOutputStream, n));
                    continue;
                }
                if (n2 == 35) {
                    SExpression.consumeUntilSkipWhiteSpace(inputStream, byteArrayOutputStream, '#');
                    sExpression.addValue(Hex.decode((String)Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray())));
                    continue;
                }
                if (n2 == 34) {
                    SExpression.consumeUntilSkipCRorLF(inputStream, byteArrayOutputStream, '\"');
                    sExpression.addValue(new QuotedString(Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray())));
                    continue;
                }
                if (n2 == 41) {
                    SExpression sExpression4 = sExpression;
                    return sExpression4;
                }
                if (n2 == -1) break;
            }
        }
        finally {
            ++n;
        }
        return sExpression;
    }

    static SExpression parseCanonical(InputStream inputStream, int n) throws IOException {
        SExpression sExpression = new SExpression();
        sExpression.parseCanonical = true;
        return SExpression.parseExpression(inputStream, sExpression, new ByteArrayOutputStream(), n).getExpression(0);
    }

    private static void consumeUntilSkipWhiteSpace(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, char c) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) > -1) {
            if (n <= 32) continue;
            if (n == c) {
                return;
            }
            byteArrayOutputStream.write(n);
        }
    }

    private static int consumeUntilSkipCRorLF(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, Set set) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        boolean bl = false;
        while ((n = inputStream.read()) > -1) {
            if (bl && n <= 32) {
                bl = false;
                continue;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            if (set.contains(Characters.valueOf((char)((char)n)))) {
                return n;
            }
            byteArrayOutputStream.write(n);
        }
        return -1;
    }

    private static int consumeUntilSkipCRorLF(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, char c) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        boolean bl = false;
        while ((n = inputStream.read()) > -1) {
            if (bl && n <= 32) {
                bl = false;
                continue;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            if (c == n) {
                return n;
            }
            byteArrayOutputStream.write(n);
        }
        return -1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addValue(Object object) {
        this.values.add(object);
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public String getString(int n) {
        Object e = this.values.get(n);
        if (e instanceof byte[]) {
            return Strings.fromUTF8ByteArray((byte[])((byte[])e));
        }
        return this.values.get(n).toString();
    }

    public int getInt(int n) {
        return Integer.parseInt(this.getString(n));
    }

    public byte[] getBytes(int n) {
        return (byte[])this.values.get(n);
    }

    public SExpression getExpression(int n) {
        return (SExpression)this.values.get(n);
    }

    public List getValues() {
        return this.values;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    private void setCanonical(boolean bl) {
        this.canonical = bl;
    }

    public PGPExtendedKeyAttribute toAttribute() {
        PGPExtendedKeyAttribute.Builder builder = PGPExtendedKeyAttribute.builder();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            builder.addAttribute(iterator.next());
        }
        return builder.build();
    }

    public SExpression filterOut(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SExpression sExpression = new SExpression();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashSet.contains(e.toString())) continue;
            if (e instanceof SExpression) {
                String string;
                if (!((SExpression)e).values.isEmpty() && hashSet.contains(string = ((SExpression)e).values.get(0).toString())) continue;
                sExpression.values.add(((SExpression)e).filterOut(stringArray));
                continue;
            }
            sExpression.values.add(e);
        }
        return sExpression;
    }

    static SExpression buildExpression(SExpression sExpression, String[] stringArray) {
        SExpression sExpression2 = new SExpression();
        sExpression2.addValue(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            SExpression sExpression3 = sExpression.getExpressionWithLabel(stringArray[i]);
            if (sExpression3 == null) continue;
            sExpression2.values.add(sExpression3);
        }
        return sExpression2;
    }

    static SExpression buildExpression(SExpression sExpression, SExpression sExpression2, String[] stringArray) {
        SExpression sExpression3 = new SExpression();
        sExpression3.addValue(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            SExpression sExpression4 = sExpression.getExpressionWithLabel(stringArray[i]);
            if (sExpression4 != null) {
                sExpression3.values.add(sExpression4);
                continue;
            }
            sExpression4 = sExpression2.getExpressionWithLabel(stringArray[i]);
            if (sExpression4 == null) continue;
            sExpression3.values.add(sExpression4);
        }
        return sExpression3;
    }

    public SExpression filterIn(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SExpression sExpression = new SExpression();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof SExpression) {
                String string;
                if (!((SExpression)e).values.isEmpty() && !hashSet.contains(string = ((SExpression)e).values.get(0).toString())) continue;
                sExpression.values.add(e);
                continue;
            }
            if (!hashSet.contains(e.toString())) continue;
            sExpression.values.add(e);
        }
        return sExpression;
    }

    public byte[] toCanonicalForm() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toCanonicalForm(byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new PGPRuntimeOperationException(exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void toCanonicalForm(OutputStream outputStream) throws IOException {
        outputStream.write(40);
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof QuotedString) {
                object = ((QuotedString)e).value;
                outputStream.write(Strings.toByteArray((String)Integer.toString(((String)object).length())));
                outputStream.write(58);
                outputStream.write(Strings.toUTF8ByteArray((String)object));
                continue;
            }
            if (e instanceof String) {
                object = (String)e;
                outputStream.write(Strings.toByteArray((String)Integer.toString(((String)object).length())));
                outputStream.write(58);
                outputStream.write(Strings.toUTF8ByteArray((String)object));
                continue;
            }
            if (e instanceof byte[]) {
                object = (byte[])e;
                outputStream.write(Strings.toByteArray((String)Integer.toString(((Object)object).length)));
                outputStream.write(58);
                outputStream.write((byte[])object);
                continue;
            }
            if (e instanceof SExpression) {
                ((SExpression)e).toCanonicalForm(outputStream);
                continue;
            }
            throw new IllegalStateException("unhandled type " + e.getClass().getName() + " in value list");
        }
        outputStream.write(41);
        outputStream.flush();
    }

    public boolean hasLabel(String string) {
        if (this.values.isEmpty()) {
            throw new IllegalArgumentException("S-Expression is empty");
        }
        Object object = this.values.get(0);
        object = object instanceof String || object instanceof QuotedString ? object.toString() : Strings.fromByteArray((byte[])((byte[])object));
        return object.equals(string);
    }

    public SExpression getExpressionWithLabel(String string) {
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SExpression) || !((SExpression)e).hasLabel(string)) continue;
            return (SExpression)e;
        }
        return null;
    }

    public SExpression getExpressionWithLabelOrFail(String string) {
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SExpression) || !((SExpression)e).hasLabel(string)) continue;
            return (SExpression)e;
        }
        throw new IllegalArgumentException("label " + string + " was not found");
    }

    public static class Builder {
        List values = new ArrayList();

        public Builder addValue(Object object) {
            this.values.add(object);
            return this;
        }

        public SExpression build() {
            return new SExpression(this.values);
        }

        public Builder addContent(SExpression sExpression) {
            Iterator iterator = sExpression.values.iterator();
            while (iterator.hasNext()) {
                this.values.add(iterator.next());
            }
            return this;
        }
    }

    public static class QuotedString {
        private final String value;

        public QuotedString(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

