/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        super(passPhrase, s2kDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase) {
        this(passPhrase, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, S2K.Argon2Params argon2Params) {
        super(passPhrase, argon2Params);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        super(passPhrase, s2kDigestCalculator, s2kCount);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, int s2kCount) {
        super(passPhrase, new SHA1PGPDigestCalculator(), s2kCount);
    }

    @Override
    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        super.setSecureRandom(random);
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(int encAlgorithm, byte[] key, byte[] sessionInfo) throws PGPException {
        try {
            BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
            return BcUtil.processBufferedBlockCipher(true, engine, key, new byte[engine.getBlockSize()], sessionInfo, 0, sessionInfo.length);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("encryption failed: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    protected byte[] generateV6KEK(int kekAlgorithm, byte[] ikm, byte[] info) {
        return BcAEADUtil.generateHKDFBytes(ikm, null, info, SymmetricKeyUtils.getKeyLengthInOctets(kekAlgorithm));
    }

    @Override
    protected byte[] getEskAndTag(int kekAlgorithm, int aeadAlgorithm, byte[] sessionKey, byte[] key, byte[] iv, byte[] info) throws PGPException {
        return BcAEADUtil.processAEADData(true, kekAlgorithm, aeadAlgorithm, key, iv, info, sessionKey, 0, sessionKey.length, "cannot encrypt session info");
    }
}

