/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import org.bouncycastle.bcpg.GnuExtendedS2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class GnuDivertToCardSecretKeyEncryptor
extends PBESecretKeyEncryptor {
    private byte[] serial;

    public GnuDivertToCardSecretKeyEncryptor(PGPDigestCalculator s2kDigestCalculator, byte[] serial) {
        super(0, s2kDigestCalculator, 0, null, null);
        this.s2k = new GnuExtendedS2K(2);
        this.serial = new byte[serial.length + 1];
        this.serial[0] = (byte)serial.length;
        System.arraycopy(serial, 0, this.serial, 1, serial.length);
    }

    @Override
    public byte[] encryptKeyData(byte[] key, byte[] keyData, int keyOff, int keyLen) throws PGPException {
        if (this.serial != null && this.serial.length > 16) {
            byte[] result = new byte[17];
            System.arraycopy(this.serial, 0, result, 0, result.length);
            return result;
        }
        return this.serial;
    }

    @Override
    public byte[] getKey() throws PGPException {
        return null;
    }

    @Override
    public byte[] getCipherIV() {
        return new byte[0];
    }
}

