/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.exception.MalformedOpenPGPSignatureException;
import org.bouncycastle.openpgp.api.util.UTCUtil;
import org.bouncycastle.util.encoders.Hex;

public abstract class OpenPGPSignature {
    protected final PGPSignature signature;
    protected final OpenPGPCertificate.OpenPGPComponentKey issuer;
    protected boolean isTested = false;
    protected boolean isCorrect = false;

    public OpenPGPSignature(PGPSignature signature, OpenPGPCertificate.OpenPGPComponentKey issuer) {
        this.signature = signature;
        this.issuer = issuer;
    }

    public PGPSignature getSignature() {
        return this.signature;
    }

    public OpenPGPCertificate.OpenPGPComponentKey getIssuer() {
        return this.issuer;
    }

    public OpenPGPCertificate getIssuerCertificate() {
        return this.issuer != null ? this.issuer.getCertificate() : null;
    }

    public List<KeyIdentifier> getKeyIdentifiers() {
        return this.signature.getKeyIdentifiers();
    }

    public KeyIdentifier getKeyIdentifier() {
        List<KeyIdentifier> identifiers = this.getKeyIdentifiers();
        return OpenPGPSignature.getMostExpressiveIdentifier(identifiers);
    }

    public static KeyIdentifier getMostExpressiveIdentifier(List<KeyIdentifier> identifiers) {
        if (identifiers.isEmpty()) {
            return null;
        }
        if (identifiers.size() == 1) {
            return identifiers.get(0);
        }
        for (KeyIdentifier identifier : identifiers) {
            if (identifier.isWildcard() || identifier.getFingerprint() == null) continue;
            return identifier;
        }
        for (KeyIdentifier identifier : identifiers) {
            if (identifier.isWildcard()) continue;
            return identifier;
        }
        return identifiers.get(0);
    }

    public boolean isTestedCorrect() {
        return this.isTested && this.isCorrect;
    }

    public Date getCreationTime() {
        return this.signature.getCreationTime();
    }

    public Date getExpirationTime() {
        PGPSignatureSubpacketVector hashed = this.signature.getHashedSubPackets();
        if (hashed == null) {
            return null;
        }
        long exp = hashed.getSignatureExpirationTime();
        if (exp < 0L) {
            throw new RuntimeException("Negative expiration time");
        }
        if (exp == 0L) {
            return null;
        }
        return new Date(this.getCreationTime().getTime() + 1000L * exp);
    }

    public boolean isEffectiveAt(Date evaluationTime) {
        if (this.isHardRevocation()) {
            return true;
        }
        Date creation = this.getCreationTime();
        Date expiration = this.getExpirationTime();
        return !evaluationTime.before(creation) && (expiration == null || evaluationTime.before(expiration));
    }

    public boolean isHardRevocation() {
        return this.signature.isHardRevocation();
    }

    public boolean isCertification() {
        return this.signature.isCertification();
    }

    void sanitize(OpenPGPCertificate.OpenPGPComponentKey issuer, OpenPGPPolicy policy) throws PGPSignatureException {
        if (!policy.isAcceptablePublicKey(issuer.getPGPPublicKey())) {
            throw new PGPSignatureException("Unacceptable issuer key.");
        }
        if (!policy.hasAcceptableSignatureHashAlgorithm(this.signature)) {
            throw new PGPSignatureException("Unacceptable hash algorithm: " + this.signature.getHashAlgorithm());
        }
        if (this.signature.getVersion() < 4) {
            if (this.signature.getCreationTime().before(issuer.getCreationTime())) {
                throw new MalformedOpenPGPSignatureException(this, "Signature predates issuer key creation time.");
            }
            return;
        }
        PGPSignatureSubpacketVector hashed = this.signature.getHashedSubPackets();
        if (hashed == null) {
            throw new MalformedOpenPGPSignatureException(this, "Missing hashed signature subpacket area.");
        }
        PGPSignatureSubpacketVector unhashed = this.signature.getUnhashedSubPackets();
        if (hashed.getSignatureCreationTime() == null) {
            throw new MalformedOpenPGPSignatureException(this, "Signature does not have a hashed SignatureCreationTime subpacket.");
        }
        if (hashed.getSignatureCreationTime().before(issuer.getCreationTime())) {
            throw new MalformedOpenPGPSignatureException(this, "Signature predates issuer key creation time.");
        }
        NotationData[] notations = hashed.getNotationDataOccurrences();
        for (int i = 0; i < notations.length; ++i) {
            NotationData notation = notations[i];
            if (!notation.isCritical()) continue;
            throw new MalformedOpenPGPSignatureException(this, "Critical unknown NotationData encountered: " + notation.getNotationName());
        }
        SignatureSubpacket[] signatureSubpackets = hashed.toArray();
        for (int i = 0; i != signatureSubpackets.length; ++i) {
            SignatureSubpacket unknownSubpacket = signatureSubpackets[i];
            if (!unknownSubpacket.isCritical() || !unknownSubpacket.getClass().equals(SignatureSubpacket.class)) continue;
            throw new MalformedOpenPGPSignatureException(this, "Critical hashed unknown SignatureSubpacket encountered: " + unknownSubpacket.getType());
        }
        switch (this.signature.getVersion()) {
            case 4: 
            case 5: {
                int type;
                if (hashed.getIssuerFingerprint() != null || unhashed.getIssuerFingerprint() != null || hashed.getSubpacket(16) != null || unhashed.getSubpacket(16) != null || (type = this.signature.getSignatureType()) == 24 || type == 25) break;
                throw new MalformedOpenPGPSignatureException(this, "Missing IssuerKeyID and IssuerFingerprint subpacket.");
            }
            case 6: {
                if (hashed.getSubpacket(16) != null) {
                    throw new MalformedOpenPGPSignatureException(this, "v6 signature MUST NOT contain IssuerKeyID subpacket.");
                }
                if (hashed.getIssuerFingerprint() != null || unhashed.getIssuerFingerprint() != null) break;
                throw new MalformedOpenPGPSignatureException(this, "v6 signature MUST contain IssuerFingerprint subpacket.");
            }
        }
    }

    public boolean isRevocation() {
        return PGPSignature.isRevocation(this.signature.getSignatureType());
    }

    public String toString() {
        String issuerInfo = this.getIssuerDisplay();
        String period = UTCUtil.format(this.getCreationTime()) + (this.getExpirationTime() == null ? "" : ">" + UTCUtil.format(this.getExpirationTime()));
        String validity = this.isTested ? (this.isCorrect ? "\u2713" : "\u2717") : "\u2753";
        return this.getType() + (this.signature.isHardRevocation() ? "(hard)" : "") + " " + Hex.toHexString((byte[])this.signature.getDigestPrefix()) + " " + issuerInfo + " -> " + this.getTargetDisplay() + " (" + period + ") " + validity;
    }

    protected String getIssuerDisplay() {
        if (this.issuer != null) {
            return this.issuer.toString();
        }
        KeyIdentifier issuerIdentifier = this.getKeyIdentifier();
        if (issuerIdentifier == null) {
            return "External[unknown]";
        }
        if (issuerIdentifier.isWildcard()) {
            return "Anonymous";
        }
        return "External[" + Long.toHexString(issuerIdentifier.getKeyId()).toUpperCase(Locale.getDefault()) + "]";
    }

    protected abstract String getTargetDisplay();

    protected String getType() {
        switch (this.signature.getSignatureType()) {
            case 0: {
                return "BINARY_DOCUMENT";
            }
            case 1: {
                return "CANONICAL_TEXT_DOCUMENT";
            }
            case 2: {
                return "STANDALONE";
            }
            case 16: {
                return "DEFAULT_CERTIFICATION";
            }
            case 17: {
                return "NO_CERTIFICATION";
            }
            case 18: {
                return "CASUAL_CERTIFICATION";
            }
            case 19: {
                return "POSITIVE_CERTIFICATION";
            }
            case 24: {
                return "SUBKEY_BINDING";
            }
            case 25: {
                return "PRIMARYKEY_BINDING";
            }
            case 31: {
                return "DIRECT_KEY";
            }
            case 32: {
                return "KEY_REVOCATION";
            }
            case 40: {
                return "SUBKEY_REVOCATION";
            }
            case 48: {
                return "CERTIFICATION_REVOCATION";
            }
            case 64: {
                return "TIMESTAMP";
            }
            case 80: {
                return "THIRD_PARTY_CONFIRMATION";
            }
        }
        return "UNKNOWN (" + this.signature.getSignatureType() + ")";
    }

    public String toAsciiArmoredString() throws IOException {
        return this.toAsciiArmoredString(PacketFormat.ROUNDTRIP);
    }

    public String toAsciiArmoredString(PacketFormat packetFormat) throws IOException {
        ArmoredOutputStream.Builder armorBuilder = ArmoredOutputStream.builder().clearHeaders();
        if (this.getKeyIdentifier() != null) {
            armorBuilder.addSplitMultilineComment(this.getKeyIdentifier().toPrettyPrint());
        }
        return this.toAsciiArmoredString(packetFormat, armorBuilder);
    }

    public String toAsciiArmoredString(PacketFormat packetFormat, ArmoredOutputStream.Builder armorBuilder) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ArmoredOutputStream aOut = armorBuilder.build(bOut);
        aOut.write(this.getEncoded(packetFormat));
        aOut.close();
        return bOut.toString();
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat packetFormat) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)bOut, packetFormat);
        this.signature.encode(pOut);
        pOut.close();
        return bOut.toByteArray();
    }

    public static class OpenPGPDocumentSignature
    extends OpenPGPSignature {
        protected final OpenPGPDocumentSignature attestedSignature;

        public OpenPGPDocumentSignature(PGPSignature signature, OpenPGPCertificate.OpenPGPComponentKey issuer) {
            super(signature, issuer);
            this.attestedSignature = null;
        }

        @Override
        protected String getTargetDisplay() {
            return "<document>";
        }

        public OpenPGPDocumentSignature(PGPSignature signature, OpenPGPCertificate.OpenPGPComponentKey issuer, OpenPGPDocumentSignature attestedSignature) {
            super(signature, issuer);
            this.attestedSignature = attestedSignature;
        }

        public int getSignatureLevel() {
            if (this.attestedSignature == null) {
                return 0;
            }
            return 1 + this.attestedSignature.getSignatureLevel();
        }

        public OpenPGPDocumentSignature getAttestedSignature() {
            return this.attestedSignature;
        }

        public boolean verify(PGPOnePassSignature ops) throws PGPException {
            this.isTested = true;
            this.isCorrect = ops.verify(this.signature);
            return this.isCorrect;
        }

        public boolean verify() throws PGPException {
            this.isTested = true;
            this.isCorrect = this.signature.verify();
            return this.isCorrect;
        }

        public boolean isValid() throws PGPSignatureException {
            return this.isValid(OpenPGPImplementation.getInstance().policy());
        }

        public boolean isValid(OpenPGPPolicy policy) throws PGPSignatureException {
            return this.isValidAt(this.getCreationTime(), policy);
        }

        public boolean isValidAt(Date date) throws PGPSignatureException {
            return this.isValidAt(date, OpenPGPImplementation.getInstance().policy());
        }

        public boolean isValidAt(Date date, OpenPGPPolicy policy) throws PGPSignatureException {
            if (!this.isTested) {
                throw new IllegalStateException("Signature has not yet been verified.");
            }
            if (!this.isTestedCorrect()) {
                return false;
            }
            this.sanitize(this.issuer, policy);
            return this.issuer.getCertificate().getPrimaryKey().isBoundAt(date) && this.issuer.isBoundAt(date) && this.issuer.isSigningKey(date);
        }

        public boolean createdInBounds(Date notBefore, Date notAfter) {
            return !this.getCreationTime().before(notBefore) && !this.getCreationTime().after(notAfter);
        }
    }

    public static final class OpenPGPSignatureSubpacket {
        private final SignatureSubpacket subpacket;
        private final OpenPGPSignature signature;
        private final boolean hashed;

        private OpenPGPSignatureSubpacket(SignatureSubpacket subpacket, OpenPGPSignature signature, boolean hashed) {
            this.signature = signature;
            this.subpacket = subpacket;
            this.hashed = hashed;
        }

        public static OpenPGPSignatureSubpacket hashed(SignatureSubpacket subpacket, OpenPGPSignature signature) {
            return new OpenPGPSignatureSubpacket(subpacket, signature, true);
        }

        public static OpenPGPSignatureSubpacket unhashed(SignatureSubpacket subpacket, OpenPGPSignature signature) {
            return new OpenPGPSignatureSubpacket(subpacket, signature, false);
        }

        public OpenPGPSignature getSignature() {
            return this.signature;
        }

        public SignatureSubpacket getSubpacket() {
            return this.subpacket;
        }

        public boolean isHashed() {
            return this.hashed;
        }
    }
}

