/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.util.Arrays;

public interface KeyPassphraseProvider {
    public char[] getKeyPassword(OpenPGPKey.OpenPGPSecretKey var1);

    public static class DefaultKeyPassphraseProvider
    implements KeyPassphraseProvider {
        private final Map<OpenPGPKey.OpenPGPSecretKey, char[]> passphraseMap = new HashMap<OpenPGPKey.OpenPGPSecretKey, char[]>();
        private final List<char[]> allPassphrases = new ArrayList<char[]>();
        private KeyPassphraseProvider callback;

        public DefaultKeyPassphraseProvider() {
        }

        public DefaultKeyPassphraseProvider(OpenPGPKey key, char[] passphrase) {
            this.allPassphrases.add(passphrase);
            for (OpenPGPKey.OpenPGPSecretKey subkey : key.getSecretKeys().values()) {
                this.passphraseMap.put(subkey, passphrase);
            }
        }

        @Override
        public char[] getKeyPassword(OpenPGPKey.OpenPGPSecretKey key) {
            if (!key.isLocked()) {
                this.passphraseMap.put(key, null);
                return null;
            }
            char[] passphrase = this.passphraseMap.get(key);
            if (passphrase != null) {
                return passphrase;
            }
            for (char[] knownPassphrase : this.allPassphrases) {
                if (!key.isPassphraseCorrect(knownPassphrase)) continue;
                this.addPassphrase(key, knownPassphrase);
                return knownPassphrase;
            }
            if (this.callback != null) {
                passphrase = this.callback.getKeyPassword(key);
                this.addPassphrase(key, passphrase);
            }
            return passphrase;
        }

        public DefaultKeyPassphraseProvider addPassphrase(char[] passphrase) {
            boolean found = false;
            for (char[] existing : this.allPassphrases) {
                found |= Arrays.areEqual((char[])existing, (char[])passphrase);
            }
            if (!found) {
                this.allPassphrases.add(passphrase);
            }
            return this;
        }

        public DefaultKeyPassphraseProvider addPassphrase(OpenPGPKey key, char[] passphrase) {
            for (OpenPGPKey.OpenPGPSecretKey subkey : key.getSecretKeys().values()) {
                if (!subkey.isLocked()) {
                    this.passphraseMap.put(subkey, null);
                    continue;
                }
                char[] existentPassphrase = this.passphraseMap.get(subkey);
                if (existentPassphrase != null && subkey.isPassphraseCorrect(existentPassphrase)) continue;
                this.passphraseMap.put(subkey, passphrase);
            }
            return this;
        }

        public DefaultKeyPassphraseProvider addPassphrase(OpenPGPKey.OpenPGPSecretKey key, char[] passphrase) {
            if (!key.isLocked()) {
                this.passphraseMap.put(key, null);
                return this;
            }
            this.passphraseMap.put(key, passphrase);
            return this;
        }

        public DefaultKeyPassphraseProvider setMissingPassphraseCallback(KeyPassphraseProvider callback) {
            this.callback = callback;
            return this;
        }
    }
}

