/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Integers;

public class KeyFlags
extends SignatureSubpacket {
    public static final int CERTIFY_OTHER = 1;
    public static final int SIGN_DATA = 2;
    public static final int ENCRYPT_COMMS = 4;
    public static final int ENCRYPT_STORAGE = 8;
    public static final int SPLIT = 16;
    public static final int AUTHENTICATION = 32;
    public static final int SHARED = 128;

    private static int dataToFlags(byte[] data) {
        int flags = 0;
        int bytes = Math.min(4, data.length);
        for (int i = 0; i < bytes; ++i) {
            flags |= (data[i] & 0xFF) << i * 8;
        }
        return flags;
    }

    private static byte[] flagsToData(int flags) {
        int bits = 32 - Integers.numberOfLeadingZeros((int)flags);
        int bytes = (bits + 7) / 8;
        byte[] data = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            data[i] = (byte)(flags >> i * 8);
        }
        return data;
    }

    public KeyFlags(boolean critical, boolean isLongLength, byte[] data) {
        super(27, critical, isLongLength, data);
    }

    public KeyFlags(boolean critical, int flags) {
        super(27, critical, false, KeyFlags.flagsToData(flags));
    }

    public int getFlags() {
        return KeyFlags.dataToFlags(this.data);
    }
}

