/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

class OperatorHelper {
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper helper) {
        this.helper = helper;
    }

    String getDigestName(int hashAlgorithm) throws PGPException {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA-1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA-256";
            }
            case 9: {
                return "SHA-384";
            }
            case 10: {
                return "SHA-512";
            }
            case 11: {
                return "SHA-224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + hashAlgorithm);
    }

    MessageDigest createDigest(int algorithm) throws GeneralSecurityException, PGPException {
        MessageDigest dig;
        String digestName = this.getDigestName(algorithm);
        try {
            dig = this.helper.createMessageDigest(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            if (algorithm >= 8 && algorithm <= 11) {
                dig = this.helper.createMessageDigest("SHA" + digestName.substring(4));
            }
            throw e;
        }
        return dig;
    }

    KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException, PGPException {
        return this.helper.createKeyFactory(algorithm);
    }

    public KeyAgreement createKeyAgreement(String algorithm) throws GeneralSecurityException {
        return this.helper.createKeyAgreement(algorithm);
    }

    public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        return this.helper.createKeyPairGenerator(algorithm);
    }

    PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            final Cipher c = this.createStreamCipher(encAlgorithm, withIntegrityPacket);
            if (withIntegrityPacket) {
                byte[] iv = new byte[c.getBlockSize()];
                c.init(2, (Key)secretKey, new IvParameterSpec(iv));
            } else {
                c.init(2, secretKey);
            }
            return new PGPDataDecryptor(){

                @Override
                public InputStream getInputStream(InputStream in) {
                    return new CipherInputStream(in, c);
                }

                @Override
                public int getBlockSize() {
                    return c.getBlockSize();
                }

                @Override
                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    Cipher createStreamCipher(int encAlgorithm, boolean withIntegrityPacket) throws PGPException {
        String mode = withIntegrityPacket ? "CFB" : "OpenPGPCFB";
        String cName = PGPUtil.getSymmetricCipherName(encAlgorithm) + "/" + mode + "/NoPadding";
        return this.createCipher(cName);
    }

    static long getChunkLength(int chunkSize) {
        return 1L << chunkSize + 6;
    }

    static byte[] getNonce(byte[] iv, long chunkIndex) {
        byte[] nonce = Arrays.clone((byte[])iv);
        OperatorHelper.xorChunkId(nonce, chunkIndex);
        return nonce;
    }

    static void xorChunkId(byte[] nonce, long chunkIndex) {
        int index = nonce.length - 8;
        int n = index++;
        nonce[n] = (byte)(nonce[n] ^ (byte)(chunkIndex >> 56));
        int n2 = index++;
        nonce[n2] = (byte)(nonce[n2] ^ (byte)(chunkIndex >> 48));
        int n3 = index++;
        nonce[n3] = (byte)(nonce[n3] ^ (byte)(chunkIndex >> 40));
        int n4 = index++;
        nonce[n4] = (byte)(nonce[n4] ^ (byte)(chunkIndex >> 32));
        int n5 = index++;
        nonce[n5] = (byte)(nonce[n5] ^ (byte)(chunkIndex >> 24));
        int n6 = index++;
        nonce[n6] = (byte)(nonce[n6] ^ (byte)(chunkIndex >> 16));
        int n7 = index++;
        nonce[n7] = (byte)(nonce[n7] ^ (byte)(chunkIndex >> 8));
        int n8 = index;
        nonce[n8] = (byte)(nonce[n8] ^ (byte)chunkIndex);
    }

    PGPDataDecryptor createDataDecryptor(final int aeadAlgorithm, final byte[] iv, final int chunkSize, final int encAlgorithm, byte[] key) throws PGPException {
        try {
            final SecretKeySpec secretKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            final Cipher c = this.createAEADCipher(encAlgorithm, aeadAlgorithm);
            return new PGPDataDecryptor(){

                @Override
                public InputStream getInputStream(InputStream in) {
                    try {
                        return new PGPAeadInputStream(in, c, secretKey, iv, encAlgorithm, aeadAlgorithm, chunkSize);
                    }
                    catch (IOException e) {
                        throw Exceptions.illegalStateException((String)("unable to open stream: " + e.getMessage()), (Throwable)e);
                    }
                }

                @Override
                public int getBlockSize() {
                    return c.getBlockSize();
                }

                @Override
                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    Cipher createAEADCipher(int encAlgorithm, int aeadAlgorithm) throws PGPException {
        String mode;
        switch (aeadAlgorithm) {
            case 1: {
                mode = "EAX";
                break;
            }
            case 2: {
                mode = "OCB";
                break;
            }
            case 3: {
                mode = "GCM";
                break;
            }
            default: {
                throw new PGPException("encountered unknown AEAD algorithm: " + aeadAlgorithm);
            }
        }
        String cName = PGPUtil.getSymmetricCipherName(encAlgorithm) + "/" + mode + "/NoPadding";
        return this.createCipher(cName);
    }

    Cipher createCipher(String cipherName) throws PGPException {
        try {
            return this.helper.createCipher(cipherName);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    Cipher createPublicKeyCipher(int encAlgorithm) throws PGPException {
        switch (encAlgorithm) {
            case 1: 
            case 2: {
                return this.createCipher("RSA/ECB/PKCS1Padding");
            }
            case 16: 
            case 20: {
                return this.createCipher("ElGamal/ECB/PKCS1Padding");
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 22: {
                throw new PGPException("Can't use EDDSA for encryption.");
            }
        }
        throw new PGPException("unknown asymmetric algorithm: " + encAlgorithm);
    }

    Cipher createKeyWrapper(int encAlgorithm) throws PGPException {
        try {
            switch (encAlgorithm) {
                case 7: 
                case 8: 
                case 9: {
                    return this.helper.createCipher("AESWrap");
                }
                case 11: 
                case 12: 
                case 13: {
                    return this.helper.createCipher("CamelliaWrap");
                }
            }
            throw new PGPException("unknown wrap algorithm: " + encAlgorithm);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    private Signature createSignature(String cipherName) throws PGPException {
        try {
            return this.helper.createSignature(cipherName);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create signature: " + e.getMessage(), e);
        }
    }

    public Signature createSignature(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        String encAlg;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                encAlg = "RSA";
                break;
            }
            case 17: {
                encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                encAlg = "ElGamal";
                break;
            }
            case 19: {
                encAlg = "ECDSA";
                break;
            }
            case 22: {
                return this.createSignature("Ed25519");
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return this.createSignature(PGPUtil.getDigestName(hashAlgorithm) + "with" + encAlg);
    }

    public AlgorithmParameters createAlgorithmParameters(String algorithm) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.helper.createAlgorithmParameters(algorithm);
    }

    private static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadInputStream(InputStream in, Cipher c, SecretKey secretKey, byte[] iv, int encAlgorithm, int aeadAlgorithm, int chunkSize) throws IOException {
            this.in = in;
            this.iv = iv;
            this.chunkLength = (int)OperatorHelper.getChunkLength(chunkSize);
            this.buf = new byte[this.chunkLength + 32];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)encAlgorithm;
            this.aaData[3] = (byte)aeadAlgorithm;
            this.aaData[4] = (byte)chunkSize;
            Streams.readFully((InputStream)in, (byte[])this.buf, (int)0, (int)32);
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int supplyLen = Math.min(len, this.available());
            System.arraycopy(this.data, this.dataOff, b, off, supplyLen);
            this.dataOff += supplyLen;
            return supplyLen;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skip = (int)Math.min(n, (long)this.available());
            this.dataOff += skip;
            return skip;
        }

        @Override
        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            byte[] decData;
            int dataLen = Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)32, (int)this.chunkLength);
            if (dataLen == 0) {
                return null;
            }
            byte[] adata = new byte[13];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            OperatorHelper.xorChunkId(adata, this.chunkIndex);
            try {
                this.c.init(2, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                this.c.updateAAD(adata);
                decData = this.c.doFinal(this.buf, 0, dataLen + 16);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)decData.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, dataLen + 16, this.buf, 0, 16);
            if (dataLen != this.chunkLength) {
                adata = new byte[13];
                System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
                OperatorHelper.xorChunkId(adata, this.chunkIndex);
                try {
                    this.c.init(2, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                    this.c.updateAAD(adata);
                    this.c.updateAAD(Pack.longToBigEndian((long)this.totalBytes));
                    this.c.doFinal(this.buf, 0, 16);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException("exception processing final tag: " + e.getMessage());
                }
            } else {
                Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)16, (int)16);
            }
            return decData;
        }
    }

    static class PGPAeadOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final byte[] data;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(OutputStream out, Cipher c, SecretKey secretKey, int encAlgorithm, int aeadAlgorithm, int chunkSize, byte[] iv) {
            this.out = out;
            this.iv = iv;
            this.chunkLength = (int)OperatorHelper.getChunkLength(chunkSize);
            this.data = new byte[this.chunkLength];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)encAlgorithm;
            this.aaData[3] = (byte)aeadAlgorithm;
            this.aaData[4] = (byte)chunkSize;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (len < this.data.length - this.dataOff) {
                System.arraycopy(b, off, this.data, this.dataOff, len);
                this.dataOff += len;
            } else {
                int gap = this.data.length - this.dataOff;
                System.arraycopy(b, off, this.data, this.dataOff, gap);
                this.dataOff += gap;
                this.writeBlock();
                len -= gap;
                off += gap;
                while (len >= this.data.length) {
                    System.arraycopy(b, off, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    len -= this.data.length;
                    off += this.data.length;
                }
                if (len > 0) {
                    System.arraycopy(b, off, this.data, 0, len);
                    this.dataOff = len;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            byte[] adata = new byte[13];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            OperatorHelper.xorChunkId(adata, this.chunkIndex);
            try {
                this.c.init(1, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                this.c.updateAAD(adata);
                this.out.write(this.c.doFinal(this.data, 0, this.dataOff));
            }
            catch (GeneralSecurityException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            byte[] adata = new byte[13];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            OperatorHelper.xorChunkId(adata, this.chunkIndex);
            try {
                this.c.init(1, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                this.c.updateAAD(adata);
                this.c.updateAAD(Pack.longToBigEndian((long)this.totalBytes));
                this.out.write(this.c.doFinal(this.aaData, 0, 0));
                this.out.close();
            }
            catch (GeneralSecurityException e) {
                throw new IOException("exception processing final tag: " + e.getMessage());
            }
        }
    }
}

