/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.jcajce;

import java.io.InputStream;
import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaAEADSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaCFBSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JceSessionKeyDataDecryptorFactoryBuilder;

public class JcaOpenPGPImplementation
extends OpenPGPImplementation {
    private final Provider provider;
    private final SecureRandom secureRandom;

    public JcaOpenPGPImplementation() {
        this((Provider)new BouncyCastleProvider(), CryptoServicesRegistrar.getSecureRandom());
    }

    public JcaOpenPGPImplementation(Provider provider, SecureRandom secureRandom) {
        this.provider = provider;
        this.secureRandom = secureRandom;
    }

    public PGPObjectFactory pgpObjectFactory(InputStream packetInputStream) {
        return new JcaPGPObjectFactory(packetInputStream).setThrowForUnknownCriticalPackets(true);
    }

    public PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider() {
        JcaPGPContentVerifierBuilderProvider p = new JcaPGPContentVerifierBuilderProvider();
        p.setProvider(this.provider);
        return p;
    }

    public PBESecretKeyDecryptorBuilderProvider pbeSecretKeyDecryptorBuilderProvider() {
        JcaPGPDigestCalculatorProviderBuilder dp = new JcaPGPDigestCalculatorProviderBuilder();
        dp.setProvider(this.provider);
        JcePBESecretKeyDecryptorBuilderProvider p = new JcePBESecretKeyDecryptorBuilderProvider(dp).setProvider(this.provider);
        return p;
    }

    public PGPDataEncryptorBuilder pgpDataEncryptorBuilder(int symmetricKeyAlgorithm) {
        JcePGPDataEncryptorBuilder b = new JcePGPDataEncryptorBuilder(symmetricKeyAlgorithm);
        b.setProvider(this.provider);
        b.setSecureRandom(this.secureRandom);
        return b;
    }

    public PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator(PGPPublicKey encryptionSubkey) {
        JcePublicKeyKeyEncryptionMethodGenerator g = new JcePublicKeyKeyEncryptionMethodGenerator(encryptionSubkey);
        g.setProvider(this.provider);
        g.setSecureRandom(this.secureRandom);
        return g;
    }

    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] messagePassphrase) {
        JcePBEKeyEncryptionMethodGenerator g = new JcePBEKeyEncryptionMethodGenerator(messagePassphrase);
        g.setProvider(this.provider);
        g.setSecureRandom(this.secureRandom);
        return g;
    }

    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] messagePassphrase, S2K.Argon2Params argon2Params) {
        JcePBEKeyEncryptionMethodGenerator g = new JcePBEKeyEncryptionMethodGenerator(messagePassphrase, argon2Params);
        g.setProvider(this.provider);
        g.setSecureRandom(this.secureRandom);
        return g;
    }

    public PGPContentSignerBuilder pgpContentSignerBuilder(int publicKeyAlgorithm, int hashAlgorithm) {
        JcaPGPContentSignerBuilder b = new JcaPGPContentSignerBuilder(publicKeyAlgorithm, hashAlgorithm);
        b.setProvider(this.provider);
        b.setDigestProvider(this.provider);
        b.setSecureRandom(this.secureRandom);
        return b;
    }

    public PBEDataDecryptorFactory pbeDataDecryptorFactory(char[] messagePassphrase) throws PGPException {
        return new JcePBEDataDecryptorFactoryBuilder(this.pgpDigestCalculatorProvider()).setProvider(this.provider).build(messagePassphrase);
    }

    public SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory(PGPSessionKey sessionKey) {
        return new JceSessionKeyDataDecryptorFactoryBuilder().setProvider(this.provider).build(sessionKey);
    }

    public PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory(PGPPrivateKey decryptionKey) {
        return new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(this.provider).setContentProvider(this.provider).build(decryptionKey);
    }

    public PGPDigestCalculatorProvider pgpDigestCalculatorProvider() throws PGPException {
        return new JcaPGPDigestCalculatorProviderBuilder().setProvider(this.provider).build();
    }

    public PGPKeyPairGeneratorProvider pgpKeyPairGeneratorProvider() {
        return new JcaPGPKeyPairGeneratorProvider().setProvider(this.provider).setSecureRandom(this.secureRandom);
    }

    public PGPContentSignerBuilderProvider pgpContentSignerBuilderProvider(int hashAlgorithmId) {
        return new JcaPGPContentSignerBuilderProvider(hashAlgorithmId).setSecurityProvider(this.provider).setDigestProvider(this.provider).setSecureRandom(this.secureRandom);
    }

    public KeyFingerPrintCalculator keyFingerPrintCalculator() {
        return new JcaKeyFingerprintCalculator().setProvider(this.provider);
    }

    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean aead) throws PGPException {
        if (aead) {
            return new JcaAEADSecretKeyEncryptorFactory().setProvider(this.provider);
        }
        return new JcaCFBSecretKeyEncryptorFactory(7, 96).setProvider(this.provider);
    }

    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean aead, int symmetricKeyAlgorithm, int iterationCount) throws PGPException {
        if (aead) {
            return new JcaAEADSecretKeyEncryptorFactory().setProvider(this.provider);
        }
        return new JcaCFBSecretKeyEncryptorFactory(symmetricKeyAlgorithm, iterationCount).setProvider(this.provider);
    }
}

