/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPDetachedSignatureGenerator;
import org.bouncycastle.openpgp.api.OpenPGPDetachedSignatureProcessor;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPKeyEditor;
import org.bouncycastle.openpgp.api.OpenPGPKeyGenerator;
import org.bouncycastle.openpgp.api.OpenPGPKeyReader;
import org.bouncycastle.openpgp.api.OpenPGPMessageGenerator;
import org.bouncycastle.openpgp.api.OpenPGPMessageProcessor;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;

public abstract class OpenPGPApi {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;

    public OpenPGPApi(OpenPGPImplementation implementation) {
        this(implementation, implementation.policy());
    }

    public OpenPGPApi(OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        this.implementation = implementation;
        this.policy = policy;
    }

    public OpenPGPKeyReader readKeyOrCertificate() {
        return new OpenPGPKeyReader(this.implementation, this.policy);
    }

    public OpenPGPKeyGenerator generateKey() throws PGPException {
        return this.generateKey(6);
    }

    public abstract OpenPGPKeyGenerator generateKey(int var1) throws PGPException;

    public OpenPGPKeyGenerator generateKey(Date creationTime) throws PGPException {
        return this.generateKey(6, creationTime);
    }

    public abstract OpenPGPKeyGenerator generateKey(int var1, Date var2) throws PGPException;

    public OpenPGPKeyGenerator generateKey(Date creationTime, boolean aeadProtection) throws PGPException {
        return this.generateKey(6, creationTime, aeadProtection);
    }

    public abstract OpenPGPKeyGenerator generateKey(int var1, Date var2, boolean var3) throws PGPException;

    public OpenPGPMessageGenerator signAndOrEncryptMessage() {
        return new OpenPGPMessageGenerator(this.implementation, this.policy);
    }

    public OpenPGPDetachedSignatureGenerator createDetachedSignature() {
        return new OpenPGPDetachedSignatureGenerator(this.implementation, this.policy);
    }

    public OpenPGPMessageProcessor decryptAndOrVerifyMessage() {
        return new OpenPGPMessageProcessor(this.implementation, this.policy);
    }

    public OpenPGPDetachedSignatureProcessor verifyDetachedSignature() {
        return new OpenPGPDetachedSignatureProcessor(this.implementation, this.policy);
    }

    public OpenPGPKeyEditor editKey(OpenPGPKey key) throws PGPException {
        return this.editKey(key, (char[])null);
    }

    public OpenPGPKeyEditor editKey(OpenPGPKey key, final char[] primaryKeyPassphrase) throws PGPException {
        return new OpenPGPKeyEditor(key, new KeyPassphraseProvider(){

            public char[] getKeyPassword(OpenPGPKey.OpenPGPSecretKey key) {
                return primaryKeyPassphrase;
            }
        }, this.implementation, this.policy);
    }

    public OpenPGPKeyEditor editKey(OpenPGPKey key, KeyPassphraseProvider primaryKeyPassphraseProvider) throws PGPException {
        return new OpenPGPKeyEditor(key, primaryKeyPassphraseProvider, this.implementation, this.policy);
    }

    public OpenPGPImplementation getImplementation() {
        return this.implementation;
    }
}

