/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.apache.bzip2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.apache.bzip2.BZip2Constants;
import org.bouncycastle.apache.bzip2.CBZip2OutputStream;
import org.bouncycastle.apache.bzip2.CRC;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private int bsBuff;
    private int bsLive;
    private final CRC blockCRC = new CRC();
    private int nInUse;
    private byte[] seqToUnseq = new byte[256];
    private byte[] selectors = new byte[18002];
    private int[] tt = null;
    private byte[] ll8 = null;
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][21];
    private int[][] base = new int[6][21];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private InputStream bsStream;
    private boolean streamEnd = false;
    private int currentByte = -1;
    private static final int RAND_PART_B_STATE = 1;
    private static final int RAND_PART_C_STATE = 2;
    private static final int NO_RAND_PART_B_STATE = 3;
    private static final int NO_RAND_PART_C_STATE = 4;
    private int currentState = 0;
    private int expectedBlockCRC;
    private int expectedStreamCRC;
    private int streamCRC;
    int i2;
    int count;
    int chPrev;
    int ch2;
    int i;
    int tPos;
    int rNToGo = 0;
    int rTPos = 0;
    int j2;
    int z;

    public CBZip2InputStream(InputStream zStream) throws IOException {
        this.bsStream = zStream;
        this.bsLive = 0;
        this.bsBuff = 0;
        int magic1 = this.bsStream.read();
        int magic2 = this.bsStream.read();
        int version = this.bsStream.read();
        int level = this.bsStream.read();
        if (level < 0) {
            throw new EOFException();
        }
        if (magic1 != 66 | magic2 != 90 | version != 104 | level < 49 | level > 57) {
            throw new IOException("Invalid stream header");
        }
        this.blockSize100k = level - 48;
        int n = 100000 * this.blockSize100k;
        this.ll8 = new byte[n];
        this.tt = new int[n];
        this.streamCRC = 0;
        this.beginBlock();
    }

    public void close() throws IOException {
        this.implClose(true);
    }

    public int read() throws IOException {
        if (this.streamEnd) {
            return -1;
        }
        int result = this.currentByte;
        switch (this.currentState) {
            case 1: {
                this.setupRandPartB();
                break;
            }
            case 2: {
                this.setupRandPartC();
                break;
            }
            case 3: {
                this.setupNoRandPartB();
                break;
            }
            case 4: {
                this.setupNoRandPartC();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    private void beginBlock() throws IOException {
        long magic48 = this.bsGetLong48();
        if (magic48 != 54156738319193L) {
            if (magic48 != 25779555029136L) {
                throw new IOException("Block header error");
            }
            this.expectedStreamCRC = this.bsGetInt32();
            if (this.expectedStreamCRC != this.streamCRC) {
                throw new IOException("Stream CRC error");
            }
            this.streamEnd = true;
            return;
        }
        this.expectedBlockCRC = this.bsGetInt32();
        boolean blockRandomised = this.bsGetBit() == 1;
        this.getAndMoveToFrontDecode();
        this.blockCRC.initialise();
        int[] cftab = new int[257];
        cftab[0] = 0;
        int accum = 0;
        this.i = 0;
        while (this.i < 256) {
            cftab[this.i + 1] = accum += this.unzftab[this.i];
            ++this.i;
        }
        if (accum != this.last + 1) {
            throw new IllegalStateException();
        }
        this.i = 0;
        while (this.i <= this.last) {
            int ch;
            int n = ch = this.ll8[this.i] & 0xFF;
            int n2 = cftab[n];
            cftab[n] = n2 + 1;
            this.tt[n2] = this.i++;
        }
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void endBlock() throws IOException {
        int blockFinalCRC = this.blockCRC.getFinal();
        if (this.expectedBlockCRC != blockFinalCRC) {
            throw new IOException("Block CRC error");
        }
        this.streamCRC = Integers.rotateLeft((int)this.streamCRC, (int)1) ^ blockFinalCRC;
    }

    private void implClose(boolean closeInput) throws IOException {
        if (this.bsStream != null) {
            if (closeInput) {
                this.bsStream.close();
            }
            this.bsStream = null;
        }
    }

    private int bsGetBit() throws IOException {
        if (this.bsLive == 0) {
            this.bsBuff = this.requireByte();
            this.bsLive = 7;
            return this.bsBuff >>> 7;
        }
        --this.bsLive;
        return this.bsBuff >>> this.bsLive & 1;
    }

    private int bsGetBits(int n) throws IOException {
        while (this.bsLive < n) {
            this.bsBuff = this.bsBuff << 8 | this.requireByte();
            this.bsLive += 8;
        }
        this.bsLive -= n;
        return this.bsBuff >>> this.bsLive & (1 << n) - 1;
    }

    private int bsGetBitsSmall(int n) throws IOException {
        if (this.bsLive < n) {
            this.bsBuff = this.bsBuff << 8 | this.requireByte();
            this.bsLive += 8;
        }
        this.bsLive -= n;
        return this.bsBuff >>> this.bsLive & (1 << n) - 1;
    }

    private int bsGetInt32() throws IOException {
        int u = this.bsGetBits(16) << 16;
        return u | this.bsGetBits(16);
    }

    private long bsGetLong48() throws IOException {
        long u = (long)this.bsGetBits(24) << 24;
        return u | (long)this.bsGetBits(24);
    }

    private void hbCreateDecodeTables(int[] limit, int[] base, int[] perm, byte[] length, int minLen, int maxLen, int alphaSize) {
        Arrays.fill((int[])base, (int)0);
        Arrays.fill((int[])limit, (int)0);
        int pp = 0;
        int baseVal = 0;
        for (int i = minLen; i <= maxLen; ++i) {
            for (int j = 0; j < alphaSize; ++j) {
                if ((length[j] & 0xFF) != i) continue;
                perm[pp++] = j;
            }
            base[i] = baseVal;
            limit[i] = baseVal + pp;
            baseVal += baseVal + pp;
        }
    }

    private int recvDecodingTables() throws IOException {
        int i;
        this.nInUse = 0;
        int inUse16 = this.bsGetBits(16);
        for (i = 0; i < 16; ++i) {
            if ((inUse16 & 32768 >>> i) == 0) continue;
            int inUse = this.bsGetBits(16);
            int i16 = i * 16;
            for (int j = 0; j < 16; ++j) {
                if ((inUse & 32768 >>> j) == 0) continue;
                this.seqToUnseq[this.nInUse++] = (byte)(i16 + j);
            }
        }
        if (this.nInUse < 1) {
            throw new IllegalStateException();
        }
        int alphaSize = this.nInUse + 2;
        int nGroups = this.bsGetBitsSmall(3);
        if (nGroups < 2 || nGroups > 6) {
            throw new IllegalStateException();
        }
        int nSelectors = this.bsGetBits(15);
        if (nSelectors < 1) {
            throw new IllegalStateException();
        }
        int mtfGroups = 5517840;
        for (i = 0; i < nSelectors; ++i) {
            int mtfSelector = 0;
            while (this.bsGetBit() == 1) {
                if (++mtfSelector < nGroups) continue;
                throw new IllegalStateException();
            }
            if (i >= 18002) continue;
            switch (mtfSelector) {
                case 0: {
                    break;
                }
                case 1: {
                    mtfGroups = mtfGroups >>> 4 & 0xF | mtfGroups << 4 & 0xF0 | mtfGroups & 0xFFFF00;
                    break;
                }
                case 2: {
                    mtfGroups = mtfGroups >>> 8 & 0xF | mtfGroups << 4 & 0xFF0 | mtfGroups & 0xFFF000;
                    break;
                }
                case 3: {
                    mtfGroups = mtfGroups >>> 12 & 0xF | mtfGroups << 4 & 0xFFF0 | mtfGroups & 0xFF0000;
                    break;
                }
                case 4: {
                    mtfGroups = mtfGroups >>> 16 & 0xF | mtfGroups << 4 & 0xFFFF0 | mtfGroups & 0xF00000;
                    break;
                }
                case 5: {
                    mtfGroups = mtfGroups >>> 20 & 0xF | mtfGroups << 4 & 0xFFFFF0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.selectors[i] = (byte)(mtfGroups & 0xF);
        }
        byte[] len_t = new byte[alphaSize];
        for (int t = 0; t < nGroups; ++t) {
            int maxLen = 0;
            int minLen = 32;
            int curr = this.bsGetBitsSmall(5);
            if (curr < 1 | curr > 20) {
                throw new IllegalStateException();
            }
            for (i = 0; i < alphaSize; ++i) {
                int markerBit = this.bsGetBit();
                while (markerBit != 0) {
                    int nextTwoBits = this.bsGetBitsSmall(2);
                    if ((curr += 1 - (nextTwoBits & 2)) < 1 | curr > 20) {
                        throw new IllegalStateException();
                    }
                    markerBit = nextTwoBits & 1;
                }
                len_t[i] = (byte)curr;
                maxLen = Math.max(maxLen, curr);
                minLen = Math.min(minLen, curr);
            }
            this.hbCreateDecodeTables(this.limit[t], this.base[t], this.perm[t], len_t, minLen, maxLen, alphaSize);
            this.minLens[t] = minLen;
        }
        return nSelectors;
    }

    private void getAndMoveToFrontDecode() throws IOException {
        int i;
        int limitLast = 100000 * this.blockSize100k;
        this.origPtr = this.bsGetBits(24);
        if (this.origPtr > 10 + limitLast) {
            throw new IllegalStateException();
        }
        int nSelectors = this.recvDecodingTables();
        int alphaSize = this.nInUse + 2;
        int EOB = this.nInUse + 1;
        for (i = 0; i <= 255; ++i) {
            this.unzftab[i] = 0;
        }
        byte[] yy = new byte[this.nInUse];
        for (i = 0; i < this.nInUse; ++i) {
            yy[i] = this.seqToUnseq[i];
        }
        this.last = -1;
        int groupNo = 0;
        int groupPos = 49;
        int groupSel = this.selectors[groupNo] & 0xFF;
        int groupMinLen = this.minLens[groupSel];
        int[] groupLimits = this.limit[groupSel];
        int[] groupPerm = this.perm[groupSel];
        int[] groupBase = this.base[groupSel];
        int zn = groupMinLen;
        int zvec = this.bsGetBits(groupMinLen);
        while (zvec >= groupLimits[zn]) {
            if (++zn > 20) {
                throw new IllegalStateException();
            }
            zvec = zvec << 1 | this.bsGetBit();
        }
        int permIndex = zvec - groupBase[zn];
        if (permIndex >= alphaSize) {
            throw new IllegalStateException();
        }
        int nextSym = groupPerm[permIndex];
        while (nextSym != EOB) {
            if (nextSym <= 1) {
                int permIndex2;
                int n = 1;
                int s = 0;
                do {
                    if (n > 0x100000) {
                        throw new IllegalStateException();
                    }
                    s += n << nextSym;
                    n <<= 1;
                    if (groupPos == 0) {
                        if (++groupNo >= nSelectors) {
                            throw new IllegalStateException();
                        }
                        groupPos = 50;
                        groupSel = this.selectors[groupNo] & 0xFF;
                        groupMinLen = this.minLens[groupSel];
                        groupLimits = this.limit[groupSel];
                        groupPerm = this.perm[groupSel];
                        groupBase = this.base[groupSel];
                    }
                    --groupPos;
                    int zn2 = groupMinLen;
                    int zvec2 = this.bsGetBits(groupMinLen);
                    while (zvec2 >= groupLimits[zn2]) {
                        if (++zn2 > 20) {
                            throw new IllegalStateException();
                        }
                        zvec2 = zvec2 << 1 | this.bsGetBit();
                    }
                    permIndex2 = zvec2 - groupBase[zn2];
                    if (permIndex2 < alphaSize) continue;
                    throw new IllegalStateException();
                } while ((nextSym = groupPerm[permIndex2]) <= 1);
                byte ch = yy[0];
                int n2 = ch & 0xFF;
                this.unzftab[n2] = this.unzftab[n2] + s;
                if (this.last >= limitLast - s) {
                    throw new IllegalStateException("Block overrun");
                }
                while (--s >= 0) {
                    this.ll8[++this.last] = ch;
                }
                continue;
            }
            if (++this.last >= limitLast) {
                throw new IllegalStateException("Block overrun");
            }
            byte tmp = yy[nextSym - 1];
            int n = tmp & 0xFF;
            this.unzftab[n] = this.unzftab[n] + 1;
            this.ll8[this.last] = tmp;
            if (nextSym <= 16) {
                for (int j = nextSym - 1; j > 0; --j) {
                    yy[j] = yy[j - 1];
                }
            } else {
                System.arraycopy(yy, 0, yy, 1, nextSym - 1);
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                if (++groupNo >= nSelectors) {
                    throw new IllegalStateException();
                }
                groupPos = 50;
                groupSel = this.selectors[groupNo] & 0xFF;
                groupMinLen = this.minLens[groupSel];
                groupLimits = this.limit[groupSel];
                groupPerm = this.perm[groupSel];
                groupBase = this.base[groupSel];
            }
            --groupPos;
            int zn3 = groupMinLen;
            int zvec3 = this.bsGetBits(groupMinLen);
            while (zvec3 >= groupLimits[zn3]) {
                if (++zn3 > 20) {
                    throw new IllegalStateException();
                }
                zvec3 = zvec3 << 1 | this.bsGetBit();
            }
            int permIndex3 = zvec3 - groupBase[zn3];
            if (permIndex3 >= alphaSize) {
                throw new IllegalStateException();
            }
            nextSym = groupPerm[permIndex3];
        }
        if (this.origPtr > this.last) {
            throw new IllegalStateException();
        }
        int nblock = this.last + 1;
        int check = 0;
        for (i = 0; i <= 255; ++i) {
            int t = this.unzftab[i];
            check |= t;
            check |= nblock - t;
        }
        if (check < 0) {
            throw new IllegalStateException();
        }
    }

    private int requireByte() throws IOException {
        int b = this.bsStream.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b & 0xFF;
    }

    private void setupRandPartA() throws IOException {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = CBZip2OutputStream.R_NUMS[this.rTPos++];
                this.rTPos &= 0x1FF;
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentByte = this.ch2;
            this.currentState = 1;
            this.blockCRC.update(this.ch2);
        } else {
            this.endBlock();
            this.beginBlock();
        }
    }

    private void setupNoRandPartA() throws IOException {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentByte = this.ch2;
            this.currentState = 3;
            this.blockCRC.update(this.ch2);
        } else {
            this.endBlock();
            this.beginBlock();
        }
    }

    private void setupRandPartB() throws IOException {
        if (this.ch2 != this.chPrev) {
            this.count = 1;
            this.setupRandPartA();
        } else if (++this.count < 4) {
            this.setupRandPartA();
        } else {
            this.z = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = CBZip2OutputStream.R_NUMS[this.rTPos++];
                this.rTPos &= 0x1FF;
            }
            --this.rNToGo;
            this.z ^= this.rNToGo == 1 ? 1 : 0;
            this.j2 = 0;
            this.currentState = 2;
            this.setupRandPartC();
        }
    }

    private void setupNoRandPartB() throws IOException {
        if (this.ch2 != this.chPrev) {
            this.count = 1;
            this.setupNoRandPartA();
        } else if (++this.count < 4) {
            this.setupNoRandPartA();
        } else {
            this.z = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            this.currentState = 4;
            this.j2 = 0;
            this.setupNoRandPartC();
        }
    }

    private void setupRandPartC() throws IOException {
        if (this.j2 < this.z) {
            this.currentByte = this.ch2;
            this.blockCRC.update(this.ch2);
            ++this.j2;
        } else {
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartC() throws IOException {
        if (this.j2 < this.z) {
            this.currentByte = this.ch2;
            this.blockCRC.update(this.ch2);
            ++this.j2;
        } else {
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }
}

