/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.SignatureParameters;
import org.bouncycastle.openpgp.api.SubkeySelector;
import org.bouncycastle.openpgp.api.Utils;
import org.bouncycastle.openpgp.api.exception.InvalidSigningKeyException;
import org.bouncycastle.openpgp.api.exception.KeyPassphraseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractOpenPGPDocumentSignatureGenerator<T extends AbstractOpenPGPDocumentSignatureGenerator<T>> {
    protected final OpenPGPImplementation implementation;
    protected final OpenPGPPolicy policy;
    protected final List<PGPSignatureGenerator> signatureGenerators = new ArrayList<PGPSignatureGenerator>();
    protected final List<OpenPGPKey.OpenPGPSecretKey> signingKeys = new ArrayList<OpenPGPKey.OpenPGPSecretKey>();
    protected final List<SignatureParameters.Callback> signatureCallbacks = new ArrayList<SignatureParameters.Callback>();
    protected final List<KeyPassphraseProvider> signingKeyPassphraseProviders = new ArrayList<KeyPassphraseProvider>();
    protected final KeyPassphraseProvider.DefaultKeyPassphraseProvider defaultKeyPassphraseProvider = new KeyPassphraseProvider.DefaultKeyPassphraseProvider();
    protected SubkeySelector signingKeySelector = new SubkeySelector(){

        @Override
        public List<OpenPGPCertificate.OpenPGPComponentKey> select(OpenPGPCertificate certificate, OpenPGPPolicy policy) {
            ArrayList<OpenPGPCertificate.OpenPGPComponentKey> result = new ArrayList<OpenPGPCertificate.OpenPGPComponentKey>();
            for (OpenPGPCertificate.OpenPGPComponentKey key : certificate.getSigningKeys()) {
                if (!policy.isAcceptablePublicKey(key.getPGPPublicKey())) continue;
                result.add(key);
            }
            return result;
        }
    };

    public AbstractOpenPGPDocumentSignatureGenerator(OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        this.implementation = implementation;
        this.policy = policy;
    }

    public T setSigningKeySelector(SubkeySelector signingKeySelector) {
        if (signingKeySelector == null) {
            throw new NullPointerException();
        }
        this.signingKeySelector = signingKeySelector;
        return (T)this;
    }

    public T addKeyPassphrase(char[] passphrase) {
        this.defaultKeyPassphraseProvider.addPassphrase(passphrase);
        return (T)this;
    }

    public T addSigningKey(OpenPGPKey key) throws InvalidSigningKeyException {
        return this.addSigningKey(key, this.defaultKeyPassphraseProvider);
    }

    public T addSigningKey(OpenPGPKey key, KeyPassphraseProvider passphraseProvider) throws InvalidSigningKeyException {
        return this.addSigningKey(key, passphraseProvider, null);
    }

    public T addSigningKey(OpenPGPKey key, SignatureParameters.Callback signatureCallback) throws InvalidSigningKeyException {
        return this.addSigningKey(key, (KeyPassphraseProvider)this.defaultKeyPassphraseProvider, signatureCallback);
    }

    public T addSigningKey(OpenPGPKey key, KeyPassphraseProvider passphraseProvider, SignatureParameters.Callback signatureCallback) throws InvalidSigningKeyException {
        List<OpenPGPCertificate.OpenPGPComponentKey> signingSubkeys = this.signingKeySelector.select(key, this.policy);
        if (signingSubkeys.isEmpty()) {
            throw new InvalidSigningKeyException(key);
        }
        Iterator<OpenPGPCertificate.OpenPGPComponentKey> it = signingSubkeys.iterator();
        while (it.hasNext()) {
            OpenPGPKey.OpenPGPSecretKey signingKey = key.getSecretKey(it.next());
            this.addSigningKey(signingKey, passphraseProvider, signatureCallback);
        }
        return (T)this;
    }

    public T addSigningKey(OpenPGPKey.OpenPGPSecretKey signingKey, char[] passphrase, SignatureParameters.Callback signatureCallback) throws InvalidSigningKeyException {
        return this.addSigningKey(signingKey, (KeyPassphraseProvider)this.defaultKeyPassphraseProvider.addPassphrase(signingKey, passphrase), signatureCallback);
    }

    public T addSigningKey(OpenPGPKey.OpenPGPSecretKey signingKey, KeyPassphraseProvider passphraseProvider, SignatureParameters.Callback signatureCallback) throws InvalidSigningKeyException {
        if (!signingKey.isSigningKey()) {
            throw new InvalidSigningKeyException(signingKey);
        }
        this.signingKeys.add(signingKey);
        this.signingKeyPassphraseProviders.add(passphraseProvider);
        this.signatureCallbacks.add(signatureCallback);
        return (T)this;
    }

    protected PGPSignatureGenerator initSignatureGenerator(OpenPGPKey.OpenPGPSecretKey signingKey, KeyPassphraseProvider passphraseProvider, SignatureParameters.Callback signatureCallback) throws PGPException {
        SignatureParameters parameters = Utils.applySignatureParameters(signatureCallback, SignatureParameters.dataSignature(this.policy).setSignatureHashAlgorithm(this.getPreferredHashAlgorithm(signingKey)));
        if (parameters == null) {
            throw new IllegalStateException("SignatureParameters Callback MUST NOT return null.");
        }
        if (!signingKey.isSigningKey(parameters.getSignatureCreationTime())) {
            throw new InvalidSigningKeyException(signingKey);
        }
        char[] passphrase = passphraseProvider.getKeyPassword(signingKey);
        PGPKeyPair unlockedKey = signingKey.unlock(passphrase).getKeyPair();
        if (unlockedKey == null) {
            throw new KeyPassphraseException((OpenPGPCertificate.OpenPGPComponentKey)signingKey, (Exception)new PGPException("Cannot unlock secret key."));
        }
        return Utils.getPgpSignatureGenerator(this.implementation, signingKey.getPGPPublicKey(), unlockedKey.getPrivateKey(), parameters, null, null);
    }

    private int getPreferredHashAlgorithm(OpenPGPCertificate.OpenPGPComponentKey key) {
        PreferredAlgorithms hashPreferences = key.getHashAlgorithmPreferences();
        if (hashPreferences != null) {
            int[] prefs = hashPreferences.getPreferences();
            ArrayList<Integer> acceptablePrefs = new ArrayList<Integer>();
            for (int i = 0; i < prefs.length; ++i) {
                int algo = prefs[i];
                if (!this.policy.isAcceptableDocumentSignatureHashAlgorithm(algo, new Date())) continue;
                acceptablePrefs.add(algo);
            }
            if (!acceptablePrefs.isEmpty()) {
                return (Integer)acceptablePrefs.get(0);
            }
        }
        return this.policy.getDefaultDocumentSignatureHashAlgorithm();
    }

    public T setMissingKeyPassphraseCallback(KeyPassphraseProvider callback) {
        this.defaultKeyPassphraseProvider.setMissingPassphraseCallback(callback);
        return (T)this;
    }

    protected void addSignToGenerator() throws PGPException {
        for (int i = 0; i < this.signingKeys.size(); ++i) {
            OpenPGPKey.OpenPGPSecretKey signingKey = this.signingKeys.get(i);
            KeyPassphraseProvider keyPassphraseProvider = this.signingKeyPassphraseProviders.get(i);
            SignatureParameters.Callback signatureCallback = this.signatureCallbacks.get(i);
            PGPSignatureGenerator sigGen = this.initSignatureGenerator(signingKey, keyPassphraseProvider, signatureCallback);
            this.signatureGenerators.add(sigGen);
        }
    }
}

