/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSymmetricKeyEncryptedData;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;

public class PGPSessionKeyEncryptedData
extends PGPSymmetricKeyEncryptedData {
    PGPSessionKeyEncryptedData(InputStreamPacket encData) {
        super(encData);
    }

    public int getAlgorithm() {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
            return aeadData.getAlgorithm();
        }
        return -1;
    }

    public int getVersion() {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
            return aeadData.getVersion();
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symIntData = (SymmetricEncIntegrityPacket)this.encData;
            return symIntData.getVersion();
        }
        return -1;
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        this.encStream = this.createDecryptionStream(dataDecryptorFactory, dataDecryptorFactory.getSessionKey());
        return this.encStream;
    }
}

