/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public class BcCFBSecretKeyEncryptorFactory
implements PBESecretKeyEncryptorFactory {
    public PBESecretKeyEncryptor build(char[] passphrase, PublicKeyPacket pubKeyPacket) {
        PGPDigestCalculator checksumCalc;
        if (passphrase == null) {
            return null;
        }
        try {
            checksumCalc = new BcPGPDigestCalculatorProvider().get(8);
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
        return new BcPBESecretKeyEncryptorBuilder(9, checksumCalc, 255).build(passphrase);
    }
}

