/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.bc;

import java.util.Date;
import org.bouncycastle.openpgp.api.OpenPGPV6KeyGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcAEADSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcCFBSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPairGeneratorProvider;

public class BcOpenPGPV6KeyGenerator
extends OpenPGPV6KeyGenerator {
    public BcOpenPGPV6KeyGenerator() {
        this(new Date());
    }

    public BcOpenPGPV6KeyGenerator(Date creationTime) {
        this(14, creationTime, true);
    }

    public BcOpenPGPV6KeyGenerator(int signatureHashAlgorithm) {
        this(signatureHashAlgorithm, new Date(), true);
    }

    public BcOpenPGPV6KeyGenerator(int signatureHashAlgorithm, Date creationTime, boolean aeadProtection) {
        super(new BcPGPKeyPairGeneratorProvider(), new BcPGPContentSignerBuilderProvider(signatureHashAlgorithm), new BcPGPDigestCalculatorProvider(), BcOpenPGPV6KeyGenerator.keyEncryptorFactory(aeadProtection), new BcKeyFingerprintCalculator(), creationTime);
    }

    private static PBESecretKeyEncryptorFactory keyEncryptorFactory(boolean aeadProtection) {
        if (aeadProtection) {
            return new BcAEADSecretKeyEncryptorFactory();
        }
        return new BcCFBSecretKeyEncryptorFactory();
    }
}

