/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;

public class KeyBasedFileProcessor {
    private static void decryptFile(String inputFileName, String keyFileName, char[] passwd, String defaultFileName) throws IOException, NoSuchProviderException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFileName));
        BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(keyFileName));
        KeyBasedFileProcessor.decryptFile(in, keyIn, passwd, defaultFileName);
        ((InputStream)keyIn).close();
        ((InputStream)in).close();
    }

    private static void decryptFile(InputStream in, InputStream keyIn, char[] passwd, String defaultFileName) throws IOException, NoSuchProviderException {
        block13: {
            in = PGPUtil.getDecoderStream(in);
            try {
                String outFileName;
                PGPLiteralData ld;
                JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(in);
                Object o = pgpF.nextObject();
                PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
                Iterator<PGPEncryptedData> it = enc.getEncryptedDataObjects();
                PGPPrivateKey sKey = null;
                PGPPublicKeyEncryptedData pbe = null;
                PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                while (sKey == null && it.hasNext()) {
                    pbe = (PGPPublicKeyEncryptedData)it.next();
                    sKey = PGPExampleUtil.findSecretKey(pgpSec, pbe.getKeyID(), passwd);
                }
                if (sKey == null) {
                    throw new IllegalArgumentException("secret key for message not found.");
                }
                InputStream clear = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(sKey));
                JcaPGPObjectFactory plainFact = new JcaPGPObjectFactory(clear);
                Object message = plainFact.nextObject();
                if (message instanceof PGPCompressedData) {
                    PGPCompressedData cData = (PGPCompressedData)message;
                    JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(cData.getDataStream());
                    message = pgpFact.nextObject();
                }
                if (message instanceof PGPLiteralData) {
                    ld = (PGPLiteralData)message;
                    outFileName = ld.getFileName();
                    if (outFileName.length() == 0) {
                        outFileName = defaultFileName;
                    }
                } else {
                    if (message instanceof PGPOnePassSignatureList) {
                        throw new PGPException("encrypted message contains a signed message - not literal data.");
                    }
                    throw new PGPException("message is not a simple encrypted file - type unknown.");
                }
                InputStream unc = ld.getInputStream();
                FileOutputStream fOut = new FileOutputStream(outFileName);
                Streams.pipeAll((InputStream)unc, (OutputStream)fOut, (int)8192);
                ((OutputStream)fOut).close();
                if (pbe.isIntegrityProtected()) {
                    if (!pbe.verify()) {
                        System.err.println("message failed integrity check");
                    } else {
                        System.err.println("message integrity check passed");
                    }
                } else {
                    System.err.println("no message integrity check");
                }
            }
            catch (PGPException e) {
                System.err.println(e);
                if (e.getUnderlyingException() == null) break block13;
                e.getUnderlyingException().printStackTrace();
            }
        }
    }

    private static void encryptFile(String outputFileName, String inputFileName, String encKeyFileName, boolean armor, boolean withIntegrityCheck) throws IOException, NoSuchProviderException, PGPException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFileName));
        PGPPublicKey encKey = PGPExampleUtil.readPublicKey(encKeyFileName);
        KeyBasedFileProcessor.encryptFile(out, inputFileName, encKey, armor, withIntegrityCheck);
        ((OutputStream)out).close();
    }

    private static void encryptFile(OutputStream out, String fileName, PGPPublicKey encKey, boolean armor, boolean withIntegrityCheck) throws IOException, NoSuchProviderException {
        block4: {
            if (armor) {
                out = new ArmoredOutputStream(out);
            }
            try {
                byte[] bytes = PGPExampleUtil.compressFile(fileName, 1);
                JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(3).setProvider("BC").setSecureRandom(new SecureRandom()).setWithIntegrityPacket(withIntegrityCheck);
                PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(encryptorBuilder);
                encGen.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(encKey).setProvider("BC"));
                OutputStream cOut = encGen.open(out, bytes.length);
                cOut.write(bytes);
                cOut.close();
                if (armor) {
                    out.close();
                }
            }
            catch (PGPException e) {
                System.err.println(e);
                if (e.getUnderlyingException() == null) break block4;
                e.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args.length == 0) {
            System.err.println("usage: KeyBasedFileProcessor -e|-d [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
            return;
        }
        if (args[0].equals("-e")) {
            if (args[1].equals("-a") || args[1].equals("-ai") || args[1].equals("-ia")) {
                KeyBasedFileProcessor.encryptFile(args[2] + ".asc", args[2], args[3], true, args[1].indexOf(105) > 0);
            } else if (args[1].equals("-i")) {
                KeyBasedFileProcessor.encryptFile(args[2] + ".bpg", args[2], args[3], false, true);
            } else {
                KeyBasedFileProcessor.encryptFile(args[1] + ".bpg", args[1], args[2], false, false);
            }
        } else if (args[0].equals("-d")) {
            KeyBasedFileProcessor.decryptFile(args[1], args[2], args[3].toCharArray(), new File(args[1]).getName() + ".out");
        } else {
            System.err.println("usage: KeyBasedFileProcessor -d|-e [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
        }
    }
}

