/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        super(passPhrase, s2kDigestCalculator);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase) {
        this(passPhrase, new SHA1PGPDigestCalculator());
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        super(passPhrase, s2kDigestCalculator, s2kCount);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, int s2kCount) {
        super(passPhrase, new SHA1PGPDigestCalculator(), s2kCount);
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        super.setSecureRandom(random);
        return this;
    }

    protected byte[] encryptSessionInfo(int encAlgorithm, byte[] key, byte[] sessionInfo) throws PGPException {
        try {
            String cName = PGPUtil.getSymmetricCipherName(encAlgorithm);
            Cipher c = this.helper.createCipher(cName + "/CFB/NoPadding");
            SecretKeySpec sKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            c.init(1, (Key)sKey, new IvParameterSpec(new byte[c.getBlockSize()]));
            return c.doFinal(sessionInfo, 0, sessionInfo.length);
        }
        catch (IllegalBlockSizeException e) {
            throw new PGPException("illegal block size: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new PGPException("bad padding: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PGPException("IV invalid: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("key invalid: " + e.getMessage(), e);
        }
    }

    protected byte[] generateV6KEK(int kekAlgorithm, byte[] ikm, byte[] info) throws PGPException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, null, info));
        int kekLen = SymmetricKeyUtils.getKeyLengthInOctets(kekAlgorithm);
        byte[] kek = new byte[kekLen];
        hkdf.generateBytes(kek, 0, kek.length);
        return kek;
    }

    protected byte[] getEskAndTag(int kekAlgorithm, int aeadAlgorithm, byte[] sessionInfo, byte[] key, byte[] iv, byte[] info) throws PGPException {
        byte[] sessionKey = new byte[sessionInfo.length - 3];
        System.arraycopy(sessionInfo, 1, sessionKey, 0, sessionKey.length);
        AEADBlockCipher aeadCipher = BcAEADUtil.createAEADCipher(kekAlgorithm, aeadAlgorithm);
        aeadCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(key), 128, iv, info));
        int outLen = aeadCipher.getOutputSize(sessionKey.length);
        byte[] eskAndTag = new byte[outLen];
        int len = aeadCipher.processBytes(sessionKey, 0, sessionKey.length, eskAndTag, 0);
        try {
            len += aeadCipher.doFinal(eskAndTag, len);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("cannot encrypt session info", (Exception)((Object)e));
        }
        return eskAndTag;
    }
}

