/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public class JcePGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private final int encAlgorithm;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.helper);
    private SecureRandom random;
    private boolean withIntegrityPacket = true;
    private int aeadAlgorithm = -1;
    private int chunkSize;
    private boolean isV5StyleAEAD = true;

    public JcePGPDataEncryptorBuilder(int encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
        if (encAlgorithm == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    public JcePGPDataEncryptorBuilder setWithIntegrityPacket(boolean withIntegrityPacket) {
        this.withIntegrityPacket = withIntegrityPacket;
        return this;
    }

    public JcePGPDataEncryptorBuilder setWithAEAD(int aeadAlgorithm, int chunkSize) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES");
        }
        if (chunkSize < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = aeadAlgorithm;
        this.chunkSize = chunkSize - 6;
        return this;
    }

    public JcePGPDataEncryptorBuilder setUseV5AEAD() {
        this.isV5StyleAEAD = true;
        return this;
    }

    public JcePGPDataEncryptorBuilder setUseV6AEAD() {
        this.isV5StyleAEAD = false;
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePGPDataEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public boolean isV5StyleAEAD() {
        return this.isV5StyleAEAD;
    }

    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public PGPDataEncryptor build(byte[] keyBytes) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(keyBytes);
        }
        return new MyPGPDataEncryptor(keyBytes);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final boolean isV5StyleAEAD;
        private final Cipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] keyBytes) throws PGPException {
            boolean bl = this.isV5StyleAEAD = keyBytes.length == SymmetricKeyUtils.getKeyLengthInOctets(JcePGPDataEncryptorBuilder.this.encAlgorithm);
            if (this.isV5StyleAEAD) {
                this.keyBytes = keyBytes;
                this.iv = new byte[AEADUtils.getIVLength((byte)JcePGPDataEncryptorBuilder.this.aeadAlgorithm)];
                JcePGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
            } else {
                byte[][] keyAndIv = AEADUtils.splitMessageKeyAndIv(keyBytes, JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm);
                this.keyBytes = keyAndIv[0];
                this.iv = keyAndIv[1];
            }
            this.c = JcePGPDataEncryptorBuilder.this.aeadHelper.createAEADCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm);
        }

        public OutputStream getOutputStream(OutputStream out) {
            try {
                return new JceAEADUtil.PGPAeadOutputStream(this.isV5StyleAEAD, out, this.c, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, this.keyBytes), this.iv, JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm, JcePGPDataEncryptorBuilder.this.chunkSize);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to process stream: " + e.getMessage());
            }
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }

        public int getAEADAlgorithm() {
            return JcePGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        public int getChunkSize() {
            return JcePGPDataEncryptorBuilder.this.chunkSize;
        }

        public byte[] getIV() {
            return Arrays.clone((byte[])this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final Cipher c;

        MyPGPDataEncryptor(byte[] keyBytes) throws PGPException {
            this.c = JcePGPDataEncryptorBuilder.this.helper.createStreamCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.withIntegrityPacket);
            try {
                if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                    byte[] iv = new byte[this.c.getBlockSize()];
                    this.c.init(1, (Key)JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, keyBytes), new IvParameterSpec(iv));
                } else {
                    this.c.init(1, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, keyBytes));
                }
            }
            catch (InvalidKeyException e) {
                throw new PGPException("invalid key: " + e.getMessage(), e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new PGPException("imvalid algorithm parameter: " + e.getMessage(), e);
            }
        }

        public OutputStream getOutputStream(OutputStream out) {
            return new CipherOutputStream(out, this.c);
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

