/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

public class BcAEADUtil {
    protected static byte[] getNonce(byte[] iv, long chunkIndex) {
        byte[] nonce = Arrays.clone((byte[])iv);
        BcAEADUtil.xorChunkId(nonce, chunkIndex);
        return nonce;
    }

    protected static void xorChunkId(byte[] nonce, long chunkIndex) {
        int index = nonce.length - 8;
        int n = index++;
        nonce[n] = (byte)(nonce[n] ^ (byte)(chunkIndex >> 56));
        int n2 = index++;
        nonce[n2] = (byte)(nonce[n2] ^ (byte)(chunkIndex >> 48));
        int n3 = index++;
        nonce[n3] = (byte)(nonce[n3] ^ (byte)(chunkIndex >> 40));
        int n4 = index++;
        nonce[n4] = (byte)(nonce[n4] ^ (byte)(chunkIndex >> 32));
        int n5 = index++;
        nonce[n5] = (byte)(nonce[n5] ^ (byte)(chunkIndex >> 24));
        int n6 = index++;
        nonce[n6] = (byte)(nonce[n6] ^ (byte)(chunkIndex >> 16));
        int n7 = index++;
        nonce[n7] = (byte)(nonce[n7] ^ (byte)(chunkIndex >> 8));
        int n8 = index;
        nonce[n8] = (byte)(nonce[n8] ^ (byte)chunkIndex);
    }

    protected static long getChunkLength(int chunkSize) {
        return 1L << chunkSize + 6;
    }

    static byte[][] deriveMessageKeyAndIv(int aeadAlgo, int cipherAlgo, byte[] sessionKey, byte[] salt, byte[] hkdfInfo) throws PGPException {
        HKDFParameters hkdfParameters = new HKDFParameters(sessionKey, salt, hkdfInfo);
        HKDFBytesGenerator hkdfGen = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdfGen.init((DerivationParameters)hkdfParameters);
        int keyLen = SymmetricKeyUtils.getKeyLengthInOctets(cipherAlgo);
        int ivLen = AEADUtils.getIVLength(aeadAlgo);
        byte[] messageKeyAndIv = new byte[keyLen + ivLen - 8];
        hkdfGen.generateBytes(messageKeyAndIv, 0, messageKeyAndIv.length);
        return new byte[][]{Arrays.copyOfRange((byte[])messageKeyAndIv, (int)0, (int)keyLen), Arrays.copyOfRange((byte[])messageKeyAndIv, (int)keyLen, (int)(keyLen + ivLen))};
    }

    public static AEADBlockCipher createAEADCipher(int encAlgorithm, int aeadAlgorithm) throws PGPException {
        if (encAlgorithm != 7 && encAlgorithm != 8 && encAlgorithm != 9) {
            throw new PGPException("AEAD only supported for AES based algorithms");
        }
        switch (aeadAlgorithm) {
            case 1: {
                return new EAXBlockCipher((BlockCipher)new AESEngine());
            }
            case 2: {
                return new OCBBlockCipher((BlockCipher)new AESEngine(), (BlockCipher)new AESEngine());
            }
            case 3: {
                return new GCMBlockCipher((BlockCipher)new AESEngine());
            }
        }
        throw new PGPException("unrecognised AEAD algorithm: " + aeadAlgorithm);
    }

    static PGPDataDecryptor createOpenPgpV5DataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
        final byte aeadAlgorithm = aeadEncDataPacket.getAEADAlgorithm();
        final byte[] iv = aeadEncDataPacket.getIV();
        final int chunkSize = aeadEncDataPacket.getChunkSize();
        final int encAlgorithm = sessionKey.getAlgorithm();
        byte[] key = sessionKey.getKey();
        final byte[] aaData = aeadEncDataPacket.getAAData();
        final KeyParameter secretKey = new KeyParameter(key);
        final AEADBlockCipher c = BcAEADUtil.createAEADCipher(encAlgorithm, aeadAlgorithm);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream in) {
                try {
                    return new PGPAeadInputStream(true, in, c, secretKey, iv, encAlgorithm, aeadAlgorithm, chunkSize, aaData);
                }
                catch (IOException e) {
                    throw Exceptions.illegalStateException((String)("unable to open stream: " + e.getMessage()), (Throwable)e);
                }
            }

            public int getBlockSize() {
                return c.getUnderlyingCipher().getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    static PGPDataDecryptor createOpenPgpV6DataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
        if (seipd.getVersion() == 1) {
            throw new PGPException("SEIPD packet MUST be of version 2 or greater.");
        }
        final int cipherAlgo = seipd.getCipherAlgorithm();
        final int aeadAlgo = seipd.getAeadAlgorithm();
        final int chunkSize = seipd.getChunkSize();
        final byte[] aaData = seipd.getAAData();
        byte[][] messageKeyAndIv = BcAEADUtil.deriveMessageKeyAndIv(aeadAlgo, cipherAlgo, sessionKey.getKey(), seipd.getSalt(), aaData);
        byte[] messageKey = messageKeyAndIv[0];
        final byte[] iv = messageKeyAndIv[1];
        final KeyParameter secretKey = new KeyParameter(messageKey);
        final AEADBlockCipher c = BcAEADUtil.createAEADCipher(cipherAlgo, aeadAlgo);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream in) {
                try {
                    return new PGPAeadInputStream(false, in, c, secretKey, iv, cipherAlgo, aeadAlgo, chunkSize, aaData);
                }
                catch (IOException e) {
                    throw Exceptions.illegalStateException((String)("unable to open stream: " + e.getMessage()), (Throwable)e);
                }
            }

            public int getBlockSize() {
                return c.getUnderlyingCipher().getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    protected static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int tagLen;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;
        private final boolean isV5StyleAEAD;

        public PGPAeadInputStream(boolean isV5StyleAEAD, InputStream in, AEADBlockCipher c, KeyParameter secretKey, byte[] iv, int encAlgorithm, int aeadAlgorithm, int chunkSize, byte[] aaData) throws IOException {
            this.isV5StyleAEAD = isV5StyleAEAD;
            this.in = in;
            this.iv = iv;
            this.chunkLength = (int)BcAEADUtil.getChunkLength(chunkSize);
            this.tagLen = AEADUtils.getAuthTagLength(aeadAlgorithm);
            this.buf = new byte[this.chunkLength + this.tagLen + this.tagLen];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = aaData;
            Streams.readFully((InputStream)in, (byte[])this.buf, (int)0, (int)(this.tagLen + this.tagLen));
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int supplyLen = Math.min(len, this.available());
            System.arraycopy(this.data, this.dataOff, b, off, supplyLen);
            this.dataOff += supplyLen;
            return supplyLen;
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skip = (int)Math.min(n, (long)this.available());
            this.dataOff += skip;
            return skip;
        }

        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            int dataLen = Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)(this.tagLen + this.tagLen), (int)this.chunkLength);
            if (dataLen == 0) {
                return null;
            }
            byte[] adata = new byte[this.isV5StyleAEAD ? 13 : this.aaData.length];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            if (this.isV5StyleAEAD) {
                BcAEADUtil.xorChunkId(adata, this.chunkIndex);
            }
            byte[] decData = new byte[dataLen];
            try {
                this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(adata, 0, adata.length);
                int len = this.c.processBytes(this.buf, 0, dataLen + this.tagLen, decData, 0);
                this.c.doFinal(decData, len);
            }
            catch (InvalidCipherTextException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)decData.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, dataLen + this.tagLen, this.buf, 0, this.tagLen);
            if (dataLen != this.chunkLength) {
                if (this.isV5StyleAEAD) {
                    adata = new byte[13];
                    System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
                    BcAEADUtil.xorChunkId(adata, this.chunkIndex);
                } else {
                    adata = new byte[this.aaData.length + 8];
                    System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
                    System.arraycopy(Pack.longToBigEndian((long)this.totalBytes), 0, adata, this.aaData.length, 8);
                }
                try {
                    this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                    this.c.processAADBytes(adata, 0, adata.length);
                    if (this.isV5StyleAEAD) {
                        this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                    }
                    this.c.processBytes(this.buf, 0, this.tagLen, this.buf, 0);
                    this.c.doFinal(this.buf, 0);
                }
                catch (InvalidCipherTextException e) {
                    throw new IOException("exception processing final tag: " + e.getMessage());
                }
            } else {
                Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)this.tagLen, (int)this.tagLen);
            }
            return decData;
        }
    }

    protected static class PGPAeadOutputStream
    extends OutputStream {
        private final boolean isV5StyleAEAD;
        private final OutputStream out;
        private final byte[] data;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int tagLen;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(boolean isV5StyleAEAD, OutputStream out, AEADBlockCipher c, KeyParameter secretKey, byte[] iv, int encAlgorithm, int aeadAlgorithm, int chunkSize) {
            this.isV5StyleAEAD = isV5StyleAEAD;
            this.out = out;
            this.iv = iv;
            this.chunkLength = (int)BcAEADUtil.getChunkLength(chunkSize);
            this.tagLen = AEADUtils.getAuthTagLength(aeadAlgorithm);
            this.data = new byte[this.chunkLength];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = this.createAAD(isV5StyleAEAD, encAlgorithm, aeadAlgorithm, chunkSize);
        }

        private byte[] createAAD(boolean isV5StyleAEAD, int encAlgorithm, int aeadAlgorithm, int chunkSize) {
            if (isV5StyleAEAD) {
                return AEADEncDataPacket.createAAData(1, encAlgorithm, aeadAlgorithm, chunkSize);
            }
            return SymmetricEncIntegrityPacket.createAAData(2, encAlgorithm, aeadAlgorithm, chunkSize);
        }

        public void write(int b) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)b;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (len < this.data.length - this.dataOff) {
                System.arraycopy(b, off, this.data, this.dataOff, len);
                this.dataOff += len;
            } else {
                int gap = this.data.length - this.dataOff;
                System.arraycopy(b, off, this.data, this.dataOff, gap);
                this.dataOff += gap;
                this.writeBlock();
                len -= gap;
                off += gap;
                while (len >= this.data.length) {
                    System.arraycopy(b, off, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    len -= this.data.length;
                    off += this.data.length;
                }
                if (len > 0) {
                    System.arraycopy(b, off, this.data, 0, len);
                    this.dataOff = len;
                }
            }
        }

        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            boolean v5StyleAEAD = this.isV5StyleAEAD;
            byte[] adata = v5StyleAEAD ? new byte[13] : new byte[this.aaData.length];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            if (v5StyleAEAD) {
                BcAEADUtil.xorChunkId(adata, this.chunkIndex);
            }
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(adata, 0, adata.length);
                int len = this.c.processBytes(this.data, 0, this.dataOff, this.data, 0);
                this.out.write(this.data, 0, len);
                len = this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, len);
            }
            catch (InvalidCipherTextException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            byte[] adata;
            boolean v5StyleAEAD;
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            if (v5StyleAEAD = this.isV5StyleAEAD) {
                adata = new byte[13];
                System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
                BcAEADUtil.xorChunkId(adata, this.chunkIndex);
            } else {
                adata = new byte[this.aaData.length + 8];
                System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
                System.arraycopy(Pack.longToBigEndian((long)this.totalBytes), 0, adata, this.aaData.length, 8);
            }
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(adata, 0, adata.length);
                if (v5StyleAEAD) {
                    this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                }
                this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, this.tagLen);
            }
            catch (InvalidCipherTextException e) {
                throw new IOException("exception processing final tag: " + e.getMessage());
            }
            this.out.close();
        }
    }
}

