/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcSessionKeyDataDecryptorFactory
implements SessionKeyDataDecryptorFactory {
    private final PGPSessionKey sessionKey;

    public BcSessionKeyDataDecryptorFactory(PGPSessionKey sessionKey) {
        this.sessionKey = sessionKey;
    }

    public PGPSessionKey getSessionKey() {
        return this.sessionKey;
    }

    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }

    public PGPDataDecryptor createDataDecryptor(int aeadAlgorithm, byte[] iv, int chunkSize, int encAlgorithm, byte[] key) throws PGPException {
        return BcUtil.createDataDecryptor(aeadAlgorithm, iv, chunkSize, encAlgorithm, key);
    }
}

