/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean useOldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private boolean forceSessionKey = false;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder) {
        this(encryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder, boolean oldFormat) {
        this.dataEncryptorBuilder = encryptorBuilder;
        this.useOldFormat = oldFormat;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
    }

    public void setForceSessionKey(boolean forceSessionKey) {
        this.forceSessionKey = forceSessionKey;
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator method) {
        this.methods.add(method);
    }

    private void addCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        sessionInfo[sessionInfo.length - 2] = (byte)(check >> 8);
        sessionInfo[sessionInfo.length - 1] = (byte)check;
    }

    private byte[] createSessionInfo(int algorithm, byte[] keyBytes) {
        byte[] sessionInfo = new byte[keyBytes.length + 3];
        sessionInfo[0] = (byte)algorithm;
        System.arraycopy(keyBytes, 0, sessionInfo, 1, keyBytes.length);
        this.addCheckSum(sessionInfo);
        return sessionInfo;
    }

    private OutputStream open(OutputStream out, long length, byte[] buffer) throws IOException, PGPException, IllegalStateException {
        PGPKeyEncryptionMethodGenerator m;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        byte[] key = null;
        this.pOut = new BCPGOutputStream(out);
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        if (this.methods.size() == 1) {
            boolean isPBE = this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator;
            if (isPBE && !this.forceSessionKey) {
                PBEKeyEncryptionMethodGenerator m2 = (PBEKeyEncryptionMethodGenerator)this.methods.get(0);
                key = m2.getKey(this.defAlgorithm);
                this.pOut.writePacket(m2.generate(this.defAlgorithm, null));
            } else {
                key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                byte[] sessionInfo = this.createSessionInfo(this.defAlgorithm, key);
                m = (PGPKeyEncryptionMethodGenerator)this.methods.get(0);
                this.writeWrappedSessionKey(m, sessionInfo);
            }
        } else {
            key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            byte[] sessionInfo = this.createSessionInfo(this.defAlgorithm, key);
            for (int i = 0; i != this.methods.size(); ++i) {
                m = (PGPKeyEncryptionMethodGenerator)this.methods.get(i);
                this.writeWrappedSessionKey(m, sessionInfo);
            }
        }
        try {
            InputStreamPacket encOut;
            PGPDataEncryptor dataEncryptor = this.dataEncryptorBuilder.build(key);
            this.digestCalc = dataEncryptor.getIntegrityCalculator();
            if (dataEncryptor instanceof PGPAEADDataEncryptor) {
                PGPAEADDataEncryptor encryptor = (PGPAEADDataEncryptor)dataEncryptor;
                byte[] iv = encryptor.getIV();
                AEADEncDataPacket encOut2 = new AEADEncDataPacket(this.dataEncryptorBuilder.getAlgorithm(), encryptor.getAEADAlgorithm(), encryptor.getChunkSize(), iv);
                if (buffer != null) {
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)encOut2, buffer);
                } else {
                    long chunkLength = 1L << encryptor.getChunkSize() + 6;
                    long tagLengths = (length + chunkLength - 1L) / chunkLength * 16L + 16L;
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)encOut2, length + tagLengths + 4L + (long)iv.length);
                }
                this.genOut = this.cOut = dataEncryptor.getOutputStream(this.pOut);
                return new WrappedGeneratorStream(this.genOut, this);
            }
            if (this.digestCalc != null) {
                encOut = new SymmetricEncIntegrityPacket();
                if (this.useOldFormat) {
                    throw new PGPException("symmetric-enc-integrity packets not supported in old PGP format");
                }
            } else {
                encOut = new SymmetricEncDataPacket();
            }
            if (buffer == null) {
                long outLength = this.digestCalc == null ? length + (long)dataEncryptor.getBlockSize() + 2L : length + (long)dataEncryptor.getBlockSize() + 2L + 1L + 22L;
                this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), outLength, this.useOldFormat);
            } else {
                this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), buffer);
            }
            this.genOut = this.cOut = dataEncryptor.getOutputStream(this.pOut);
            if (this.digestCalc != null) {
                this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
            }
            byte[] inLineIv = new byte[dataEncryptor.getBlockSize() + 2];
            this.rand.nextBytes(inLineIv);
            inLineIv[inLineIv.length - 1] = inLineIv[inLineIv.length - 3];
            inLineIv[inLineIv.length - 2] = inLineIv[inLineIv.length - 4];
            this.genOut.write(inLineIv);
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    private void writeWrappedSessionKey(PGPKeyEncryptionMethodGenerator m, byte[] sessionInfo) throws IOException, PGPException {
        if (m instanceof PBEKeyEncryptionMethodGenerator) {
            this.pOut.writePacket(m.generate(((PBEKeyEncryptionMethodGenerator)m).getSessionKeyWrapperAlgorithm(this.defAlgorithm), sessionInfo));
        } else {
            this.pOut.writePacket(m.generate(this.defAlgorithm, sessionInfo));
        }
    }

    public OutputStream open(OutputStream out, long length) throws IOException, PGPException {
        return this.open(out, length, null);
    }

    public OutputStream open(OutputStream out, byte[] buffer) throws IOException, PGPException {
        return this.open(out, 0L, buffer);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bOut = new BCPGOutputStream(this.genOut, 19, 20L);
                bOut.flush();
                byte[] dig = this.digestCalc.getDigest();
                this.cOut.write(dig);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private static class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, byte[] buffer) throws IOException {
            super(out, header.getType(), buffer);
            header.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, long length, boolean useOldIfPossible) throws IOException {
            super(out, header.getType(), length, useOldIfPossible);
            header.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, long length) throws IOException {
            super(out, header.getType(), length);
            header.encode(this);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

