/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPKeyPairGeneratorProvider
extends PGPKeyPairGeneratorProvider {
    private OperatorHelper helper;
    private SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();

    public JcaPGPKeyPairGeneratorProvider() {
        this.helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    }

    public JcaPGPKeyPairGeneratorProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyPairGeneratorProvider setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcaPGPKeyPairGeneratorProvider setSecureRandom(SecureRandom random) {
        this.secureRandom = random;
        return this;
    }

    public PGPKeyPairGenerator get(int version, Date creationTime) {
        return new JcaPGPKeyPairGenerator(version, creationTime, this.helper, this.secureRandom);
    }

    private static class JcaPGPKeyPairGenerator
    extends PGPKeyPairGenerator {
        private final OperatorHelper helper;

        public JcaPGPKeyPairGenerator(int version, Date creationTime, OperatorHelper helper, SecureRandom random) {
            super(version, creationTime, random, new JcaKeyFingerprintCalculator());
            this.helper = helper;
        }

        public PGPKeyPair generateRsaKeyPair(BigInteger exponent, int bitStrength) throws PGPException {
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("RSA");
                gen.initialize(new RSAKeyGenParameterSpec(bitStrength, exponent));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 1, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate RSA key pair", e);
            }
        }

        public PGPKeyPair generateEd25519KeyPair() throws PGPException {
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("EDDSA");
                gen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed25519"));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 27, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate Ed25519 key pair", e);
            }
        }

        public PGPKeyPair generateEd448KeyPair() throws PGPException {
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("EDDSA");
                gen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed448"));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 28, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate Ed448 key pair", e);
            }
        }

        public PGPKeyPair generateX25519KeyPair() throws PGPException {
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("XDH");
                gen.initialize((AlgorithmParameterSpec)new XDHParameterSpec("X25519"));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 25, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate X25519 key pair", e);
            }
        }

        public PGPKeyPair generateX448KeyPair() throws PGPException {
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("XDH");
                gen.initialize((AlgorithmParameterSpec)new XDHParameterSpec("X448"));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 26, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate X448 key pair", e);
            }
        }

        public PGPKeyPair generateLegacyEd25519KeyPair() throws PGPException {
            if (this.version == 6) {
                throw new PGPException("An implementation MUST NOT generate a v6 LegacyEd25519 key pair.");
            }
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("EDDSA");
                gen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed25519"));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 22, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate LegacyEd25519 key pair.");
            }
        }

        public PGPKeyPair generateLegacyX25519KeyPair() throws PGPException {
            if (this.version == 6) {
                throw new PGPException("An implementation MUST NOT generate a v6 LegacyX25519 key pair.");
            }
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("XDH");
                gen.initialize((AlgorithmParameterSpec)new XDHParameterSpec("X25519"));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 18, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate LegacyX25519 key pair.", e);
            }
        }

        public PGPKeyPair generateECDHKeyPair(ASN1ObjectIdentifier curveOID) throws PGPException {
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("ECDH");
                String curveName = ECUtil.getCurveName((ASN1ObjectIdentifier)curveOID);
                gen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(curveName));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 18, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate ECDH key pair.", e);
            }
        }

        public PGPKeyPair generateECDSAKeyPair(ASN1ObjectIdentifier curveOID) throws PGPException {
            try {
                KeyPairGenerator gen = this.helper.createKeyPairGenerator("ECDSA");
                String curveName = ECUtil.getCurveName((ASN1ObjectIdentifier)curveOID);
                gen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(curveName));
                KeyPair keyPair = gen.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 19, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException e) {
                throw new PGPException("Cannot generate ECDSA key pair.", e);
            }
        }
    }
}

