/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public abstract class PGPKeyRing {
    private static final Logger LOG = Logger.getLogger(PGPKeyRing.class.getName());

    PGPKeyRing() {
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream pIn) throws IOException {
        int tag = pIn.skipMarkerAndPaddingPackets();
        return tag == 12 ? (TrustPacket)pIn.readPacket() : null;
    }

    static List readSignaturesAndTrust(BCPGInputStream pIn) throws IOException {
        ArrayList<PGPSignature> sigList = new ArrayList<PGPSignature>();
        while (pIn.skipMarkerAndPaddingPackets() == 2) {
            try {
                SignaturePacket signaturePacket = (SignaturePacket)pIn.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(pIn);
                sigList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            catch (UnsupportedPacketVersionException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown signature: " + e.getMessage());
            }
        }
        return sigList;
    }

    static void readUserIDs(BCPGInputStream pIn, List ids, List idTrusts, List idSigs) throws IOException {
        while (PGPKeyRing.isUserTag(pIn.skipMarkerAndPaddingPackets())) {
            Packet obj = pIn.readPacket();
            if (obj instanceof UserIDPacket) {
                UserIDPacket id = (UserIDPacket)obj;
                ids.add(id);
            } else {
                UserAttributePacket user = (UserAttributePacket)obj;
                ids.add(new PGPUserAttributeSubpacketVector(user.getSubpackets()));
            }
            idTrusts.add(PGPKeyRing.readOptionalTrustPacket(pIn));
            idSigs.add(PGPKeyRing.readSignaturesAndTrust(pIn));
        }
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.getPublicKey().getKeyIdentifier();
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract PGPPublicKey getPublicKey(byte[] var1);

    public abstract PGPPublicKey getPublicKey(KeyIdentifier var1);

    public abstract Iterator getPublicKeys(KeyIdentifier var1);

    public abstract Iterator getKeysWithSignaturesBy(long var1);

    public abstract Iterator getKeysWithSignaturesBy(KeyIdentifier var1);

    public abstract int size();

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;

    public abstract byte[] getEncoded(PacketFormat var1) throws IOException;

    private static boolean isUserTag(int tag) {
        switch (tag) {
            case 13: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

