/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.protocol;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.mls.GroupKeySet;
import org.bouncycastle.mls.KeyScheduleEpoch;
import org.bouncycastle.mls.TranscriptHash;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.TreeKEM.LeafNode;
import org.bouncycastle.mls.TreeKEM.LeafNodeSource;
import org.bouncycastle.mls.TreeKEM.NodeIndex;
import org.bouncycastle.mls.TreeKEM.TreeKEMPrivateKey;
import org.bouncycastle.mls.TreeKEM.TreeKEMPublicKey;
import org.bouncycastle.mls.codec.AuthenticatedContent;
import org.bouncycastle.mls.codec.Capabilities;
import org.bouncycastle.mls.codec.Commit;
import org.bouncycastle.mls.codec.ContentType;
import org.bouncycastle.mls.codec.Credential;
import org.bouncycastle.mls.codec.Extension;
import org.bouncycastle.mls.codec.ExtensionType;
import org.bouncycastle.mls.codec.ExternalSender;
import org.bouncycastle.mls.codec.FramedContent;
import org.bouncycastle.mls.codec.GroupContext;
import org.bouncycastle.mls.codec.GroupInfo;
import org.bouncycastle.mls.codec.GroupSecrets;
import org.bouncycastle.mls.codec.KeyPackage;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSMessage;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.PSKType;
import org.bouncycastle.mls.codec.PreSharedKeyID;
import org.bouncycastle.mls.codec.PrivateMessage;
import org.bouncycastle.mls.codec.Proposal;
import org.bouncycastle.mls.codec.ProposalOrRef;
import org.bouncycastle.mls.codec.ProposalType;
import org.bouncycastle.mls.codec.ProtocolVersion;
import org.bouncycastle.mls.codec.PublicMessage;
import org.bouncycastle.mls.codec.ResumptionPSKUsage;
import org.bouncycastle.mls.codec.Sender;
import org.bouncycastle.mls.codec.SenderType;
import org.bouncycastle.mls.codec.UpdatePath;
import org.bouncycastle.mls.codec.Welcome;
import org.bouncycastle.mls.codec.WireFormat;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.mls.crypto.Secret;
import org.bouncycastle.mls.protocol.CachedProposal;
import org.bouncycastle.mls.protocol.CachedUpdate;

public class Group {
    public static final short NORMAL_COMMIT_PARAMS = 0;
    public static final short EXTERNAL_COMMIT_PARAMS = 1;
    public static final short RESTART_COMMIT_PARAMS = 2;
    public static final short REINIT_COMMIT_PARAMS = 3;
    Map<Secret, byte[]> externalPSKs;
    private Map<EpochRef, byte[]> resumptionPSKs;
    private long epoch;
    private byte[] groupID;
    private TranscriptHash transcriptHash;
    private ArrayList<Extension> extensions;
    private KeyScheduleEpoch keySchedule;
    private TreeKEMPublicKey tree;
    private TreeKEMPrivateKey treePriv;
    private GroupKeySet keys;
    private MlsCipherSuite suite;
    private LeafIndex index;
    private byte[] identitySk;
    private ArrayList<CachedProposal> pendingProposals;
    private CachedUpdate cachedUpdate;

    public void insertExternalPsk(Secret pskID, byte[] pskSecret) {
        this.externalPSKs.put(pskID, pskSecret);
    }

    public MlsCipherSuite getSuite() {
        return this.suite;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public KeyScheduleEpoch getKeySchedule() {
        return this.keySchedule;
    }

    public TreeKEMPublicKey getTree() {
        return this.tree;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public byte[] getGroupID() {
        return this.groupID;
    }

    public LeafIndex getIndex() {
        return this.index;
    }

    public MLSMessage getGroupInfo(boolean inlineTree) throws Exception {
        GroupInfo groupInfo = new GroupInfo(new GroupContext(this.suite, this.groupID, this.epoch, this.tree.getRootHash(), this.transcriptHash.getConfirmed(), this.extensions), new ArrayList<Extension>(), this.keySchedule.confirmationTag(this.transcriptHash.getConfirmed()));
        byte[] externalPub = this.suite.getHPKE().serializePublicKey(this.keySchedule.getExternalPublicKey());
        MLSOutputStream stream = new MLSOutputStream();
        stream.writeOpaque(externalPub);
        groupInfo.getExtensions().add(new Extension(ExtensionType.EXTERNAL_PUB, stream.toByteArray()));
        if (inlineTree) {
            groupInfo.getExtensions().add(new Extension(ExtensionType.RATCHET_TREE, MLSOutputStream.encode(this.tree)));
        }
        groupInfo.sign(this.tree, this.index, this.suite.deserializeSignaturePrivateKey(this.identitySk));
        MLSMessage msg = new MLSMessage(WireFormat.mls_group_info);
        msg.groupInfo = groupInfo;
        return msg;
    }

    public Group() {
    }

    public Group(AsymmetricCipherKeyPair sigSk, GroupInfo groupInfo, TreeKEMPublicKey tree) throws Exception {
        this.suite = groupInfo.getSuite();
        this.groupID = (byte[])groupInfo.getGroupID().clone();
        this.epoch = groupInfo.getEpoch();
        this.tree = TreeKEMPublicKey.clone(this.importTree(groupInfo.getGroupContext().getTreeHash(), tree, groupInfo.getExtensions()));
        this.treePriv = new TreeKEMPrivateKey(this.suite, new LeafIndex(0));
        this.transcriptHash = TranscriptHash.fromConfirmationTag(this.suite, groupInfo.getGroupContext().getConfirmedTranscriptHash(), groupInfo.getConfirmationTag());
        this.extensions = new ArrayList<Extension>(groupInfo.getGroupContext().getExtensions());
        this.keySchedule = new KeyScheduleEpoch(this.suite);
        this.index = new LeafIndex(0);
        this.identitySk = this.suite.serializeSignaturePrivateKey(sigSk.getPrivate());
        this.pendingProposals = new ArrayList();
        this.resumptionPSKs = new HashMap<EpochRef, byte[]>();
        this.externalPSKs = new HashMap<Secret, byte[]>();
        this.keys = null;
    }

    public Group(byte[] groupID, MlsCipherSuite suite, AsymmetricCipherKeyPair encSk, byte[] sigSk, LeafNode leafNode, List<Extension> extensions) throws Exception {
        this.suite = suite;
        this.groupID = (byte[])groupID.clone();
        this.epoch = 0L;
        this.tree = new TreeKEMPublicKey(suite);
        this.transcriptHash = new TranscriptHash(suite);
        this.extensions = new ArrayList();
        this.extensions.addAll(extensions);
        this.index = new LeafIndex(0);
        this.identitySk = (byte[])sigSk.clone();
        this.pendingProposals = new ArrayList();
        this.externalPSKs = new HashMap<Secret, byte[]>();
        this.resumptionPSKs = new HashMap<EpochRef, byte[]>();
        this.index = this.tree.addLeaf(leafNode);
        this.tree.setHashAll();
        this.treePriv = TreeKEMPrivateKey.solo(suite, this.index, encSk);
        if (!this.treePriv.consistent(this.tree)) {
            throw new Exception("LeafNode inconsistent with private key");
        }
        byte[] ctx = MLSOutputStream.encode(this.getGroupContext());
        this.keySchedule = KeyScheduleEpoch.forCreator(suite, ctx);
        this.keys = this.keySchedule.getEncryptionKeys(this.tree.getSize());
        this.transcriptHash.updateInterim(this.keySchedule.confirmationTag(this.transcriptHash.getConfirmed()));
    }

    public Group(byte[] initSk, AsymmetricCipherKeyPair leafSk, byte[] sigSk, KeyPackage keyPackage, Welcome welcome, TreeKEMPublicKey treeIn, Map<Secret, byte[]> externalPsks, Map<EpochRef, byte[]> resumptionPsks) throws Exception {
        this.pendingProposals = new ArrayList();
        this.suite = welcome.getSuite();
        this.epoch = 0L;
        this.identitySk = sigSk;
        this.externalPSKs = new HashMap<Secret, byte[]>();
        this.externalPSKs.putAll(externalPsks);
        this.resumptionPSKs = new HashMap<EpochRef, byte[]>();
        this.resumptionPSKs.putAll(resumptionPsks);
        int kpi = welcome.find(keyPackage);
        if (kpi == -1) {
            throw new Exception("Welcome not intended for key package");
        }
        if (keyPackage.getSuite().getSuiteID() != welcome.getSuite().getSuiteID()) {
            throw new Exception("Ciphersuite mismatch");
        }
        GroupSecrets secrets = welcome.decryptSecrets(kpi, initSk);
        List<KeyScheduleEpoch.PSKWithSecret> psks = this.resolve(secrets.psks);
        GroupInfo groupInfo = welcome.decrypt(secrets.joiner_secret, psks);
        if (groupInfo.getSuite().getSuiteID() != this.suite.getSuiteID()) {
            throw new Exception("GroupInfo and Welcome ciphersuites disagree");
        }
        this.tree = TreeKEMPublicKey.clone(this.importTree(groupInfo.getGroupContext().getTreeHash(), treeIn, groupInfo.getExtensions()));
        if (!groupInfo.verify(this.suite, this.tree)) {
            throw new Exception("Invalid GroupInfo");
        }
        this.epoch = groupInfo.getEpoch();
        this.groupID = groupInfo.getGroupID();
        this.transcriptHash = new TranscriptHash(this.suite, (byte[])groupInfo.getGroupContext().getConfirmedTranscriptHash().clone(), null);
        this.transcriptHash.updateInterim(groupInfo.getConfirmationTag());
        this.extensions = new ArrayList();
        this.extensions.addAll(groupInfo.getGroupContext().getExtensions());
        int i = this.tree.find(keyPackage.getLeafNode());
        if (i == -1) {
            throw new Exception("New joiner not in tree");
        }
        this.index = new LeafIndex(i);
        NodeIndex ancestor = this.index.commonAncestor(groupInfo.getSigner());
        Secret pathSecret = secrets.path_secret != null ? new Secret(secrets.path_secret.getPathSecret()) : new Secret(new byte[0]);
        this.treePriv = TreeKEMPrivateKey.joiner(this.tree, this.index, leafSk, ancestor, pathSecret);
        byte[] groupCtx = MLSOutputStream.encode(this.getGroupContext());
        this.keySchedule = KeyScheduleEpoch.joiner(this.suite, secrets.joiner_secret, psks, groupCtx);
        this.keys = this.keySchedule.getEncryptionKeys(this.tree.getSize());
        byte[] confirmationTag = this.keySchedule.confirmationTag(this.transcriptHash.getConfirmed());
        if (!Arrays.equals(confirmationTag, groupInfo.getConfirmationTag())) {
            throw new Exception("Confirmation failed to verify");
        }
    }

    public Group handle(byte[] mlsMessageBytes, Group cachedGroup) throws Exception {
        return this.handle(mlsMessageBytes, cachedGroup, null);
    }

    public Group handle(byte[] mlsMessageBytes, Group cachedGroup, CommitParameters expectedParams) throws Exception {
        AuthenticatedContent auth;
        MLSMessage msg = (MLSMessage)MLSInputStream.decode(mlsMessageBytes, MLSMessage.class);
        if (msg.version != ProtocolVersion.mls10) {
            throw new Exception("Unsupported version");
        }
        switch (msg.wireFormat) {
            case mls_public_message: {
                auth = msg.publicMessage.unprotect(this.suite, this.keySchedule.membershipKey, this.getGroupContext());
                if (auth != null) break;
                throw new Exception("Membership tag failed to verify");
            }
            case mls_private_message: {
                auth = msg.privateMessage.unprotect(this.suite, this.keys, this.keySchedule.senderDataSecret.value());
                if (auth != null) break;
                throw new Exception("PrivateMessage decryption failure");
            }
            default: {
                throw new Exception("Invalid wire format");
            }
        }
        if (!this.verifyAuth(auth)) {
            throw new Exception("Message signature failed to verify");
        }
        return this.handle(auth, cachedGroup, expectedParams);
    }

    public Group handle(AuthenticatedContent auth, Group cachedGroup, CommitParameters expectedParams) throws Exception {
        boolean externalcommit;
        FramedContent content = auth.getContent();
        if (!Arrays.equals(content.getGroupID(), this.groupID)) {
            throw new Exception("GroupID mismatch");
        }
        if (content.getEpoch() != this.epoch) {
            throw new Exception("epoch mismatch");
        }
        switch (content.getContentType()) {
            case PROPOSAL: {
                this.cacheProposal(auth);
                return null;
            }
            case COMMIT: {
                break;
            }
            default: {
                throw new Exception("Invalid content type");
            }
        }
        switch (content.getSender().getSenderType()) {
            case MEMBER: 
            case NEW_MEMBER_COMMIT: {
                break;
            }
            default: {
                throw new Exception("Invalid commit sender type");
            }
        }
        LeafIndex sender = null;
        if (content.getSender().getSenderType() == SenderType.MEMBER) {
            sender = content.getSender().getSender();
        }
        if (this.index.equals(sender)) {
            if (cachedGroup != null) {
                if (!Arrays.equals(cachedGroup.groupID, this.groupID) || cachedGroup.epoch != this.epoch + 1L || !cachedGroup.index.equals(this.index)) {
                    throw new Exception("Invalid successor state");
                }
                return cachedGroup;
            }
            throw new Exception("Handle own commits with caching");
        }
        Commit commit = content.getCommit();
        List<CachedProposal> proposals = this.mustResolve(commit.getProposals(), sender);
        CommitParameters params = this.inferCommitType(sender, proposals, expectedParams);
        boolean bl = externalcommit = params.paramID == 1;
        if (this.pathRequired(proposals) && commit.getUpdatePath() == null) {
            throw new Exception("Path required but not present");
        }
        Group next = this.successor();
        JoinersWithPSKS joinersWithPSKS = next.apply(proposals);
        byte[] forceInitSecret = null;
        LeafIndex senderLocation = new LeafIndex(0);
        if (!externalcommit) {
            senderLocation = sender;
        } else {
            UpdatePath path = commit.getUpdatePath().clone();
            senderLocation = next.tree.addLeaf(path.getLeafNode());
            byte[] kemOut = commit.validityExternal();
            if (kemOut == null) {
                throw new Exception("Invalid external commit");
            }
            forceInitSecret = this.keySchedule.receiveExternalInit(kemOut);
        }
        byte[] commitSecret = new byte[this.suite.getKDF().getHashLength()];
        if (commit.getUpdatePath() != null) {
            UpdatePath path = commit.getUpdatePath().clone();
            if (!this.validateLeafNode(path.getLeafNode(), LeafNodeSource.COMMIT, senderLocation)) {
                throw new Exception("Commit path has invalid leaf node");
            }
            if (!next.tree.verifyParentHash(senderLocation, path)) {
                throw new Exception("Commit path has invalid parent hash");
            }
            next.tree.merge(senderLocation, path);
            byte[] ctx = MLSOutputStream.encode(new GroupContext(next.suite, next.groupID, next.epoch + 1L, next.tree.getRootHash(), next.transcriptHash.getConfirmed(), next.extensions));
            next.treePriv.decap(senderLocation, next.tree, ctx, path, joinersWithPSKS.joiners);
            commitSecret = (byte[])next.treePriv.getUpdateSecret().value().clone();
        }
        next.transcriptHash.update(auth);
        ++next.epoch;
        next.updateEpochSecrets(commitSecret, joinersWithPSKS.psks, forceInitSecret);
        byte[] confirmationTag = next.keySchedule.confirmationTag(next.transcriptHash.getConfirmed());
        if (!Arrays.equals(auth.getConfirmationTag(), confirmationTag)) {
            throw new Exception("Confirmation failed to verify");
        }
        return next;
    }

    private CommitParameters inferCommitType(LeafIndex sender, List<CachedProposal> proposals, CommitParameters expectedParams) throws Exception {
        if (expectedParams != null) {
            boolean specifically = false;
            switch (expectedParams.paramID) {
                case 0: {
                    specifically = sender != null && this.validateNormalCachedProposals(proposals, sender);
                    break;
                }
                case 1: {
                    specifically = sender == null && this.validateExternalCachedProposals(proposals);
                    break;
                }
                case 2: {
                    specifically = sender != null && this.validateRestartCachedProposals(proposals, expectedParams.allowedUsage);
                    break;
                }
                case 3: {
                    boolean bl = specifically = sender != null && this.validateReInitCachedProposals(proposals);
                }
            }
            if (!specifically) {
                throw new Exception("Invalid proposal list");
            }
            return expectedParams;
        }
        if (sender == null && this.validateExternalCachedProposals(proposals)) {
            return new CommitParameters(1);
        }
        if (sender != null && this.validateNormalCachedProposals(proposals, sender)) {
            return new CommitParameters(0);
        }
        throw new Exception("Invalid proposal list");
    }

    public GroupWithMessage createBranch(byte[] groupID, AsymmetricCipherKeyPair encryptionKeyPair, AsymmetricCipherKeyPair signatureKeyPair, LeafNode leafNode, List<Extension> extList, List<KeyPackage> keyPackages, byte[] leafSecret, CommitOptions commitOptions) throws Exception {
        Group newGroup = new Group(groupID, this.suite, encryptionKeyPair, this.suite.serializeSignaturePrivateKey(signatureKeyPair.getPrivate()), leafNode, this.extensions);
        newGroup.resumptionPSKs.put(new EpochRef(this.groupID, this.epoch), (byte[])this.keySchedule.resumptionPSK.value().clone());
        ArrayList<Proposal> proposals = new ArrayList<Proposal>();
        for (KeyPackage kp : keyPackages) {
            proposals.add(newGroup.addProposal(kp));
        }
        byte[] nonce = new byte[this.suite.getKDF().getHashLength()];
        SecureRandom random = new SecureRandom();
        random.nextBytes(nonce);
        proposals.add(Proposal.preSharedKey(PreSharedKeyID.resumption(ResumptionPSKUsage.BRANCH, this.groupID, this.epoch, nonce)));
        CommitOptions opts = new CommitOptions(proposals, commitOptions.inlineTree, commitOptions.forcePath, commitOptions.leafNodeOptions);
        GroupWithMessage gwm = newGroup.commit(new Secret(leafSecret), opts, new MessageOptions(), new CommitParameters(ResumptionPSKUsage.BRANCH));
        gwm.message.wireFormat = WireFormat.mls_welcome;
        return gwm;
    }

    public Group handleBranch(AsymmetricCipherKeyPair initSk, AsymmetricCipherKeyPair encSk, AsymmetricCipherKeyPair sigSk, KeyPackage keyPackage, MLSMessage welcome, TreeKEMPublicKey tree) throws Exception {
        HashMap<EpochRef, byte[]> resumptionPsks = new HashMap<EpochRef, byte[]>();
        resumptionPsks.put(new EpochRef(this.groupID, this.epoch), (byte[])this.keySchedule.resumptionPSK.value().clone());
        Group branchGroup = new Group(this.suite.getHPKE().serializePrivateKey(initSk.getPrivate()), encSk, this.suite.serializeSignaturePrivateKey(sigSk.getPrivate()), keyPackage, welcome.welcome, tree, new HashMap<Secret, byte[]>(), resumptionPsks);
        if (branchGroup.suite.getSuiteID() != this.suite.getSuiteID()) {
            throw new Exception("Attempt to branch with a different ciphersuite");
        }
        if (branchGroup.epoch != 1L) {
            throw new Exception("Branch not done at the beginning of the group");
        }
        return branchGroup;
    }

    public Tombstone handleReinitCommit(MLSMessage commitMessage) throws Exception {
        AuthenticatedContent auth = this.unprotectToContentAuth(commitMessage);
        if (!this.verifyAuth(auth)) {
            throw new Exception("Message signature failed to verify");
        }
        Group newGroup = this.handle(auth, null, new CommitParameters(3));
        Commit commit = auth.getContent().getCommit();
        List<CachedProposal> proposals = this.mustResolve(commit.getProposals(), null);
        if (!this.validateReinitProposals(proposals)) {
            throw new Exception("Invalid proposals for reinit");
        }
        CachedProposal reinitProposal = proposals.get(0);
        return new Tombstone(newGroup, reinitProposal.proposal.getReInit());
    }

    public static GroupWithMessage externalJoin(Secret leafSecret, AsymmetricCipherKeyPair sigSk, KeyPackage keyPackage, GroupInfo groupInfo, TreeKEMPublicKey tree, MessageOptions msgOptions, LeafIndex removePrior, Map<Secret, byte[]> psks) throws Exception {
        Group initialGroup = new Group(sigSk, groupInfo, tree);
        MlsCipherSuite suite = keyPackage.getSuite();
        byte[] extPub = null;
        for (Extension ext : groupInfo.getExtensions()) {
            if (extPub != null) break;
            extPub = ext.getExternalPub();
        }
        if (extPub == null) {
            throw new Exception("No external pub in GroupInfo");
        }
        CommitOptions options = new CommitOptions();
        KeyScheduleEpoch.ExternalInitParams extParams = new KeyScheduleEpoch.ExternalInitParams(suite, suite.getHPKE().deserializePublicKey(extPub));
        options.extraProposals.add(Proposal.externalInit(extParams.getKEMOutput()));
        if (removePrior != null) {
            Proposal remove = initialGroup.removeProposal(removePrior);
            options.extraProposals.add(remove);
        }
        for (Secret id : psks.keySet()) {
            initialGroup.externalPSKs.put(id, psks.get(id));
            options.extraProposals.add(initialGroup.preSharedKeyProposal(id));
        }
        CommitParameters commitParameters = new CommitParameters(keyPackage, extParams.getInitSecret());
        GroupWithMessage gwm = initialGroup.commit(leafSecret, options, msgOptions, commitParameters);
        gwm.message.welcome = null;
        return gwm;
    }

    public GroupWithMessage commit(Secret leafSecret, CommitOptions commitOptions, MessageOptions msgOptions, CommitParameters params) throws Exception {
        int i;
        boolean forcePath;
        Commit commit = new Commit();
        ArrayList<KeyPackage> joiners = new ArrayList<KeyPackage>();
        for (CachedProposal cached : this.pendingProposals) {
            if (cached.proposal.getProposalType() == ProposalType.ADD) {
                joiners.add(cached.proposal.getAdd().keyPackage);
            }
            commit.getProposals().add(ProposalOrRef.forRef(cached.proposalRef));
        }
        if (commitOptions != null) {
            for (Proposal p : commitOptions.extraProposals) {
                if (p.getProposalType() == ProposalType.ADD) {
                    joiners.add(p.getAdd().keyPackage);
                }
                commit.getProposals().add(ProposalOrRef.forProposal(p));
            }
        }
        byte[] forceInitSecret = null;
        if (params.paramID == 1) {
            forceInitSecret = (byte[])params.forceInitSecret.value().clone();
        }
        Group next = this.successor();
        List<CachedProposal> proposals = this.mustResolve(commit.getProposals(), this.index);
        if (!this.validateCachedProposals(proposals, this.index, params)) {
            throw new Exception("Invalid proposal list");
        }
        JoinersWithPSKS joinersWithpsks = next.apply(proposals);
        if (params.paramID == 1) {
            next.index = next.tree.addLeaf(params.joinerKeyPackage.getLeafNode());
        }
        Sender sender = Sender.forMember(this.index);
        if (params.paramID == 1) {
            sender = Sender.forNewMemberCommit();
        }
        Secret commitSecret = Secret.zero(this.suite);
        ArrayList<Secret> pathSecrets = new ArrayList<Secret>();
        for (int i2 = 0; i2 < joinersWithpsks.joiners.size(); ++i2) {
            pathSecrets.add(null);
        }
        boolean bl = forcePath = commitOptions != null && commitOptions.forcePath;
        if (forcePath || this.pathRequired(proposals)) {
            LeafNodeOptions leafNodeOptions = new LeafNodeOptions();
            if (commitOptions != null) {
                leafNodeOptions = commitOptions.leafNodeOptions;
            }
            TreeKEMPrivateKey newPriv = next.tree.update(next.index, leafSecret, next.groupID, this.identitySk, leafNodeOptions);
            GroupContext ctx = new GroupContext(next.suite, next.groupID, next.epoch + 1L, next.tree.getRootHash(), next.transcriptHash.getConfirmed(), next.extensions);
            byte[] ctxBytes = MLSOutputStream.encode(ctx);
            UpdatePath path = next.tree.encap(newPriv, ctxBytes, joinersWithpsks.joiners);
            next.treePriv = newPriv;
            commit.setUpdatePath(path);
            commitSecret = newPriv.getUpdateSecret();
            for (i = 0; i < joinersWithpsks.joiners.size(); ++i) {
                pathSecrets.set(i, newPriv.getSharedPathSecret(joinersWithpsks.joiners.get(i)));
            }
            next.tree.setHashAll();
        }
        AuthenticatedContent commitContentAuth = this.sign(sender, commit, msgOptions.authenticatedData, msgOptions.encrypt);
        next.transcriptHash.updateConfirmed(commitContentAuth);
        ++next.epoch;
        next.updateEpochSecrets(commitSecret.value(), joinersWithpsks.psks, forceInitSecret);
        byte[] confirmationTag = next.keySchedule.confirmationTag(next.transcriptHash.getConfirmed());
        commitContentAuth.setConfirmationTag(confirmationTag);
        next.transcriptHash.updateInterim(commitContentAuth);
        MLSMessage commitMessage = this.protect(commitContentAuth, msgOptions.paddingSize);
        next.tree.setHashAll();
        GroupInfo groupInfo = new GroupInfo(new GroupContext(next.suite, next.groupID, next.epoch, next.tree.getRootHash(), next.transcriptHash.getConfirmed(), next.extensions), new ArrayList<Extension>(), confirmationTag);
        if (commitOptions != null && commitOptions.inlineTree) {
            groupInfo.getExtensions().add(new Extension(ExtensionType.RATCHET_TREE, MLSOutputStream.encode(next.tree)));
        }
        groupInfo.sign(next.tree, next.index, this.suite.deserializeSignaturePrivateKey(next.identitySk));
        Welcome welcome = new Welcome(this.suite, next.keySchedule.getJoinerSecret().value(), joinersWithpsks.psks, MLSOutputStream.encode(groupInfo));
        for (i = 0; i < joiners.size(); ++i) {
            welcome.encrypt((KeyPackage)joiners.get(i), (Secret)pathSecrets.get(i));
        }
        commitMessage.welcome = welcome;
        return new GroupWithMessage(next, commitMessage);
    }

    public TombstoneWithMessage reinitCommit(byte[] leafSecret, CommitOptions commitOptions, MessageOptions messageOptions) throws Exception {
        Proposal reinitProposal = null;
        if (this.pendingProposals.size() == 1) {
            reinitProposal = this.pendingProposals.get((int)0).proposal;
        } else if (commitOptions != null && commitOptions.extraProposals.size() == 1) {
            reinitProposal = commitOptions.extraProposals.get(0);
        } else {
            throw new Exception("Illegal proposals for reinitialization");
        }
        Proposal.ReInit reinit = reinitProposal.getReInit();
        GroupWithMessage gwm = this.commit(new Secret(leafSecret), commitOptions, messageOptions, new CommitParameters(3));
        gwm.message.welcome = null;
        return new TombstoneWithMessage(gwm.group, reinit, gwm.message);
    }

    public static MLSMessage newMemberAdd(byte[] groupID, long epoch, KeyPackage newMember, AsymmetricCipherKeyPair sigSk) throws Exception {
        MlsCipherSuite suite = newMember.getSuite();
        Proposal proposal = Proposal.add(newMember);
        FramedContent content = FramedContent.proposal(groupID, epoch, Sender.forNewMemberProposal(), new byte[0], MLSOutputStream.encode(proposal));
        AuthenticatedContent contentAuth = AuthenticatedContent.sign(WireFormat.mls_public_message, content, suite, suite.serializeSignaturePrivateKey(sigSk.getPrivate()), null);
        MLSMessage message = new MLSMessage(WireFormat.mls_public_message);
        message.publicMessage = PublicMessage.protect(contentAuth, suite, new byte[0], new byte[0]);
        return message;
    }

    public MLSMessage protect(byte[] applicationData, byte[] pt, int paddingSize) throws Exception {
        MessageOptions msgOptions = new MessageOptions(true, applicationData, paddingSize);
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), pt, msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    public byte[][] unprotect(MLSMessage ct) throws Exception {
        AuthenticatedContent auth = this.unprotectToContentAuth(ct);
        if (!this.verifyAuth(auth)) {
            throw new Exception("Message signature failed to verify");
        }
        if (auth.getContent().getContentType() != ContentType.APPLICATION) {
            throw new Exception("Unprotected of handshake message");
        }
        if (auth.getWireFormat() != WireFormat.mls_private_message) {
            throw new Exception("Application data not sent as PrivateMessage");
        }
        byte[][] authAndContent = new byte[][]{auth.getContent().getAuthenticated_data(), auth.getContent().getContentBytes()};
        return authAndContent;
    }

    private boolean verifyAuth(AuthenticatedContent auth) throws Exception {
        switch (auth.getContent().getSender().getSenderType()) {
            case MEMBER: {
                return this.verifyInternal(auth);
            }
            case EXTERNAL: {
                return this.verifyExternal(auth);
            }
            case NEW_MEMBER_PROPOSAL: {
                return this.verifyNewMemberProposal(auth);
            }
            case NEW_MEMBER_COMMIT: {
                return this.verifyNewMemberCommit(auth);
            }
        }
        throw new Exception("Invalid sender type");
    }

    private boolean verifyInternal(AuthenticatedContent auth) throws Exception {
        LeafNode leaf = this.tree.getLeafNode(auth.getContent().getSender().getSender());
        if (leaf == null) {
            throw new Exception("Signature from blank node");
        }
        return auth.verify(this.suite, leaf.getSignatureKey(), MLSOutputStream.encode(this.getGroupContext()));
    }

    private boolean verifyExternal(AuthenticatedContent auth) throws Exception {
        Sender extSender = auth.getContent().getSender();
        Extension sendersExt = null;
        for (Extension ext : this.extensions) {
            if (ext.extensionType != ExtensionType.EXTERNAL_SENDERS) continue;
            sendersExt = ext;
        }
        List<ExternalSender> senders = sendersExt.getSenders();
        return auth.verify(this.suite, senders.get(extSender.getSenderIndex()).getSignatureKey(), MLSOutputStream.encode(this.getGroupContext()));
    }

    private boolean verifyNewMemberProposal(AuthenticatedContent auth) throws Exception {
        Proposal proposal = auth.getContent().getProposal();
        Proposal.Add add = proposal.getAdd();
        byte[] pub = add.keyPackage.getLeafNode().getSignatureKey();
        return auth.verify(this.suite, pub, MLSOutputStream.encode(this.getGroupContext()));
    }

    private boolean verifyNewMemberCommit(AuthenticatedContent auth) throws Exception {
        Commit commit = auth.getContent().getCommit();
        UpdatePath path = commit.getUpdatePath();
        byte[] pub = path.getLeafNode().getSignatureKey();
        return auth.verify(this.suite, pub, MLSOutputStream.encode(this.getGroupContext()));
    }

    private AuthenticatedContent unprotectToContentAuth(MLSMessage msg) throws Exception {
        if (msg.version != ProtocolVersion.mls10) {
            throw new Exception("Unsupported version");
        }
        AuthenticatedContent auth = null;
        switch (msg.wireFormat) {
            case mls_public_message: {
                auth = msg.publicMessage.unprotect(this.suite, this.keySchedule.membershipKey, this.getGroupContext());
                if (auth != null) break;
                throw new Exception("Membership tag failed to verify");
            }
            case mls_private_message: {
                auth = msg.privateMessage.unprotect(this.suite, this.keys, this.keySchedule.senderDataSecret.value());
                if (auth != null) break;
                throw new Exception("PrivateMessage decryption failure");
            }
            case mls_welcome: 
            case mls_group_info: 
            case mls_key_package: {
                throw new Exception("Invalid wire format");
            }
        }
        return auth;
    }

    public MLSMessage add(KeyPackage keyPackage, MessageOptions msgOptions) throws Exception {
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), this.addProposal(keyPackage), msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    public MLSMessage update(Proposal update, MessageOptions msgOptions) throws Exception {
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), update, msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    public MLSMessage groupContextExtensions(List<Extension> extensions, MessageOptions msgOptions) throws Exception {
        if (!this.extensionsSupported(extensions)) {
            throw new Exception("Unsupported extensions");
        }
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), Proposal.groupContextExtensions(extensions), msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    public MLSMessage remove(LeafIndex removeIndex, MessageOptions msgOptions) throws Exception {
        Proposal remove = Proposal.remove(this.leafForRoster(removeIndex));
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), remove, msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    public MLSMessage reinit(byte[] groupID, ProtocolVersion version, MlsCipherSuite suite, List<Extension> extList, MessageOptions msgOptions) throws Exception {
        Proposal reinit = Proposal.reInit(groupID, version, suite, extList);
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), reinit, msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    public MLSMessage preSharedKey(byte[] externalPskId, MessageOptions msgOptions) throws Exception {
        if (!this.externalPSKs.containsKey(new Secret(externalPskId))) {
            throw new Exception("Unknown PSK");
        }
        SecureRandom random = new SecureRandom();
        byte[] nonce = new byte[this.suite.getKDF().getHashLength()];
        random.nextBytes(nonce);
        PreSharedKeyID pskId = PreSharedKeyID.external(externalPskId, nonce);
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), Proposal.preSharedKey(pskId), msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    public MLSMessage preSharedKey(byte[] groupID, long epoch, MessageOptions msgOptions) throws Exception {
        if (epoch != this.epoch && !this.resumptionPSKs.containsKey(new EpochRef(groupID, epoch))) {
            throw new Exception("Unknown PSK");
        }
        SecureRandom random = new SecureRandom();
        byte[] nonce = new byte[this.suite.getKDF().getHashLength()];
        random.nextBytes(nonce);
        PreSharedKeyID pskId = PreSharedKeyID.resumption(ResumptionPSKUsage.APPLICATION, groupID, epoch, nonce);
        AuthenticatedContent contentAuth = this.sign(Sender.forMember(this.index), Proposal.preSharedKey(pskId), msgOptions.authenticatedData, msgOptions.encrypt);
        return this.protect(contentAuth, msgOptions.paddingSize);
    }

    private LeafIndex leafForRoster(LeafIndex index) throws Exception {
        int nonBlankLeaves = 0;
        int i = 0;
        while ((long)i < this.tree.getSize().leafCount()) {
            LeafNode leaf = this.tree.getLeafNode(new LeafIndex(i));
            if (leaf != null) {
                if (nonBlankLeaves == index.value()) {
                    return new LeafIndex(i);
                }
                ++nonBlankLeaves;
            }
            ++i;
        }
        throw new Exception("Invalid roster index");
    }

    public Proposal updateProposal(AsymmetricCipherKeyPair leafSk, LeafNodeOptions leafOptions) throws Exception {
        LeafNode leaf = this.tree.getLeafNode(this.index);
        LeafNode newLeaf = leaf.forUpdate(this.suite, this.groupID, this.index, this.suite.getHPKE().serializePublicKey(leafSk.getPublic()), leafOptions, this.identitySk);
        Proposal update = Proposal.update(newLeaf);
        this.cachedUpdate = new CachedUpdate(this.suite.getHPKE().serializePrivateKey(leafSk.getPrivate()), update.getUpdate());
        return update;
    }

    private Proposal addProposal(KeyPackage keyPackage) throws Exception {
        if (!keyPackage.verify()) {
            throw new Exception("Invalid signature on key package");
        }
        return Proposal.add(keyPackage);
    }

    private MLSMessage protect(AuthenticatedContent contentAuth, int paddingSize) throws Exception {
        MLSMessage message = new MLSMessage(contentAuth.getWireFormat());
        switch (contentAuth.getWireFormat()) {
            case mls_public_message: {
                message.publicMessage = PublicMessage.protect(contentAuth, this.suite, this.keySchedule.membershipKey.value(), MLSOutputStream.encode(this.getGroupContext()));
                return message;
            }
            case mls_private_message: {
                message.privateMessage = PrivateMessage.protect(contentAuth, this.suite, this.keys, this.keySchedule.senderDataSecret.value(), paddingSize);
                return message;
            }
        }
        throw new Exception("Malformed AuthenticatedContent");
    }

    private AuthenticatedContent sign(Sender sender, Commit innerContent, byte[] authenticatedData, boolean encrypt) throws Exception {
        FramedContent content = FramedContent.rawContent(this.groupID, this.epoch, sender, authenticatedData, ContentType.COMMIT, MLSOutputStream.encode(innerContent));
        WireFormat wireFormat = encrypt ? WireFormat.mls_private_message : WireFormat.mls_public_message;
        AuthenticatedContent authContent = AuthenticatedContent.sign(wireFormat, content, this.suite, this.identitySk, MLSOutputStream.encode(this.getGroupContext()));
        return authContent;
    }

    private AuthenticatedContent sign(Sender sender, Proposal innerContent, byte[] authenticatedData, boolean encrypt) throws Exception {
        FramedContent content = FramedContent.rawContent(this.groupID, this.epoch, sender, authenticatedData, ContentType.PROPOSAL, MLSOutputStream.encode(innerContent));
        WireFormat wireFormat = encrypt ? WireFormat.mls_private_message : WireFormat.mls_public_message;
        AuthenticatedContent authContent = AuthenticatedContent.sign(wireFormat, content, this.suite, this.identitySk, MLSOutputStream.encode(this.getGroupContext()));
        return authContent;
    }

    private AuthenticatedContent sign(Sender sender, byte[] innerContent, byte[] authenticatedData, boolean encrypt) throws Exception {
        FramedContent content = FramedContent.rawContent(this.groupID, this.epoch, sender, authenticatedData, ContentType.APPLICATION, innerContent);
        WireFormat wireFormat = encrypt ? WireFormat.mls_private_message : WireFormat.mls_public_message;
        AuthenticatedContent authContent = AuthenticatedContent.sign(wireFormat, content, this.suite, this.identitySk, MLSOutputStream.encode(this.getGroupContext()));
        return authContent;
    }

    private Proposal preSharedKeyProposal(Secret externalPskID) throws Exception {
        if (!this.externalPSKs.containsKey(externalPskID)) {
            throw new Exception("Unknown PSK");
        }
        SecureRandom random = new SecureRandom();
        byte[] nonce = new byte[this.suite.getKDF().getHashLength()];
        random.nextBytes(nonce);
        return Proposal.preSharedKey(PreSharedKeyID.external(externalPskID.value(), nonce));
    }

    private Proposal removeProposal(LeafIndex removed) throws Exception {
        if (!this.tree.hasLeaf(removed)) {
            throw new Exception("Removed on blank leaf");
        }
        return Proposal.remove(removed);
    }

    private void updateEpochSecrets(byte[] commitSecret, List<KeyScheduleEpoch.PSKWithSecret> psks, byte[] forceInitSecret) throws Exception {
        byte[] ctx = MLSOutputStream.encode(new GroupContext(this.suite, this.groupID, this.epoch, this.tree.getRootHash(), this.transcriptHash.getConfirmed(), this.extensions));
        this.keySchedule = this.keySchedule.next(this.tree.getSize(), forceInitSecret, new Secret(commitSecret), psks, ctx);
        this.keys = this.keySchedule.getEncryptionKeys(this.tree.getSize());
    }

    private JoinersWithPSKS apply(List<CachedProposal> proposals) throws Exception {
        this.applyUpdate(proposals);
        this.applyRemove(proposals);
        List<LeafIndex> joinerLocs = this.applyAdd(proposals);
        this.applyGCE(proposals);
        List<KeyScheduleEpoch.PSKWithSecret> psks = this.applyPSK(proposals);
        this.tree.truncate();
        this.treePriv.truncate(this.tree.getSize());
        this.tree.setHashAll();
        if (this.cachedUpdate != null) {
            this.cachedUpdate.reset();
        }
        return new JoinersWithPSKS(joinerLocs, psks);
    }

    private void applyUpdate(List<CachedProposal> proposals) throws Exception {
        for (CachedProposal cached : proposals) {
            if (cached.proposal.getProposalType() != ProposalType.UPDATE) continue;
            if (cached.sender == null) {
                throw new Exception("Update without target leaf");
            }
            LeafIndex target = cached.sender;
            if (!target.equals(this.index)) {
                this.tree.updateLeaf(target, cached.proposal.getLeafNode());
                continue;
            }
            if (this.cachedUpdate == null) {
                throw new Exception("Self-update with no cached secret");
            }
            if (!cached.proposal.getLeafNode().equals(this.cachedUpdate.update.getLeafNode())) {
                throw new Exception("Self-update does not match cached data");
            }
            this.tree.updateLeaf(target, cached.proposal.getLeafNode());
            this.treePriv.setLeafKey(this.cachedUpdate.updateSk);
        }
        if (this.cachedUpdate != null) {
            this.cachedUpdate.reset();
        }
    }

    private boolean extensionsSupported(List<Extension> exts) {
        int i = 0;
        while ((long)i < this.tree.getSize().leafCount()) {
            LeafIndex leafIndex = new LeafIndex(i);
            LeafNode leaf = this.tree.getLeafNode(leafIndex);
            if (leaf != null && !leaf.verifyExtensionSupport(exts)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void applyGCE(List<CachedProposal> proposals) throws Exception {
        for (CachedProposal cached : proposals) {
            if (cached.proposal.getProposalType() != ProposalType.GROUP_CONTEXT_EXTENSIONS) continue;
            if (!this.extensionsSupported(cached.proposal.getGroupContextExtensions().extensions)) {
                throw new Exception("Unsupported extensions in GroupContextExtensions");
            }
            this.extensions = new ArrayList<Extension>(cached.proposal.getGroupContextExtensions().extensions);
        }
    }

    private List<KeyScheduleEpoch.PSKWithSecret> applyPSK(List<CachedProposal> proposals) throws Exception {
        ArrayList<PreSharedKeyID> pskIDs = new ArrayList<PreSharedKeyID>();
        for (CachedProposal cached : proposals) {
            if (cached.proposal.getProposalType() != ProposalType.PSK) continue;
            pskIDs.add(cached.proposal.getPreSharedKey().psk);
        }
        return this.resolve(pskIDs);
    }

    private List<LeafIndex> applyAdd(List<CachedProposal> proposals) {
        ArrayList<LeafIndex> locations = new ArrayList<LeafIndex>();
        for (CachedProposal cached : proposals) {
            if (cached.proposal.getProposalType() != ProposalType.ADD) continue;
            locations.add(this.tree.addLeaf(cached.proposal.getLeafNode()));
        }
        return locations;
    }

    private void applyRemove(List<CachedProposal> proposals) throws Exception {
        for (CachedProposal cached : proposals) {
            if (cached.proposal.getProposalType() != ProposalType.REMOVE) continue;
            if (!this.tree.hasLeaf(cached.proposal.getRemove().removed)) {
                throw new Exception("Attempt to remove non-member");
            }
            this.tree.blankPath(cached.proposal.getRemove().removed);
        }
    }

    private Group successor() throws IOException {
        Group next = new Group();
        next.externalPSKs = new HashMap<Secret, byte[]>(this.externalPSKs);
        next.resumptionPSKs = new HashMap<EpochRef, byte[]>();
        next.resumptionPSKs.putAll(this.resumptionPSKs);
        next.epoch = this.epoch;
        next.groupID = (byte[])this.groupID.clone();
        next.transcriptHash = this.transcriptHash.copy();
        next.extensions = new ArrayList();
        next.extensions.addAll(this.extensions);
        next.keySchedule = this.keySchedule;
        next.tree = TreeKEMPublicKey.clone(this.tree);
        next.treePriv = this.treePriv.copy();
        next.keys = this.keys;
        next.suite = this.suite;
        next.index = this.index;
        next.identitySk = (byte[])this.identitySk.clone();
        next.pendingProposals = new ArrayList();
        next.cachedUpdate = this.cachedUpdate;
        next.resumptionPSKs.put(new EpochRef(this.groupID, this.epoch), (byte[])this.keySchedule.resumptionPSK.value().clone());
        return next;
    }

    private boolean pathRequired(List<CachedProposal> proposals) {
        if (proposals.isEmpty()) {
            return true;
        }
        for (CachedProposal cached : proposals) {
            switch (cached.proposal.getProposalType()) {
                case UPDATE: 
                case REMOVE: 
                case EXTERNAL_INIT: 
                case GROUP_CONTEXT_EXTENSIONS: {
                    return true;
                }
            }
        }
        return false;
    }

    public byte[] getEpochAuthenticator() {
        return this.keySchedule.epochAuthenticator.value();
    }

    private void cacheProposal(AuthenticatedContent auth) throws Exception {
        Proposal proposal;
        byte[] ref = this.suite.refHash(MLSOutputStream.encode(auth), "MLS 1.0 Proposal Reference");
        for (CachedProposal cached : this.pendingProposals) {
            if (!Arrays.equals(cached.proposalRef, ref)) continue;
            return;
        }
        LeafIndex senderLocation = null;
        if (auth.getContent().getSender().getSenderType() == SenderType.MEMBER) {
            senderLocation = auth.getContent().getSender().getSender();
        }
        if (!this.validateProposal(senderLocation, proposal = auth.getContent().getProposal())) {
            throw new Exception("Invalid proposal");
        }
        this.pendingProposals.add(new CachedProposal(ref, proposal, senderLocation));
    }

    private boolean validateProposal(LeafIndex sender, Proposal proposal) throws IOException {
        switch (proposal.getProposalType()) {
            case UPDATE: {
                return this.validateUpdate(sender, proposal.getUpdate());
            }
            case ADD: {
                return this.validateKeyPackage(proposal.getAdd().keyPackage);
            }
            case REMOVE: {
                return this.validateRemove(proposal.getRemove());
            }
            case PSK: {
                return this.validatePSK(proposal.getPreSharedKey());
            }
            case REINIT: {
                return this.validateReinit(proposal.getReInit());
            }
            case EXTERNAL_INIT: {
                return this.validateExternalInit(proposal.getExternalInit());
            }
            case GROUP_CONTEXT_EXTENSIONS: {
                return this.validateGCE(proposal.getGroupContextExtensions());
            }
        }
        return false;
    }

    private boolean validateGCE(Proposal.GroupContextExtensions gce) {
        int i = 0;
        while ((long)i < this.tree.getSize().leafCount()) {
            LeafIndex index = new LeafIndex(i);
            LeafNode leaf = this.tree.getLeafNode(index);
            if (leaf != null && !leaf.verifyExtensionSupport(gce.extensions)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean validateExternalInit(Proposal.ExternalInit ext) {
        return ext.kemOutput.length == this.suite.getHPKE().getEncSize();
    }

    private boolean validateReinit(Proposal.ReInit reInit) {
        boolean supportedVersion = reInit.getVersion() == ProtocolVersion.mls10;
        boolean supportedSuite = true;
        return supportedSuite && supportedVersion;
    }

    private boolean validateReinitProposals(List<CachedProposal> proposals) {
        boolean hasReinit = false;
        boolean hasDisallowed = false;
        for (CachedProposal cached : proposals) {
            hasReinit = hasReinit || cached.proposal.getProposalType() == ProposalType.REINIT;
            hasDisallowed = hasDisallowed || cached.proposal.getProposalType() != ProposalType.REINIT;
        }
        return hasReinit && !hasDisallowed;
    }

    private boolean validatePSK(Proposal.PreSharedKey psk) {
        switch (psk.psk.pskType) {
            case EXTERNAL: {
                return this.externalPSKs.containsKey(psk.psk.external.externalPSKID);
            }
            case RESUMPTION: {
                PreSharedKeyID.Resumption res = psk.psk.resumption;
                if (res.resumptionPSKUsage != ResumptionPSKUsage.APPLICATION) {
                    return false;
                }
                return res.pskEpoch == this.epoch || this.resumptionPSKs.containsKey(new EpochRef(res.pskGroupID, res.pskEpoch));
            }
        }
        return false;
    }

    private boolean validateRemove(Proposal.Remove remove) {
        boolean in_tree = (long)remove.removed.value() < this.tree.getSize().leafCount() && this.tree.hasLeaf(remove.removed);
        boolean not_me = remove.removed.value() != this.index.value();
        return in_tree && not_me;
    }

    private boolean validateKeyPackage(KeyPackage keyPackage) throws IOException {
        boolean correct_ciphersuite = keyPackage.getSuite().getSuiteID() == this.suite.getSuiteID();
        boolean valid_signature = keyPackage.verify();
        boolean leaf_node_valid = this.validateLeafNode(keyPackage.getLeafNode(), LeafNodeSource.KEY_PACKAGE, null);
        boolean distinct_keys = !Arrays.equals(keyPackage.getInitKey(), keyPackage.getLeafNode().getEncryptionKey());
        return correct_ciphersuite && valid_signature && leaf_node_valid && distinct_keys;
    }

    private boolean validateUpdate(LeafIndex sender, Proposal.Update update) throws IOException {
        LeafNode leaf = this.tree.getLeafNode(sender);
        if (leaf == null) {
            return false;
        }
        return this.validateLeafNode(update.getLeafNode(), LeafNodeSource.UPDATE, sender);
    }

    private boolean validateLeafNode(LeafNode leafNode, LeafNodeSource requiredSource, LeafIndex index) throws IOException {
        byte[] tbs;
        boolean isCorrectSource = leafNode.getSource() == requiredSource;
        switch (requiredSource) {
            case UPDATE: 
            case COMMIT: {
                tbs = leafNode.toBeSigned(this.groupID, index.value());
                break;
            }
            default: {
                tbs = leafNode.toBeSigned(null, -1);
            }
        }
        boolean isSignatureValid = leafNode.verify(this.suite, tbs);
        boolean supportsGroupExtensions = true;
        boolean isLifetimeValid = leafNode.verifyLifetime();
        boolean mutualCredentialSupport = true;
        boolean isUniqueSigKey = true;
        boolean isUniqueEncKey = true;
        byte[] sigKey = leafNode.getSignatureKey();
        byte[] encKey = leafNode.getEncryptionKey();
        int i = 0;
        while ((long)i < this.tree.getSize().leafCount()) {
            LeafNode leaf = this.tree.getLeafNode(new LeafIndex(i));
            if (leaf != null) {
                isUniqueSigKey &= index != null && i == index.value() || !Arrays.equals(sigKey, leaf.getSignatureKey());
                isUniqueEncKey &= !Arrays.equals(encKey, leaf.getEncryptionKey());
            }
            ++i;
        }
        boolean supportsAllExtensions = true;
        for (Extension ext : leafNode.getExtensions()) {
            supportsAllExtensions &= leafNode.getCapabilities().getExtensions().contains(ext.extensionType.getValue());
        }
        return isCorrectSource && isSignatureValid && isLifetimeValid && supportsAllExtensions && isUniqueSigKey && isUniqueEncKey && mutualCredentialSupport && supportsGroupExtensions;
    }

    private boolean validateCachedProposals(List<CachedProposal> proposals, LeafIndex commitSender, CommitParameters params) throws IOException {
        switch (params.paramID) {
            case 0: {
                return this.validateNormalCachedProposals(proposals, commitSender);
            }
            case 1: {
                return this.validateExternalCachedProposals(proposals);
            }
            case 2: {
                return this.validateRestartCachedProposals(proposals, params.allowedUsage);
            }
            case 3: {
                return this.validateReInitCachedProposals(proposals);
            }
        }
        return false;
    }

    private boolean validateReInitCachedProposals(List<CachedProposal> proposals) {
        boolean has_reinit = false;
        boolean has_disallowed = false;
        for (CachedProposal cached : proposals) {
            has_reinit = has_reinit || cached.proposal.getProposalType() == ProposalType.REINIT;
            has_disallowed = has_disallowed || cached.proposal.getProposalType() != ProposalType.REINIT;
        }
        return has_reinit && !has_disallowed;
    }

    private boolean validateRestartCachedProposals(List<CachedProposal> proposals, ResumptionPSKUsage allowedUsage) {
        boolean foundAllowed = false;
        boolean acceptable_psks = true;
        for (CachedProposal cached : proposals) {
            boolean allowed;
            if (cached.proposal.getProposalType() != ProposalType.PSK) continue;
            PreSharedKeyID psk = cached.proposal.getPreSharedKey().psk;
            if (psk.pskType == PSKType.EXTERNAL) continue;
            boolean bl = allowed = psk.resumption.resumptionPSKUsage == allowedUsage;
            if (foundAllowed && allowed) {
                acceptable_psks = false;
                continue;
            }
            foundAllowed = foundAllowed || allowed;
        }
        return acceptable_psks && foundAllowed;
    }

    private boolean validateNormalCachedProposals(List<CachedProposal> proposals, LeafIndex commitSender) throws IOException {
        Object sig;
        boolean has_invalid_proposal = false;
        boolean has_self_update = false;
        boolean has_self_remove = false;
        for (CachedProposal cached : proposals) {
            has_invalid_proposal = has_invalid_proposal || !this.validateProposal(cached.sender, cached.proposal);
            has_self_update = has_self_update || cached.proposal.getProposalType() == ProposalType.UPDATE && cached.sender.equals(commitSender);
            has_self_remove = has_self_remove || cached.proposal.getProposalType() == ProposalType.REMOVE && cached.proposal.getRemove().removed.equals(commitSender);
        }
        HashSet<Object> updatedOrRemoved = new HashSet<Object>();
        boolean has_dup_update_remove = false;
        block9: for (CachedProposal cached : proposals) {
            Object leafIndex;
            switch (cached.proposal.getProposalType()) {
                case UPDATE: {
                    leafIndex = cached.sender;
                    break;
                }
                case REMOVE: {
                    leafIndex = cached.proposal.getRemove().removed;
                    break;
                }
                default: {
                    continue block9;
                }
            }
            if (updatedOrRemoved.contains(leafIndex)) {
                has_dup_update_remove = true;
                continue;
            }
            updatedOrRemoved.add(leafIndex);
        }
        ArrayList<byte[]> signatureKeys = new ArrayList<byte[]>();
        boolean has_dup_signature_key = false;
        for (CachedProposal cached : proposals) {
            if (cached.proposal.getProposalType() != ProposalType.ADD) continue;
            KeyPackage keyPackage = cached.proposal.getAdd().keyPackage;
            byte[] byArray = keyPackage.getLeafNode().getSignatureKey();
            boolean areEqual = false;
            Iterator iterator = signatureKeys.iterator();
            while (iterator.hasNext()) {
                sig = (byte[])iterator.next();
                if (!Arrays.equals(sig, byArray)) continue;
                areEqual = true;
                break;
            }
            if (areEqual) {
                has_dup_signature_key = true;
                continue;
            }
            signatureKeys.add(byArray);
        }
        ArrayList<PreSharedKeyID> pskids = new ArrayList<PreSharedKeyID>();
        boolean has_dup_psk_id = false;
        for (CachedProposal cachedProposal : proposals) {
            if (cachedProposal.proposal.getProposalType() != ProposalType.PSK) continue;
            PreSharedKeyID pskid = cachedProposal.proposal.getPreSharedKey().psk;
            if (pskids.contains(pskid)) {
                has_dup_psk_id = true;
                continue;
            }
            pskids.add(pskid);
        }
        int gceCount = 0;
        for (CachedProposal cached : proposals) {
            if (cached.proposal.getProposalType() != ProposalType.GROUP_CONTEXT_EXTENSIONS) continue;
            ++gceCount;
        }
        boolean bl = gceCount > 1;
        boolean has_reinit = false;
        boolean has_external_init = false;
        sig = proposals.iterator();
        while (sig.hasNext()) {
            CachedProposal cached = (CachedProposal)sig.next();
            has_reinit = has_reinit || cached.proposal.getProposalType() == ProposalType.REINIT;
            has_external_init = has_external_init || cached.proposal.getProposalType() == ProposalType.EXTERNAL_INIT;
        }
        ArrayList<byte[]> encKeys = new ArrayList<byte[]>();
        boolean has_dup_enc_key = false;
        block15: for (CachedProposal cached : proposals) {
            byte[] encKey;
            switch (cached.proposal.getProposalType()) {
                case ADD: {
                    encKey = (byte[])cached.proposal.getAdd().keyPackage.getLeafNode().getEncryptionKey().clone();
                    break;
                }
                case UPDATE: {
                    encKey = (byte[])cached.proposal.getUpdate().getLeafNode().getEncryptionKey().clone();
                    break;
                }
                default: {
                    continue block15;
                }
            }
            boolean areEqual = false;
            for (byte[] key : encKeys) {
                if (!Arrays.equals(key, encKey)) continue;
                areEqual = true;
                break;
            }
            if (areEqual) {
                has_dup_enc_key = true;
                continue;
            }
            encKeys.add(encKey);
        }
        return !has_invalid_proposal && !has_self_update && !has_self_remove && !has_dup_update_remove && !has_dup_signature_key && !has_dup_psk_id && !bl && !has_reinit && !has_external_init && !has_dup_enc_key;
    }

    private boolean validateExternalCachedProposals(List<CachedProposal> proposals) {
        int extInitCount = 0;
        int removeCount = 0;
        boolean noDisallowed = true;
        block5: for (CachedProposal cached : proposals) {
            switch (cached.proposal.getProposalType()) {
                case EXTERNAL_INIT: {
                    ++extInitCount;
                    continue block5;
                }
                case REMOVE: {
                    ++removeCount;
                    continue block5;
                }
                case PSK: {
                    noDisallowed = noDisallowed && this.validatePSK(cached.proposal.getPreSharedKey());
                    continue block5;
                }
            }
            noDisallowed = false;
        }
        boolean hasOneExtInit = extInitCount == 1;
        boolean noDupRemove = removeCount <= 1;
        return hasOneExtInit && noDupRemove && noDisallowed;
    }

    private List<CachedProposal> mustResolve(List<ProposalOrRef> proposals, LeafIndex sender) {
        ArrayList<CachedProposal> out = new ArrayList<CachedProposal>();
        for (ProposalOrRef id : proposals) {
            block0 : switch (id.getType()) {
                case PROPOSAL: {
                    out.add(new CachedProposal(new byte[0], id.getProposal(), sender));
                    break;
                }
                case REFERENCE: {
                    for (CachedProposal cached : this.pendingProposals) {
                        if (!Arrays.equals(cached.proposalRef, id.getReference())) continue;
                        out.add(cached);
                        break block0;
                    }
                    break;
                }
            }
        }
        return out;
    }

    private GroupContext getGroupContext() throws Exception {
        return new GroupContext(this.suite, this.groupID, this.epoch, this.tree.getRootHash(), this.transcriptHash.getConfirmed(), this.extensions);
    }

    private TreeKEMPublicKey importTree(byte[] treeHash, TreeKEMPublicKey external, List<Extension> extensions) throws Exception {
        Extension ext;
        TreeKEMPublicKey outTree = null;
        Iterator<Extension> iterator = extensions.iterator();
        while (iterator.hasNext() && (outTree = (ext = iterator.next()).getRatchetTree()) == null) {
        }
        if (external != null) {
            outTree = external;
        } else if (outTree == null) {
            throw new Exception("No tree available");
        }
        outTree.setSuite(this.suite);
        outTree.setHashAll();
        if (!Arrays.equals(outTree.getRootHash(), treeHash)) {
            throw new Exception("Tree does not match GroupInfo");
        }
        if (!outTree.verifyParentHash()) {
            throw new Exception("Invalid tree");
        }
        return outTree;
    }

    private List<KeyScheduleEpoch.PSKWithSecret> resolve(List<PreSharedKeyID> psks) throws Exception {
        ArrayList<KeyScheduleEpoch.PSKWithSecret> out = new ArrayList<KeyScheduleEpoch.PSKWithSecret>();
        for (PreSharedKeyID psk : psks) {
            switch (psk.pskType) {
                case EXTERNAL: {
                    if (!this.externalPSKs.containsKey(psk.external.externalPSKID)) {
                        throw new Exception("Unknown external PSK");
                    }
                    out.add(new KeyScheduleEpoch.PSKWithSecret(psk, new Secret((byte[])this.externalPSKs.get(psk.external.externalPSKID).clone())));
                    break;
                }
                case RESUMPTION: {
                    if (psk.resumption.pskEpoch == this.epoch) {
                        out.add(new KeyScheduleEpoch.PSKWithSecret(psk, this.keySchedule.resumptionPSK));
                        break;
                    }
                    EpochRef key = new EpochRef(psk.resumption.pskGroupID, psk.resumption.pskEpoch);
                    if (!this.resumptionPSKs.containsKey(key)) {
                        throw new Exception("Unknown resumption PSK");
                    }
                    out.add(new KeyScheduleEpoch.PSKWithSecret(psk, new Secret((byte[])this.resumptionPSKs.get(key).clone())));
                }
            }
        }
        return out;
    }

    public static class CommitOptions {
        List<Proposal> extraProposals;
        boolean inlineTree;
        boolean forcePath;
        LeafNodeOptions leafNodeOptions;

        public CommitOptions() {
            this.extraProposals = new ArrayList<Proposal>();
            this.leafNodeOptions = new LeafNodeOptions();
        }

        public CommitOptions(List<Proposal> extraProposals, boolean inlineTree, boolean forcePath, LeafNodeOptions leafNodeOptions) {
            this.extraProposals = extraProposals;
            this.inlineTree = inlineTree;
            this.forcePath = forcePath;
            this.leafNodeOptions = leafNodeOptions == null ? new LeafNodeOptions() : leafNodeOptions;
        }
    }

    public static class CommitParameters {
        short paramID;
        KeyPackage joinerKeyPackage;
        Secret forceInitSecret;
        ResumptionPSKUsage allowedUsage;

        public CommitParameters(short paramID) {
            this.paramID = paramID;
        }

        public CommitParameters(KeyPackage joinerKeyPackage, Secret forceInitSecret) {
            this.paramID = 1;
            this.joinerKeyPackage = joinerKeyPackage;
            this.forceInitSecret = forceInitSecret;
        }

        public CommitParameters(short paramID, KeyPackage joinerKeyPackage, Secret forceInitSecret, ResumptionPSKUsage allowedUsage) {
            this.paramID = paramID;
            this.joinerKeyPackage = joinerKeyPackage;
            this.forceInitSecret = forceInitSecret;
            this.allowedUsage = allowedUsage;
        }

        public CommitParameters(ResumptionPSKUsage reinit) {
            this.paramID = (short)2;
            this.allowedUsage = reinit;
        }
    }

    public static class EpochRef {
        byte[] id;
        long epoch;

        public EpochRef(byte[] id, long epoch) {
            this.id = (byte[])id.clone();
            this.epoch = epoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EpochRef epochRef = (EpochRef)o;
            if (this.epoch != epochRef.epoch) {
                return false;
            }
            return Arrays.equals(this.id, epochRef.id);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.id);
            result = 31 * result + (int)(this.epoch ^ this.epoch >>> 32);
            return result;
        }
    }

    public static class GroupWithMessage {
        public Group group;
        public MLSMessage message;

        public GroupWithMessage(Group group, MLSMessage message) {
            this.group = group;
            this.message = message;
        }
    }

    static class JoinersWithPSKS {
        List<LeafIndex> joiners;
        List<KeyScheduleEpoch.PSKWithSecret> psks;

        public JoinersWithPSKS(List<LeafIndex> joiners, List<KeyScheduleEpoch.PSKWithSecret> psks) {
            this.psks = psks;
            this.joiners = joiners;
        }
    }

    public static class LeafNodeOptions {
        Credential credential;
        Capabilities capabilities;
        List<Extension> extensions;

        public Credential getCredential() {
            return this.credential;
        }

        public Capabilities getCapabilities() {
            return this.capabilities;
        }

        public List<Extension> getExtensions() {
            return this.extensions;
        }

        public LeafNodeOptions() {
        }

        public LeafNodeOptions(Credential credential, Capabilities capabilities, List<Extension> extensions) {
            this.credential = credential;
            this.capabilities = capabilities;
            this.extensions = extensions;
        }
    }

    public static class MessageOptions {
        boolean encrypt = false;
        byte[] authenticatedData;
        int paddingSize = 0;

        public MessageOptions() {
            this.authenticatedData = new byte[0];
        }

        public MessageOptions(boolean encrypt, byte[] authenticatedData, int paddingSize) {
            this.encrypt = encrypt;
            this.authenticatedData = authenticatedData;
            this.paddingSize = paddingSize;
        }
    }

    public class Tombstone {
        final byte[] epochAuthenticator;
        final Proposal.ReInit reinit;
        private byte[] priorGroupID;
        private long priorEpoch;
        private byte[] resumptionPsk;

        public byte[] getEpochAuthenticator() {
            return this.epochAuthenticator;
        }

        public MlsCipherSuite getSuite() {
            return this.reinit.getSuite();
        }

        public Tombstone(Group group, Proposal.ReInit reinit) {
            this.epochAuthenticator = group.getEpochAuthenticator();
            this.reinit = reinit;
            this.priorGroupID = group.groupID;
            this.priorEpoch = group.epoch;
            this.resumptionPsk = ((Group)group).keySchedule.resumptionPSK.value();
        }

        public GroupWithMessage createWelcome(AsymmetricCipherKeyPair encSk, byte[] sigSk, LeafNode leafNode, List<KeyPackage> keyPackages, byte[] leafSecret, CommitOptions options) throws Exception {
            Group newGroup = new Group(this.reinit.getGroupID(), this.reinit.getSuite(), encSk, sigSk, leafNode, this.reinit.getExtensions());
            newGroup.resumptionPSKs.put(new EpochRef(this.priorGroupID, this.priorEpoch), this.resumptionPsk);
            ArrayList<Proposal> proposals = new ArrayList<Proposal>();
            for (KeyPackage kp : keyPackages) {
                proposals.add(newGroup.addProposal(kp));
            }
            byte[] nonce = new byte[Group.this.suite.getKDF().getHashLength()];
            SecureRandom random = new SecureRandom();
            random.nextBytes(nonce);
            proposals.add(Proposal.preSharedKey(PreSharedKeyID.resumption(ResumptionPSKUsage.REINIT, this.priorGroupID, this.priorEpoch, nonce)));
            CommitOptions opts = new CommitOptions(proposals, options.inlineTree, options.forcePath, options.leafNodeOptions);
            GroupWithMessage gwm = newGroup.commit(new Secret(leafSecret), opts, new MessageOptions(), new CommitParameters(ResumptionPSKUsage.REINIT));
            gwm.message.wireFormat = WireFormat.mls_welcome;
            return gwm;
        }

        public Group handleWelcome(AsymmetricCipherKeyPair initSk, AsymmetricCipherKeyPair encSk, AsymmetricCipherKeyPair sigSk, KeyPackage keyPackage, MLSMessage welcome, TreeKEMPublicKey tree) throws Exception {
            HashMap<EpochRef, byte[]> resumptionPsks = new HashMap<EpochRef, byte[]>();
            resumptionPsks.put(new EpochRef(this.priorGroupID, this.priorEpoch), this.resumptionPsk);
            MlsCipherSuite suite = welcome.getCipherSuite();
            Group newGroup = new Group(suite.getHPKE().serializePrivateKey(initSk.getPrivate()), encSk, suite.serializeSignaturePrivateKey(sigSk.getPrivate()), keyPackage, welcome.welcome, tree, new HashMap<Secret, byte[]>(), resumptionPsks);
            if (newGroup.suite.getSuiteID() != this.reinit.getSuite().getSuiteID()) {
                throw new Exception("Attempt to reinit with the wrong ciphersuite");
            }
            if (newGroup.epoch != 1L) {
                throw new Exception("Reinit not done at the beginning of the group");
            }
            return newGroup;
        }
    }

    public class TombstoneWithMessage
    extends Tombstone {
        MLSMessage message;

        public MLSMessage getMessage() {
            return this.message;
        }

        public TombstoneWithMessage(Group group, Proposal.ReInit reinit, MLSMessage message) {
            super(group, reinit);
            this.message = message;
        }
    }
}

