/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.mls.crypto.MlsSigner;

public class BcMlsSigner
implements MlsSigner {
    Signer signer;
    ECNamedDomainParameters domainParams;
    int sigID;

    public BcMlsSigner(int sigID) {
        this.sigID = sigID;
        switch (sigID) {
            case 3: {
                this.signer = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new SHA256Digest());
                this.domainParams = ECNamedDomainParameters.lookup((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1);
                break;
            }
            case 4: {
                this.signer = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new SHA512Digest());
                this.domainParams = ECNamedDomainParameters.lookup((ASN1ObjectIdentifier)SECObjectIdentifiers.secp521r1);
                break;
            }
            case 5: {
                this.signer = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new SHA384Digest());
                this.domainParams = ECNamedDomainParameters.lookup((ASN1ObjectIdentifier)SECObjectIdentifiers.secp384r1);
                break;
            }
            case 7: {
                this.signer = new Ed25519Signer();
                break;
            }
            case 8: {
                this.signer = new Ed448Signer(new byte[0]);
            }
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateSignatureKeyPair() {
        SecureRandom random = new SecureRandom();
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                ECKeyPairGenerator pGen = new ECKeyPairGenerator();
                pGen.init((KeyGenerationParameters)new ECKeyGenerationParameters((ECDomainParameters)this.domainParams, random));
                return pGen.generateKeyPair();
            }
            case 7: {
                Ed25519KeyPairGenerator kpg25519 = new Ed25519KeyPairGenerator();
                kpg25519.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(random));
                return kpg25519.generateKeyPair();
            }
            case 8: {
                Ed448KeyPairGenerator kpg448 = new Ed448KeyPairGenerator();
                kpg448.init((KeyGenerationParameters)new Ed448KeyGenerationParameters(random));
                return kpg448.generateKeyPair();
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public byte[] serializePublicKey(AsymmetricKeyParameter key) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                return ((ECPublicKeyParameters)key).getQ().getEncoded(false);
            }
            case 7: {
                return ((Ed25519PublicKeyParameters)key).getEncoded();
            }
            case 8: {
                return ((Ed448PublicKeyParameters)key).getEncoded();
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public byte[] serializePrivateKey(AsymmetricKeyParameter key) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                return ((ECPrivateKeyParameters)key).getD().toByteArray();
            }
            case 7: {
                return ((Ed25519PrivateKeyParameters)key).getEncoded();
            }
            case 8: {
                return ((Ed448PrivateKeyParameters)key).getEncoded();
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public AsymmetricKeyParameter deserializePublicKey(byte[] pub) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                ECPoint G = this.domainParams.getCurve().decodePoint(pub);
                return new ECPublicKeyParameters(G, (ECDomainParameters)this.domainParams);
            }
            case 7: {
                return new X25519PublicKeyParameters(pub);
            }
            case 8: {
                return new X448PublicKeyParameters(pub);
            }
        }
        throw new IllegalStateException("Unknown mode");
    }

    @Override
    public AsymmetricCipherKeyPair deserializePrivateKey(byte[] priv) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                BigInteger d = new BigInteger(1, priv);
                ECPrivateKeyParameters ec = new ECPrivateKeyParameters(d, (ECDomainParameters)this.domainParams);
                ECPoint Q = new FixedPointCombMultiplier().multiply(this.domainParams.getG(), ec.getD());
                return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)new ECPublicKeyParameters(Q, (ECDomainParameters)this.domainParams), (AsymmetricKeyParameter)ec);
            }
            case 7: {
                Ed25519PrivateKeyParameters ed25519 = new Ed25519PrivateKeyParameters(priv);
                return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)ed25519.generatePublicKey(), (AsymmetricKeyParameter)ed25519);
            }
            case 8: {
                Ed448PrivateKeyParameters ed448 = new Ed448PrivateKeyParameters(priv);
                return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)ed448.generatePublicKey(), (AsymmetricKeyParameter)ed448);
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public byte[] signWithLabel(byte[] priv, String label, byte[] content) throws IOException, CryptoException {
        MlsCipherSuite.GenericContent signContent = new MlsCipherSuite.GenericContent(label, content);
        byte[] signContentBytes = MLSOutputStream.encode(signContent);
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                BigInteger d = new BigInteger(1, priv);
                this.signer.init(true, (CipherParameters)new ECPrivateKeyParameters(d, (ECDomainParameters)this.domainParams));
                break;
            }
            case 7: {
                this.signer.init(true, (CipherParameters)new Ed25519PrivateKeyParameters(priv));
                break;
            }
            case 8: {
                this.signer.init(true, (CipherParameters)new Ed448PrivateKeyParameters(priv));
            }
        }
        this.signer.update(signContentBytes, 0, signContentBytes.length);
        return this.signer.generateSignature();
    }

    @Override
    public boolean verifyWithLabel(byte[] pub, String label, byte[] content, byte[] signature) throws IOException {
        MlsCipherSuite.GenericContent signContent = new MlsCipherSuite.GenericContent(label, content);
        byte[] signContentBytes = MLSOutputStream.encode(signContent);
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                ECPoint G = this.domainParams.getCurve().decodePoint(pub);
                this.signer.init(false, (CipherParameters)new ECPublicKeyParameters(G, (ECDomainParameters)this.domainParams));
                break;
            }
            case 7: {
                this.signer.init(false, (CipherParameters)new Ed25519PublicKeyParameters(pub));
                break;
            }
            case 8: {
                this.signer.init(false, (CipherParameters)new Ed448PublicKeyParameters(pub));
            }
        }
        this.signer.update(signContentBytes, 0, signContentBytes.length);
        return this.signer.verifySignature(signature);
    }
}

