/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.TreeKEM.LeafNode;
import org.bouncycastle.mls.TreeKEM.TreeKEMPublicKey;
import org.bouncycastle.mls.codec.Extension;
import org.bouncycastle.mls.codec.GroupContext;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class GroupInfo
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    GroupContext groupContext;
    List<Extension> extensions;
    byte[] confirmationTag;
    LeafIndex signer;
    byte[] signature;

    public byte[] getConfirmationTag() {
        return this.confirmationTag;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public LeafIndex getSigner() {
        return this.signer;
    }

    public GroupContext getGroupContext() {
        return this.groupContext;
    }

    public byte[] getGroupID() {
        return this.groupContext.groupID;
    }

    public long getEpoch() {
        return this.groupContext.epoch;
    }

    public MlsCipherSuite getSuite() {
        return this.groupContext.suite;
    }

    public GroupInfo(GroupContext groupContext, List<Extension> extensions, byte[] confirmationTag) {
        this.groupContext = groupContext;
        this.extensions = new ArrayList<Extension>(extensions);
        this.confirmationTag = confirmationTag;
    }

    private byte[] toBeSigned() throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        stream.write(this.groupContext);
        stream.writeList(this.extensions);
        stream.writeOpaque(this.confirmationTag);
        stream.write(this.signer);
        return stream.toByteArray();
    }

    public boolean verify(MlsCipherSuite suite, TreeKEMPublicKey tree) throws Exception {
        LeafNode leaf = tree.getLeafNode(this.signer);
        if (leaf == null) {
            throw new Exception("Signer not found");
        }
        return this.verify(suite, leaf.getSignatureKey());
    }

    public boolean verify(MlsCipherSuite suite, byte[] pub) throws IOException {
        return suite.verifyWithLabel(pub, "GroupInfoTBS", this.toBeSigned(), this.signature);
    }

    GroupInfo(MLSInputStream stream) throws IOException {
        this.groupContext = (GroupContext)stream.read(GroupContext.class);
        this.extensions = new ArrayList<Extension>();
        stream.readList(this.extensions, Extension.class);
        this.confirmationTag = stream.readOpaque();
        this.signer = new LeafIndex((Integer)stream.read(Integer.TYPE));
        this.signature = stream.readOpaque();
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.groupContext);
        stream.writeList(this.extensions);
        stream.writeOpaque(this.confirmationTag);
        stream.write(this.signer);
        stream.writeOpaque(this.signature);
    }

    public void sign(TreeKEMPublicKey tree, LeafIndex signerIndex, AsymmetricCipherKeyPair sk) throws Exception {
        LeafNode leaf = tree.getLeafNode(signerIndex);
        if (leaf == null) {
            throw new Exception("Cannot sign from a blank leaf");
        }
        if (!Arrays.equals(tree.getSuite().serializeSignaturePublicKey(sk.getPublic()), leaf.getSignatureKey())) {
            throw new Exception("Bad key for index");
        }
        this.signer = signerIndex;
        this.signature = tree.getSuite().signWithLabel(tree.getSuite().serializeSignaturePrivateKey(sk.getPrivate()), "GroupInfoTBS", this.toBeSigned());
    }
}

