/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.FramedContent;
import org.bouncycastle.mls.codec.GroupContext;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.ProtocolVersion;
import org.bouncycastle.mls.codec.WireFormat;

class FramedContentTBS
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    ProtocolVersion version = ProtocolVersion.mls10;
    WireFormat wireFormat;
    FramedContent content;
    GroupContext context;

    public FramedContentTBS(WireFormat wireFormat, FramedContent content, GroupContext context) {
        this.wireFormat = wireFormat;
        this.content = content;
        switch (content.sender.senderType) {
            case MEMBER: 
            case NEW_MEMBER_COMMIT: {
                this.context = context;
            }
        }
    }

    public FramedContentTBS(WireFormat wireFormat, FramedContent content, byte[] context) throws IOException {
        this.wireFormat = wireFormat;
        this.content = content;
        switch (content.sender.senderType) {
            case MEMBER: 
            case NEW_MEMBER_COMMIT: {
                this.context = (GroupContext)MLSInputStream.decode(context, GroupContext.class);
                break;
            }
        }
    }

    public FramedContentTBS(MLSInputStream stream) throws IOException {
        this.version = ProtocolVersion.values()[(Short)stream.read(Short.TYPE)];
        this.wireFormat = WireFormat.values()[(Short)stream.read(Short.TYPE)];
        this.content = (FramedContent)stream.read(FramedContent.class);
        switch (this.content.sender.senderType) {
            case MEMBER: 
            case NEW_MEMBER_COMMIT: {
                this.context = (GroupContext)stream.read(GroupContext.class);
                break;
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.version);
        stream.write(this.wireFormat);
        stream.write(this.content);
        switch (this.content.sender.senderType) {
            case MEMBER: 
            case NEW_MEMBER_COMMIT: {
                stream.write(this.context);
                break;
            }
        }
    }
}

