/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.mls.TreeKEM.TreeKEMPublicKey;
import org.bouncycastle.mls.codec.ExtensionType;
import org.bouncycastle.mls.codec.ExternalSender;
import org.bouncycastle.mls.codec.Grease;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

public class Extension
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    public ExtensionType extensionType;
    public byte[] extension_data;

    public Extension(ExtensionType extensionType, byte[] extension_data) {
        this.extensionType = extensionType;
        this.extension_data = extension_data;
    }

    public Extension(int extensionType, byte[] extension_data) {
        short extType = (short)extensionType;
        this.extensionType = Grease.isGrease(extType) == -1 ? ExtensionType.values()[extType] : ExtensionType.values()[6 + Grease.isGrease(extType)];
        this.extension_data = extension_data;
    }

    public static Extension externalSender(List<ExternalSender> list) throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        stream.writeList(list);
        return new Extension(ExtensionType.EXTERNAL_SENDERS, stream.toByteArray());
    }

    public byte[] getExternalPub() throws IOException {
        if (this.extensionType == ExtensionType.EXTERNAL_PUB) {
            MLSInputStream stream = new MLSInputStream(this.extension_data);
            byte[] output = stream.readOpaque();
            return output;
        }
        return null;
    }

    Extension(MLSInputStream stream) throws IOException {
        short extType = (Short)stream.read(Short.TYPE);
        this.extensionType = Grease.isGrease(extType) == -1 ? ExtensionType.values()[extType] : ExtensionType.values()[6 + Grease.isGrease(extType)];
        this.extension_data = stream.readOpaque();
    }

    public List<ExternalSender> getSenders() throws IOException {
        if (this.extensionType == ExtensionType.EXTERNAL_SENDERS) {
            ArrayList<ExternalSender> senders = new ArrayList<ExternalSender>();
            MLSInputStream stream = new MLSInputStream(this.extension_data);
            stream.readList(senders, ExternalSender.class);
            return senders;
        }
        return null;
    }

    public TreeKEMPublicKey getRatchetTree() throws IOException {
        if (this.extensionType == ExtensionType.RATCHET_TREE) {
            return (TreeKEMPublicKey)MLSInputStream.decode(this.extension_data, TreeKEMPublicKey.class);
        }
        return null;
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.extensionType);
        stream.writeOpaque(this.extension_data);
    }
}

