/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.mls.codec.CredentialType;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.ProtocolVersion;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class Capabilities
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    private static final Short[] DEFAULT_SUPPORTED_VERSIONS = new Short[]{ProtocolVersion.mls10.value};
    private static final short[] DEFAULT_SUPPORTED_CIPHERSUITES = MlsCipherSuite.ALL_SUPPORTED_SUITES;
    private static final Short[] DEFAULT_SUPPORTED_CREDENTIALS = new Short[]{CredentialType.basic.value, CredentialType.x509.value};
    List<Short> versions;
    List<Short> cipherSuites;
    List<Short> extensions;
    List<Short> proposals;
    List<Short> credentials;

    public List<Short> getExtensions() {
        return this.extensions;
    }

    public Capabilities() {
        this.versions = Arrays.asList(DEFAULT_SUPPORTED_VERSIONS);
        this.cipherSuites = new ArrayList<Short>();
        for (short suite : DEFAULT_SUPPORTED_CIPHERSUITES) {
            this.cipherSuites.add(suite);
        }
        this.extensions = new ArrayList<Short>();
        this.proposals = new ArrayList<Short>();
        this.credentials = Arrays.asList(DEFAULT_SUPPORTED_CREDENTIALS);
    }

    Capabilities(MLSInputStream stream) throws IOException {
        this.versions = new ArrayList<Short>();
        this.cipherSuites = new ArrayList<Short>();
        this.extensions = new ArrayList<Short>();
        this.proposals = new ArrayList<Short>();
        this.credentials = new ArrayList<Short>();
        stream.readList(this.versions, Short.TYPE);
        stream.readList(this.cipherSuites, Short.TYPE);
        stream.readList(this.extensions, Short.TYPE);
        stream.readList(this.proposals, Short.TYPE);
        stream.readList(this.credentials, Short.TYPE);
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.writeList(this.versions);
        stream.writeList(this.cipherSuites);
        stream.writeList(this.extensions);
        stream.writeList(this.proposals);
        stream.writeList(this.credentials);
    }
}

