/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.TreeKEM;

import java.io.IOException;
import org.bouncycastle.mls.TreeKEM.LeafNode;
import org.bouncycastle.mls.TreeKEM.ParentNode;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.NodeType;

public class Node
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    NodeType nodeType;
    LeafNode leafNode;
    ParentNode parentNode;

    public byte[] getParentHash() {
        switch (this.nodeType) {
            case leaf: {
                return this.leafNode.parent_hash;
            }
            case parent: {
                return this.parentNode.parentHash;
            }
        }
        return null;
    }

    public byte[] getPublicKey() {
        switch (this.nodeType) {
            case leaf: {
                return this.leafNode.encryption_key;
            }
            case parent: {
                return this.parentNode.encryptionKey;
            }
        }
        return null;
    }

    public Node(LeafNode leafNode) {
        this.nodeType = NodeType.leaf;
        this.leafNode = leafNode;
    }

    public Node(ParentNode parentNode) {
        this.nodeType = NodeType.parent;
        this.parentNode = parentNode;
    }

    public Node(MLSInputStream stream) throws IOException {
        this.nodeType = NodeType.values()[(Byte)stream.read(Byte.TYPE)];
        switch (this.nodeType) {
            case leaf: {
                this.leafNode = (LeafNode)stream.read(LeafNode.class);
                break;
            }
            case parent: {
                this.parentNode = (ParentNode)stream.read(ParentNode.class);
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.nodeType);
        switch (this.nodeType) {
            case leaf: {
                stream.write(this.leafNode);
                break;
            }
            case parent: {
                stream.write(this.parentNode);
            }
        }
    }
}

