/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.mls.KeyGeneration;
import org.bouncycastle.mls.KeyScheduleEpoch;
import org.bouncycastle.mls.codec.EncryptedGroupSecrets;
import org.bouncycastle.mls.codec.GroupInfo;
import org.bouncycastle.mls.codec.GroupSecrets;
import org.bouncycastle.mls.codec.HPKECiphertext;
import org.bouncycastle.mls.codec.KeyPackage;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.PathSecret;
import org.bouncycastle.mls.codec.PreSharedKeyID;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.mls.crypto.Secret;

public class Welcome
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    short cipher_suite;
    MlsCipherSuite suite;
    List<EncryptedGroupSecrets> secrets;
    byte[] encrypted_group_info;
    private Secret joinerSecret;
    private List<PreSharedKeyID> psks;

    public MlsCipherSuite getSuite() {
        return this.suite;
    }

    public Welcome(MlsCipherSuite suite, byte[] joinerSecret, List<KeyScheduleEpoch.PSKWithSecret> psks, byte[] groupInfo) throws IOException, InvalidCipherTextException {
        this.cipher_suite = suite.getSuiteID();
        this.suite = suite;
        this.joinerSecret = new Secret(joinerSecret);
        this.psks = new ArrayList<PreSharedKeyID>();
        for (KeyScheduleEpoch.PSKWithSecret psk : psks) {
            this.psks.add(psk.id);
        }
        KeyGeneration keyGen = this.getGroupInfoKeyNonce(joinerSecret, psks);
        this.encrypted_group_info = suite.getAEAD().seal(keyGen.key, keyGen.nonce, new byte[0], groupInfo);
        this.secrets = new ArrayList<EncryptedGroupSecrets>();
    }

    public int find(KeyPackage kp) throws IOException {
        byte[] ref = this.suite.refHash(MLSOutputStream.encode(kp), "MLS 1.0 KeyPackage Reference");
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!Arrays.equals(ref, this.secrets.get((int)i).new_member)) continue;
            return i;
        }
        return -1;
    }

    public void encrypt(KeyPackage kp, Secret pathSecret) throws IOException, InvalidCipherTextException {
        GroupSecrets gs = new GroupSecrets(this.joinerSecret.value(), null, this.psks);
        if (pathSecret != null) {
            gs.path_secret = new PathSecret(pathSecret.value());
        }
        byte[] gsBytes = MLSOutputStream.encode(gs);
        MlsCipherSuite suite = kp.suite;
        byte[][] ctAndEnc = suite.encryptWithLabel(kp.init_key, "Welcome", this.encrypted_group_info, gsBytes);
        this.secrets.add(new EncryptedGroupSecrets(suite.refHash(MLSOutputStream.encode(kp), "MLS 1.0 KeyPackage Reference"), new HPKECiphertext(ctAndEnc[1], ctAndEnc[0])));
    }

    public GroupInfo decrypt(byte[] joinerSecret, List<KeyScheduleEpoch.PSKWithSecret> psks) throws IOException, InvalidCipherTextException {
        KeyGeneration keyAndNonce = this.getGroupInfoKeyNonce(joinerSecret, psks);
        byte[] groupInfoData = this.suite.getAEAD().open(keyAndNonce.key, keyAndNonce.nonce, new byte[0], this.encrypted_group_info);
        return (GroupInfo)MLSInputStream.decode(groupInfoData, GroupInfo.class);
    }

    private KeyGeneration getGroupInfoKeyNonce(byte[] joinerSecret, List<KeyScheduleEpoch.PSKWithSecret> psks) throws IOException {
        Secret welcomeSecret = KeyScheduleEpoch.welcomeSecret(this.suite, joinerSecret, psks);
        Secret key = welcomeSecret.expandWithLabel(this.suite, "key", new byte[0], this.suite.getAEAD().getKeySize());
        Secret nonce = welcomeSecret.expandWithLabel(this.suite, "nonce", new byte[0], this.suite.getAEAD().getNonceSize());
        return new KeyGeneration(-1, key, nonce);
    }

    public GroupSecrets decryptSecrets(int kpIndex, byte[] initPrivKey) throws InvalidCipherTextException, IOException {
        HPKECiphertext ct = this.secrets.get((int)kpIndex).encrypted_group_secrets;
        byte[] secretsData = this.suite.decryptWithLabel(initPrivKey, "Welcome", this.encrypted_group_info, ct.kem_output, ct.ciphertext);
        return (GroupSecrets)MLSInputStream.decode(secretsData, GroupSecrets.class);
    }

    Welcome(MLSInputStream stream) throws Exception {
        this.cipher_suite = (Short)stream.read(Short.TYPE);
        this.suite = MlsCipherSuite.getSuite(this.cipher_suite);
        this.secrets = new ArrayList<EncryptedGroupSecrets>();
        stream.readList(this.secrets, EncryptedGroupSecrets.class);
        this.encrypted_group_info = stream.readOpaque();
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.cipher_suite);
        stream.writeList(this.secrets);
        stream.writeOpaque(this.encrypted_group_info);
    }
}

