/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.TreeKEM.LeafNode;
import org.bouncycastle.mls.codec.Extension;
import org.bouncycastle.mls.codec.Grease;
import org.bouncycastle.mls.codec.KeyPackage;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.PreSharedKeyID;
import org.bouncycastle.mls.codec.ProposalType;
import org.bouncycastle.mls.codec.ProtocolVersion;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class Proposal
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    ProposalType proposalType;
    Add add;
    Update update;
    Remove remove;
    PreSharedKey preSharedKey;
    ReInit reInit;
    ExternalInit externalInit;
    GroupContextExtensions groupContextExtensions;

    public Add getAdd() {
        return this.add;
    }

    public Update getUpdate() {
        return this.update;
    }

    public Remove getRemove() {
        return this.remove;
    }

    public PreSharedKey getPreSharedKey() {
        return this.preSharedKey;
    }

    public ReInit getReInit() {
        return this.reInit;
    }

    public ExternalInit getExternalInit() {
        return this.externalInit;
    }

    public GroupContextExtensions getGroupContextExtensions() {
        return this.groupContextExtensions;
    }

    public LeafNode getLeafNode() {
        switch (this.proposalType) {
            case ADD: {
                return this.add.keyPackage.leaf_node;
            }
            case UPDATE: {
                return this.update.leafNode;
            }
        }
        return null;
    }

    public ProposalType getProposalType() {
        return this.proposalType;
    }

    public Proposal(ProposalType proposalType, Add add, Update update, Remove remove, PreSharedKey preSharedKey, ReInit reInit, ExternalInit externalInit, GroupContextExtensions groupContextExtensions) {
        this.proposalType = proposalType;
        this.add = add;
        this.update = update;
        this.remove = remove;
        this.preSharedKey = preSharedKey;
        this.reInit = reInit;
        this.externalInit = externalInit;
        this.groupContextExtensions = groupContextExtensions;
    }

    public Proposal(MLSInputStream stream) throws IOException {
        short propType = (Short)stream.read(Short.TYPE);
        this.proposalType = Grease.isGrease(propType) == -1 ? ProposalType.values()[propType] : ProposalType.values()[8 + Grease.isGrease(propType)];
        switch (this.proposalType) {
            case ADD: {
                this.add = (Add)stream.read(Add.class);
                break;
            }
            case UPDATE: {
                this.update = (Update)stream.read(Update.class);
                break;
            }
            case REMOVE: {
                this.remove = (Remove)stream.read(Remove.class);
                break;
            }
            case PSK: {
                this.preSharedKey = (PreSharedKey)stream.read(PreSharedKey.class);
                break;
            }
            case REINIT: {
                this.reInit = (ReInit)stream.read(ReInit.class);
                break;
            }
            case EXTERNAL_INIT: {
                this.externalInit = (ExternalInit)stream.read(ExternalInit.class);
                break;
            }
            case GROUP_CONTEXT_EXTENSIONS: {
                this.groupContextExtensions = (GroupContextExtensions)stream.read(GroupContextExtensions.class);
            }
        }
    }

    public static Proposal add(KeyPackage newMember) throws IOException {
        return new Proposal(ProposalType.ADD, new Add(newMember), null, null, null, null, null, null);
    }

    public static Proposal update(LeafNode leafNode) {
        return new Proposal(ProposalType.UPDATE, null, new Update(leafNode), null, null, null, null, null);
    }

    public static Proposal remove(LeafIndex removed) {
        return new Proposal(ProposalType.REMOVE, null, null, new Remove(removed), null, null, null, null);
    }

    public static Proposal preSharedKey(PreSharedKeyID pskID) {
        return new Proposal(ProposalType.PSK, null, null, null, new PreSharedKey(pskID), null, null, null);
    }

    public static Proposal reInit(byte[] group_id, ProtocolVersion version, MlsCipherSuite cipherSuite, List<Extension> extensions) {
        return new Proposal(ProposalType.REINIT, null, null, null, null, new ReInit(group_id, version, cipherSuite, extensions), null, null);
    }

    public static Proposal externalInit(byte[] kemOutput) {
        return new Proposal(ProposalType.EXTERNAL_INIT, null, null, null, null, null, new ExternalInit(kemOutput), null);
    }

    public static Proposal groupContextExtensions(List<Extension> extensions) {
        return new Proposal(ProposalType.GROUP_CONTEXT_EXTENSIONS, null, null, null, null, null, null, new GroupContextExtensions(extensions));
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.proposalType);
        switch (this.proposalType) {
            case ADD: {
                stream.write(this.add);
                break;
            }
            case UPDATE: {
                stream.write(this.update);
                break;
            }
            case REMOVE: {
                stream.write(this.remove);
                break;
            }
            case PSK: {
                stream.write(this.preSharedKey);
                break;
            }
            case REINIT: {
                stream.write(this.reInit);
                break;
            }
            case EXTERNAL_INIT: {
                stream.write(this.externalInit);
                break;
            }
            case GROUP_CONTEXT_EXTENSIONS: {
                stream.write(this.groupContextExtensions);
            }
        }
    }

    public static class Add
    implements MLSInputStream.Readable,
    MLSOutputStream.Writable {
        public KeyPackage keyPackage;

        public Add(KeyPackage keyPackage) throws IOException {
            this.keyPackage = (KeyPackage)MLSInputStream.decode(MLSOutputStream.encode(keyPackage), KeyPackage.class);
        }

        Add(MLSInputStream stream) throws IOException {
            this.keyPackage = (KeyPackage)stream.read(KeyPackage.class);
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.write(this.keyPackage);
        }
    }

    public static class ExternalInit
    implements MLSInputStream.Readable,
    MLSOutputStream.Writable {
        public byte[] kemOutput;

        ExternalInit(MLSInputStream stream) throws IOException {
            this.kemOutput = stream.readOpaque();
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.writeOpaque(this.kemOutput);
        }

        public ExternalInit(byte[] kemOutput) {
            this.kemOutput = (byte[])kemOutput.clone();
        }
    }

    public static class GroupContextExtensions
    implements MLSInputStream.Readable,
    MLSOutputStream.Writable {
        public List<Extension> extensions = new ArrayList<Extension>();

        public GroupContextExtensions(List<Extension> extensions) {
            this.extensions.addAll(extensions);
        }

        GroupContextExtensions(MLSInputStream stream) throws IOException {
            stream.readList(this.extensions, Extension.class);
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.writeList(this.extensions);
        }
    }

    public static class PreSharedKey
    implements MLSInputStream.Readable,
    MLSOutputStream.Writable {
        public PreSharedKeyID psk;

        PreSharedKey(MLSInputStream stream) throws IOException {
            this.psk = (PreSharedKeyID)stream.read(PreSharedKeyID.class);
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.write(this.psk);
        }

        public PreSharedKey(PreSharedKeyID psk) {
            this.psk = psk;
        }
    }

    public static class ReInit
    implements MLSInputStream.Readable,
    MLSOutputStream.Writable {
        byte[] group_id;
        ProtocolVersion version;
        short cipherSuite;
        MlsCipherSuite suite;
        List<Extension> extensions;

        public ProtocolVersion getVersion() {
            return this.version;
        }

        public byte[] getGroupID() {
            return this.group_id;
        }

        public MlsCipherSuite getSuite() {
            return this.suite;
        }

        public List<Extension> getExtensions() {
            return this.extensions;
        }

        public ReInit(byte[] group_id, ProtocolVersion version, MlsCipherSuite cipherSuite, List<Extension> extensions) {
            this.group_id = group_id;
            this.version = version;
            this.suite = cipherSuite;
            this.cipherSuite = this.suite.getSuiteID();
            this.extensions = extensions;
        }

        ReInit(MLSInputStream stream) throws Exception {
            this.group_id = stream.readOpaque();
            this.version = ProtocolVersion.values()[(Short)stream.read(Short.TYPE)];
            this.cipherSuite = (Short)stream.read(Short.TYPE);
            this.suite = MlsCipherSuite.getSuite(this.cipherSuite);
            this.extensions = new ArrayList<Extension>();
            stream.readList(this.extensions, Extension.class);
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.writeOpaque(this.group_id);
            stream.write(this.version);
            stream.write(this.cipherSuite);
            stream.writeList(this.extensions);
        }
    }

    public static class Remove
    implements MLSInputStream.Readable,
    MLSOutputStream.Writable {
        public LeafIndex removed;

        public Remove(LeafIndex removed) {
            this.removed = removed;
        }

        public Remove(MLSInputStream stream) throws IOException {
            this.removed = (LeafIndex)stream.read(LeafIndex.class);
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.write(this.removed);
        }
    }

    public static class Update
    implements MLSInputStream.Readable,
    MLSOutputStream.Writable {
        LeafNode leafNode;

        public Update(MLSInputStream stream) throws IOException {
            this.leafNode = (LeafNode)stream.read(LeafNode.class);
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.write(this.leafNode);
        }

        public Update(LeafNode leafNode) {
            this.leafNode = leafNode;
        }

        public LeafNode getLeafNode() {
            return this.leafNode;
        }
    }
}

