/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.mls.GroupKeySet;
import org.bouncycastle.mls.KeyGeneration;
import org.bouncycastle.mls.KeyScheduleEpoch;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.codec.AuthenticatedContent;
import org.bouncycastle.mls.codec.Commit;
import org.bouncycastle.mls.codec.ContentType;
import org.bouncycastle.mls.codec.FramedContent;
import org.bouncycastle.mls.codec.FramedContentAuthData;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.PrivateContentAAD;
import org.bouncycastle.mls.codec.Proposal;
import org.bouncycastle.mls.codec.Sender;
import org.bouncycastle.mls.codec.SenderData;
import org.bouncycastle.mls.codec.SenderDataAAD;
import org.bouncycastle.mls.codec.WireFormat;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.util.Arrays;

public class PrivateMessage
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    byte[] group_id;
    long epoch;
    ContentType content_type;
    byte[] authenticated_data;
    byte[] encrypted_sender_data;
    byte[] ciphertext;

    public PrivateMessage(byte[] group_id, long epoch, ContentType content_type, byte[] authenticated_data, byte[] encrypted_sender_data, byte[] ciphertext) {
        this.group_id = group_id;
        this.epoch = epoch;
        this.content_type = content_type;
        this.authenticated_data = authenticated_data;
        this.encrypted_sender_data = encrypted_sender_data;
        this.ciphertext = ciphertext;
    }

    PrivateMessage(MLSInputStream stream) throws IOException {
        this.group_id = stream.readOpaque();
        this.epoch = (Long)stream.read(Long.TYPE);
        this.content_type = ContentType.values()[(Byte)stream.read(Byte.TYPE)];
        this.authenticated_data = stream.readOpaque();
        this.encrypted_sender_data = stream.readOpaque();
        this.ciphertext = stream.readOpaque();
    }

    public static PrivateMessage protect(AuthenticatedContent auth, MlsCipherSuite suite, GroupKeySet keys, byte[] senderDataSecretBytes, int paddingSize) throws IOException, IllegalAccessException, InvalidCipherTextException {
        LeafIndex index = auth.content.sender.sender;
        ContentType contentType = auth.content.contentType;
        byte[] reuseGuard = new byte[4];
        KeyGeneration keyGen = keys.get(contentType, index, reuseGuard);
        byte[] contentPt = PrivateMessage.serializeContentPt(auth.content, auth.auth, paddingSize);
        PrivateContentAAD contentAAD = new PrivateContentAAD(auth.content.group_id, auth.content.epoch, auth.content.contentType, auth.content.authenticated_data);
        byte[] contentCt = suite.getAEAD().seal(keyGen.key, keyGen.nonce, MLSOutputStream.encode(contentAAD), contentPt);
        LeafIndex senderIndex = auth.content.sender.sender;
        SenderData senderDataPt = new SenderData(senderIndex, keyGen.generation, reuseGuard);
        SenderDataAAD senderDataAAD = new SenderDataAAD(auth.content.group_id, auth.content.epoch, auth.content.contentType);
        KeyGeneration senderDataKeys = KeyScheduleEpoch.senderDataKeys(suite, (byte[])senderDataSecretBytes.clone(), contentCt);
        byte[] senderDataCt = suite.getAEAD().seal(senderDataKeys.key, senderDataKeys.nonce, MLSOutputStream.encode(senderDataAAD), MLSOutputStream.encode(senderDataPt));
        return new PrivateMessage(auth.content.group_id, auth.content.epoch, auth.content.contentType, auth.content.authenticated_data, (byte[])senderDataCt.clone(), (byte[])contentCt.clone());
    }

    public AuthenticatedContent unprotect(MlsCipherSuite suite, GroupKeySet keys, byte[] senderDataSecretBytes) throws Exception {
        KeyGeneration senderKeys = KeyScheduleEpoch.senderDataKeys(suite, (byte[])senderDataSecretBytes.clone(), (byte[])this.ciphertext.clone());
        SenderDataAAD senderDataAAD = new SenderDataAAD(this.group_id, this.epoch, this.content_type);
        byte[] senderDataPt = suite.getAEAD().open(senderKeys.key, senderKeys.nonce, MLSOutputStream.encode(senderDataAAD), this.encrypted_sender_data);
        SenderData senderData = (SenderData)MLSInputStream.decode(senderDataPt, SenderData.class);
        if (!keys.hasLeaf(senderData.sender)) {
            return null;
        }
        KeyGeneration contentKeys = keys.get(this.content_type, senderData.sender, senderData.generation, senderData.reuseGuard);
        PrivateContentAAD contentAAD = new PrivateContentAAD(this.group_id, this.epoch, this.content_type, this.authenticated_data);
        byte[] contentPtBytes = suite.getAEAD().open(contentKeys.key, contentKeys.nonce, MLSOutputStream.encode(contentAAD), this.ciphertext);
        keys.erase(this.content_type, senderData.sender, senderData.generation);
        FramedContent content = new FramedContent(this.group_id, this.epoch, Sender.forMember(senderData.sender), this.authenticated_data, null, this.content_type, null, null);
        FramedContentAuthData auth = new FramedContentAuthData(this.content_type, null, null);
        this.deserializeContentPt(contentPtBytes, content, auth);
        return new AuthenticatedContent(WireFormat.mls_private_message, content, auth);
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.writeOpaque(this.group_id);
        stream.write(this.epoch);
        stream.write(this.content_type);
        stream.writeOpaque(this.authenticated_data);
        stream.writeOpaque(this.encrypted_sender_data);
        stream.writeOpaque(this.ciphertext);
    }

    private void deserializeContentPt(byte[] contentPt, FramedContent content, FramedContentAuthData auth) throws IOException {
        MLSInputStream stream = new MLSInputStream(contentPt);
        switch (this.content_type) {
            case APPLICATION: {
                content.application_data = stream.readOpaque();
                break;
            }
            case PROPOSAL: {
                content.proposal = (Proposal)stream.read(Proposal.class);
                break;
            }
            case COMMIT: {
                content.commit = (Commit)stream.read(Commit.class);
            }
        }
        auth.signature = stream.readOpaque();
        switch (this.content_type) {
            case APPLICATION: 
            case PROPOSAL: {
                break;
            }
            case COMMIT: {
                auth.confirmation_tag = stream.readOpaque();
            }
        }
    }

    private static byte[] serializeContentPt(FramedContent content, FramedContentAuthData auth, int paddingSize) throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        switch (content.contentType) {
            case APPLICATION: {
                stream.writeOpaque(content.application_data);
                break;
            }
            case PROPOSAL: {
                stream.write(content.proposal);
                break;
            }
            case COMMIT: {
                stream.write(content.commit);
            }
        }
        stream.writeOpaque(auth.signature);
        switch (content.contentType) {
            case APPLICATION: 
            case PROPOSAL: {
                break;
            }
            case COMMIT: {
                stream.writeOpaque(auth.confirmation_tag);
            }
        }
        return Arrays.concatenate((byte[])stream.toByteArray(), (byte[])new byte[paddingSize]);
    }
}

