/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.PSKType;
import org.bouncycastle.mls.codec.ResumptionPSKUsage;
import org.bouncycastle.mls.crypto.Secret;

public class PreSharedKeyID
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    public final PSKType pskType;
    public final External external;
    public final Resumption resumption;
    public final byte[] pskNonce;

    PreSharedKeyID(PSKType pskType, External external, Resumption resumption, byte[] pskNonce) {
        this.pskType = pskType;
        this.external = external;
        this.resumption = resumption;
        this.pskNonce = pskNonce;
    }

    public static PreSharedKeyID external(byte[] externalPSKID, byte[] pskNonce) {
        External external = new External(externalPSKID);
        return new PreSharedKeyID(PSKType.EXTERNAL, external, null, pskNonce);
    }

    public static PreSharedKeyID resumption(ResumptionPSKUsage resumptionPSKUsage, byte[] pskGroupID, long pskEpoch, byte[] pskNonce) {
        Resumption resumptionVal = new Resumption(resumptionPSKUsage, pskGroupID, pskEpoch);
        return new PreSharedKeyID(PSKType.RESUMPTION, null, resumptionVal, pskNonce);
    }

    public PreSharedKeyID(MLSInputStream stream) throws IOException {
        this.pskType = PSKType.values()[(Byte)stream.read(Byte.TYPE)];
        switch (this.pskType) {
            case EXTERNAL: {
                byte[] externalPSKID = stream.readOpaque();
                this.external = new External(externalPSKID);
                this.resumption = null;
                break;
            }
            case RESUMPTION: {
                ResumptionPSKUsage resumptionPSKUsage = ResumptionPSKUsage.values()[(Byte)stream.read(Byte.TYPE)];
                byte[] pskGroupID = stream.readOpaque();
                long pskEpoch = (Long)stream.read(Long.TYPE);
                this.external = null;
                this.resumption = new Resumption(resumptionPSKUsage, pskGroupID, pskEpoch);
                break;
            }
            default: {
                throw new IOException("Invalid PSKType");
            }
        }
        this.pskNonce = stream.readOpaque();
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.pskType);
        switch (this.pskType) {
            case EXTERNAL: {
                stream.writeOpaque(this.external.externalPSKID.value());
                break;
            }
            case RESUMPTION: {
                stream.write(this.resumption.resumptionPSKUsage);
                stream.writeOpaque(this.resumption.pskGroupID);
                stream.write(this.resumption.pskEpoch);
            }
        }
        stream.writeOpaque(this.pskNonce);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreSharedKeyID pskid = (PreSharedKeyID)o;
        if (pskid.pskType != this.pskType) {
            return false;
        }
        switch (this.pskType) {
            case EXTERNAL: {
                return Arrays.equals(pskid.external.externalPSKID.value(), this.external.externalPSKID.value());
            }
            case RESUMPTION: {
                return Arrays.equals(pskid.resumption.pskGroupID, this.resumption.pskGroupID) && pskid.resumption.pskEpoch == this.resumption.pskEpoch;
            }
        }
        return false;
    }

    public static class External {
        public final Secret externalPSKID;

        public External(byte[] externalPSKID) {
            this.externalPSKID = new Secret(externalPSKID);
        }
    }

    public static class Resumption {
        public final ResumptionPSKUsage resumptionPSKUsage;
        public final byte[] pskGroupID;
        public final long pskEpoch;

        public Resumption(ResumptionPSKUsage resumptionPSKUsage, byte[] pskGroupID, long pskEpoch) {
            this.resumptionPSKUsage = resumptionPSKUsage;
            this.pskGroupID = pskGroupID;
            this.pskEpoch = pskEpoch;
        }
    }
}

