/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.mls.codec.Varint;

public class MLSOutputStream {
    final ByteArrayOutputStream stream = new ByteArrayOutputStream();

    public static byte[] encode(Object val) throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        stream.write(val);
        return stream.toByteArray();
    }

    public void write(Object val) throws IOException {
        Class<?> valClass = val.getClass();
        if (valClass == Boolean.class) {
            this.writeBoolean((Boolean)val);
            return;
        }
        if (valClass == Byte.class) {
            this.writeInt(((Byte)val).byteValue(), 1);
            return;
        }
        if (valClass == Short.class) {
            this.writeInt(((Short)val).shortValue(), 2);
            return;
        }
        if (valClass == Integer.class) {
            this.writeInt(((Integer)val).intValue(), 4);
            return;
        }
        if (valClass == Long.class) {
            this.writeInt((Long)val, 8);
            return;
        }
        if (Writable.class.isAssignableFrom(valClass)) {
            ((Writable)val).writeTo(this);
            return;
        }
        throw new IllegalArgumentException("Target type cannot be encoded");
    }

    public byte[] toByteArray() {
        return this.stream.toByteArray();
    }

    void writeBoolean(boolean val) {
        this.writeInt(val ? 1L : 0L, 1);
    }

    private void writeInt(long val, int len) {
        for (int i = 0; i < len; ++i) {
            byte b = (byte)(val >> 8 * (len - i - 1));
            this.stream.write(b);
        }
    }

    public void writeOptional(Object val) throws IOException {
        this.writeBoolean(val != null);
        if (val != null) {
            this.write(val);
        }
    }

    public <T> void writeArray(T[] val) throws IOException {
        this.write(val.length);
        for (T x : val) {
            this.write(x);
        }
    }

    public void writeOpaque(byte[] val) throws IOException {
        this.write(new Varint(val.length));
        this.stream.write(val);
    }

    public <T> void writeList(Iterable<T> val) throws IOException {
        MLSOutputStream content = new MLSOutputStream();
        for (T x : val) {
            content.write(x);
        }
        this.write(new Varint(content.stream.size()));
        content.stream.writeTo(this.stream);
    }

    public static interface Writable {
        public void writeTo(MLSOutputStream var1) throws IOException;
    }
}

