/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls;

public class TreeSize {
    private final long leafCount;
    private final long depth;

    private TreeSize(long leafCount, long depth) {
        this.leafCount = leafCount;
        this.depth = depth;
    }

    public static TreeSize forLeaves(long leafCount) {
        assert (leafCount >= 0L);
        long depth = 64 - Long.numberOfLeadingZeros(leafCount - 1L);
        return new TreeSize(leafCount, depth);
    }

    public long depth() {
        return this.depth;
    }

    public long leafCount() {
        return this.leafCount;
    }

    public long width() {
        return (1L << (int)(this.depth + 1L)) - 1L;
    }
}

