/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.TreeKEM;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.bouncycastle.mls.TreeKEM.NodeIndex;
import org.bouncycastle.mls.TreeSize;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

public class LeafIndex
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    protected int value;

    public int value() {
        return this.value;
    }

    public LeafIndex(int valueIn) {
        this.value = valueIn;
    }

    public LeafIndex(NodeIndex valueIn) {
        this.value = (int)(valueIn.value() >>> 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafIndex leafIndex = (LeafIndex)o;
        return this.value == leafIndex.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public NodeIndex commonAncestor(LeafIndex other) {
        if (this.equals(other)) {
            return new NodeIndex(this);
        }
        long k = 0L;
        long xv = new NodeIndex(this).value();
        long yv = new NodeIndex(other).value();
        while (xv != yv) {
            xv >>= 1;
            yv >>= 1;
            ++k;
        }
        long prefix = xv << (int)k;
        long stop = 1L << (int)(k - 1L);
        return new NodeIndex(prefix + stop - 1L);
    }

    public List<NodeIndex> directPath(TreeSize size) {
        Vector<NodeIndex> d = new Vector<NodeIndex>();
        NodeIndex n = new NodeIndex(this);
        NodeIndex r = NodeIndex.root(size);
        if (n.equals(r)) {
            return d;
        }
        NodeIndex p = n.parent();
        while (!p.equals(r)) {
            d.add(p);
            p = p.parent();
        }
        if (!n.equals(r)) {
            d.add(p);
        }
        return d;
    }

    public LeafIndex(MLSInputStream stream) throws IOException {
        this.value = (Integer)stream.read(Integer.TYPE);
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.value);
    }
}

