/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class RecipientInformationStore {
    private Map table = new HashMap();

    public RecipientInformationStore(Collection collection) {
        for (RecipientInformation recipientInformation : collection) {
            RecipientId recipientId = recipientInformation.getRID();
            if (this.table.get(recipientId) == null) {
                this.table.put(recipientId, recipientInformation);
                continue;
            }
            Object v = this.table.get(recipientId);
            if (v instanceof List) {
                ((List)v).add(recipientInformation);
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(recipientInformation);
            this.table.put(recipientId, arrayList);
        }
    }

    public RecipientInformation get(RecipientId recipientId) {
        Object v = this.table.get(recipientId);
        if (v instanceof List) {
            return (RecipientInformation)((List)v).get(0);
        }
        return (RecipientInformation)v;
    }

    public int size() {
        Iterator iterator = this.table.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof List) {
                n += ((List)v).size();
                continue;
            }
            ++n;
        }
        return n;
    }

    public Collection getRecipients() {
        ArrayList arrayList = new ArrayList(this.table.size());
        for (Object v : this.table.values()) {
            if (v instanceof List) {
                arrayList.addAll((List)v);
                continue;
            }
            arrayList.add(v);
        }
        return arrayList;
    }

    public Collection getRecipients(RecipientId recipientId) {
        Object v = this.table.get(recipientId);
        if (v instanceof List) {
            return new ArrayList((List)v);
        }
        if (v != null) {
            return Collections.singletonList(v);
        }
        return new ArrayList();
    }
}

