/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.util.HashSet;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.mail.smime.SMIMEAuthEnveloped;
import org.bouncycastle.mail.smime.SMIMEAuthEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;

public class SMIMEEnvelopedUtil {
    private static Set authOIDs = new HashSet();

    public static RecipientInformationStore getRecipientInfos(MimeBodyPart mimeBodyPart) throws MessagingException, CMSException {
        if (mimeBodyPart.getContentType().equals("application/pkcs7-mime; name=\"smime.p7m\"; smime-type=authEnveloped-data")) {
            return new SMIMEAuthEnveloped(mimeBodyPart).getRecipientInfos();
        }
        return new SMIMEEnveloped(mimeBodyPart).getRecipientInfos();
    }

    public static SMIMEEnvelopedGenerator createGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (authOIDs.contains(aSN1ObjectIdentifier)) {
            return new SMIMEAuthEnvelopedGenerator();
        }
        return new SMIMEEnvelopedGenerator();
    }

    static {
        authOIDs.add(NISTObjectIdentifiers.id_aes128_GCM);
        authOIDs.add(NISTObjectIdentifiers.id_aes128_GCM);
        authOIDs.add(NISTObjectIdentifiers.id_aes128_GCM);
    }
}

