/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.its.ITSCertificate;
import org.bouncycastle.its.ITSCertificateBuilder;
import org.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import org.bouncycastle.oer.its.ieee1609dot2.CertificateId;
import org.bouncycastle.oer.its.ieee1609dot2.CertificateType;
import org.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import org.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import org.bouncycastle.oer.its.ieee1609dot2.VerificationKeyIndicator;
import org.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP256CurvePoint;
import org.bouncycastle.oer.its.ieee1609dot2.basetypes.HashedId8;
import org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Arrays;

public class ITSImplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final IssuerIdentifier issuerIdentifier;

    public ITSImplicitCertificateBuilder(ITSCertificate issuer, DigestCalculatorProvider digestCalculatorProvider, ToBeSignedCertificate.Builder tbsCertificate) {
        super(issuer, tbsCertificate);
        DigestCalculator calculator;
        AlgorithmIdentifier digestAlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        ASN1ObjectIdentifier digestAlg = digestAlgId.getAlgorithm();
        try {
            calculator = digestCalculatorProvider.get(digestAlgId);
        }
        catch (OperatorCreationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        try {
            OutputStream os = calculator.getOutputStream();
            os.write(issuer.getEncoded());
            os.close();
        }
        catch (IOException ioex) {
            throw new IllegalStateException(ioex.getMessage(), ioex);
        }
        byte[] parentDigest = calculator.getDigest();
        HashedId8 hashedID = new HashedId8(Arrays.copyOfRange(parentDigest, parentDigest.length - 8, parentDigest.length));
        if (digestAlg.equals(NISTObjectIdentifiers.id_sha256)) {
            this.issuerIdentifier = IssuerIdentifier.sha256AndDigest(hashedID);
        } else if (digestAlg.equals(NISTObjectIdentifiers.id_sha384)) {
            this.issuerIdentifier = IssuerIdentifier.sha384AndDigest(hashedID);
        } else {
            throw new IllegalStateException("unknown digest");
        }
    }

    public ITSCertificate build(CertificateId certificateId, BigInteger x, BigInteger y) {
        return this.build(certificateId, x, y, null);
    }

    public ITSCertificate build(CertificateId certificateId, BigInteger x, BigInteger y, PublicEncryptionKey publicEncryptionKey) {
        EccP256CurvePoint reconstructionValue = EccP256CurvePoint.uncompressedP256(x, y);
        ToBeSignedCertificate.Builder tbsBldr = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        tbsBldr.setId(certificateId);
        if (publicEncryptionKey != null) {
            tbsBldr.setEncryptionKey(publicEncryptionKey);
        }
        tbsBldr.setVerifyKeyIndicator(VerificationKeyIndicator.reconstructionValue(reconstructionValue));
        CertificateBase.Builder baseBldr = new CertificateBase.Builder();
        baseBldr.setVersion(this.version);
        baseBldr.setType(CertificateType.implicit);
        baseBldr.setIssuer(this.issuerIdentifier);
        baseBldr.setToBeSigned(tbsBldr.createToBeSignedCertificate());
        return new ITSCertificate(baseBldr.createCertificateBase());
    }
}

