/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.PacketCipherException;

public class PacketCipherChecks {
    protected static void checkBoundsInput(byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        if (input == null) {
            throw PacketCipherException.from(new IllegalArgumentException("input was null"));
        }
        if (output == null) {
            throw PacketCipherException.from(new IllegalArgumentException("output was null"));
        }
        if (inOff < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input offset is negative"));
        }
        if (outOff < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("output offset is negative"));
        }
        if (len < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (inOff > input.length - len) {
            throw PacketCipherException.from(new DataLengthException("input buffer too short for offset + length"));
        }
    }

    static void checkBoundsInputAndOutputWithBlockSize_16(byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        PacketCipherChecks.checkBoundsInputAndOutput(input, inOff, len, output, outOff);
        if (len % 16 != 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len not multiple of block size"));
        }
    }

    static void checkBoundsInputAndOutput(byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        if (input == null) {
            throw PacketCipherException.from(new IllegalArgumentException("input was null"));
        }
        if (output == null) {
            throw PacketCipherException.from(new IllegalArgumentException("output was null"));
        }
        if (inOff < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input offset is negative"));
        }
        if (outOff < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("output offset is negative"));
        }
        if (len < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (inOff > input.length - len) {
            throw PacketCipherException.from(new DataLengthException("input buffer too short for offset + length"));
        }
        if (outOff > output.length - len) {
            throw PacketCipherException.from(new OutputLengthException("output buffer too short"));
        }
    }

    static void checkInputAndOutputAEAD(boolean encryption, byte[] input, int inOff, int len, byte[] output, int outOff, int macLenBytes) throws PacketCipherException {
        if (!encryption) {
            PacketCipherChecks.checkInputAgainstRequiredLength(input, outOff, macLenBytes);
        }
        int outputLen = encryption ? len + macLenBytes : len - macLenBytes;
        PacketCipherChecks.checkOutputAgainstRequiredLength(output, outOff, outputLen);
    }

    static void checkInputAgainstRequiredLength(byte[] input, int inOff, int requiredLength) throws PacketCipherException {
        if (inOff < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input offset is negative"));
        }
        if (requiredLength < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (inOff > input.length - requiredLength) {
            throw PacketCipherException.from(new DataLengthException("data too short"));
        }
    }

    static void checkOutputAgainstRequiredLength(byte[] output, int outOff, int requiredLength) throws PacketCipherException {
        if (outOff < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("output offset is negative"));
        }
        if (requiredLength < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (outOff > output.length - requiredLength) {
            throw PacketCipherException.from(new DataLengthException("output buffer too short"));
        }
    }

    static int addCheckInputOverflow(int a, int b) {
        assert (a >= 0);
        assert (b >= 0);
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException arex) {
            throw new DataLengthException("too much input");
        }
    }

    protected static void checkKeyLength(int keyLen) throws PacketCipherException {
        try {
            PacketCipherChecks.checkKeyLenIllegalArgumentException(keyLen);
        }
        catch (IllegalArgumentException ilex) {
            throw PacketCipherException.from(ilex);
        }
    }

    protected static void checkKeyLenIllegalArgumentException(int keyLen) {
        switch (keyLen) {
            case 16: 
            case 24: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        }
    }

    protected static void checkKeyLengthExclude192(int keyLen) throws PacketCipherException {
        try {
            PacketCipherChecks.checkKeyLenIllegalArgumentExceptionExclude192(keyLen);
        }
        catch (IllegalArgumentException ilex) {
            throw PacketCipherException.from(ilex);
        }
    }

    protected static void checkKeyLenIllegalArgumentExceptionExclude192(int keyLen) {
        switch (keyLen) {
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("key must be only 16, or 32 bytes long");
            }
        }
    }
}

