/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeGCMPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESGCMModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AESGCMPacketCipher
implements AESGCMModePacketCipher {
    private boolean destroyed = false;
    private byte[] lastIV;
    private byte[] lastKey;
    private static final byte[] deadKeyInstance = new byte[0];

    public static AESGCMModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/GCM-PC")) {
            return new AESNativeGCMPacketCipher();
        }
        return new AESGCMPacketCipher();
    }

    @Override
    public int getOutputSize(boolean forEncryption, CipherParameters parameters, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        int macSize = this.checkParameters(parameters);
        if (forEncryption) {
            return PacketCipherChecks.addCheckInputOverflow(len, macSize);
        }
        if (len < macSize) {
            throw new OutputLengthException("output buffer too short");
        }
        return len - macSize;
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        long adLen;
        byte[] newKeyOwned;
        int macSizeBytes;
        byte[] ad;
        byte[] nonceOwned;
        PacketCipherChecks.checkBoundsInput(input, inOff, len, output, outOff);
        long[][] mulT = new long[256][2];
        int blockSize = 16;
        int outOffStart = outOff;
        if (parameters instanceof AEADParameters) {
            AEADParameters aeadParam = (AEADParameters)parameters;
            nonceOwned = aeadParam.getNonce();
            ad = aeadParam.getAssociatedText();
            int macSizeBits = aeadParam.getMacSize();
            if (macSizeBits < 32 || macSizeBits > 128 || (macSizeBits & 7) != 0) {
                throw PacketCipherException.from(new IllegalArgumentException("invalid mac size: " + macSizeBits));
            }
            macSizeBytes = macSizeBits >> 3;
            if (aeadParam.getKey() != null) {
                PacketCipherChecks.checkKeyLength(aeadParam.getKey().getKeyLength());
                newKeyOwned = Arrays.clone(aeadParam.getKey().getKey());
            } else {
                newKeyOwned = null;
            }
        } else if (parameters instanceof ParametersWithIV) {
            ParametersWithIV param = (ParametersWithIV)parameters;
            nonceOwned = Arrays.clone(param.getIV());
            ad = null;
            macSizeBytes = 16;
            if (param.getParameters() != null) {
                PacketCipherChecks.checkKeyLength(((KeyParameter)param.getParameters()).getKeyLength());
                newKeyOwned = Arrays.clone(((KeyParameter)param.getParameters()).getKey());
            } else {
                newKeyOwned = null;
            }
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameters passed to GCM"));
        }
        if (nonceOwned.length < 12) {
            PacketCipherException.from(new IllegalArgumentException("nonce must be at least 12 byte"));
        }
        if (encryption && this.lastIV != null && Arrays.areEqual(this.lastIV, nonceOwned)) {
            if (newKeyOwned == null) {
                throw PacketCipherException.from(new IllegalArgumentException("cannot reuse nonce for GCM encryption"));
            }
            if (this.lastKey != null && Arrays.areEqual(this.lastKey, newKeyOwned)) {
                throw PacketCipherException.from(new IllegalArgumentException("cannot reuse nonce for GCM encryption"));
            }
        }
        byte[] keyOwned = newKeyOwned != null ? newKeyOwned : Arrays.clone(this.lastKey);
        this.lastIV = Arrays.clone(nonceOwned);
        this.lastKey = Arrays.clone(keyOwned);
        int remaining = encryption ? len : len - macSizeBytes;
        long totalLen = remaining;
        int outputLen = encryption ? len + macSizeBytes : len - macSizeBytes;
        PacketCipherChecks.checkInputAndOutputAEAD(encryption, input, inOff, len, output, outOff, macSizeBytes);
        byte[] s = AESPacketCipher.createS(true);
        int[][] workingKey = AESPacketCipher.generateWorkingKey(true, keyOwned);
        byte[] H = new byte[16];
        AESPacketCipher.processBlock(true, workingKey, s, H, 0, H, 0);
        AESGCMPacketCipher.initMultiplier(mulT, H);
        byte[] J0 = new byte[16];
        if (nonceOwned.length == 12) {
            System.arraycopy(nonceOwned, 0, J0, 0, nonceOwned.length);
            J0[J0.length - 1] = 1;
        } else {
            AESGCMPacketCipher.gHASH(J0, nonceOwned, nonceOwned.length, mulT);
            byte[] X = new byte[16];
            Pack.longToBigEndian((long)nonceOwned.length * 8L, X, 8);
            AESGCMPacketCipher.gHASHBlock(J0, X, mulT);
        }
        byte[] S = new byte[16];
        if (ad != null) {
            int l;
            adLen = ad.length;
            int offset = 0;
            for (l = ad.length; l > S.length; l -= S.length) {
                AESGCMPacketCipher.gHASHBlock(S, ad, offset, mulT);
                offset += S.length;
            }
            AESGCMPacketCipher.gHASHPartial(S, ad, offset, l, mulT);
        } else {
            adLen = 0L;
        }
        byte[] counter = Arrays.clone(J0);
        int blocksRemaining = -2;
        byte[] ctrBlock = new byte[16];
        while (remaining > 16) {
            blocksRemaining = this.assertBlocksRemaining(blocksRemaining);
            AESGCMPacketCipher.getNextCtrBlock(counter);
            AESPacketCipher.processBlock(true, workingKey, s, counter, 0, ctrBlock, 0);
            GCMUtil.xor(ctrBlock, input, inOff);
            if (encryption) {
                AESGCMPacketCipher.gHASHBlock(S, ctrBlock, mulT);
            } else {
                AESGCMPacketCipher.gHASHBlock(S, input, inOff, mulT);
            }
            System.arraycopy(ctrBlock, 0, output, outOff, 16);
            remaining -= 16;
            outOff += 16;
            inOff += 16;
        }
        this.assertBlocksRemaining(blocksRemaining);
        AESGCMPacketCipher.getNextCtrBlock(counter);
        AESPacketCipher.processBlock(true, workingKey, s, counter, 0, ctrBlock, 0);
        if (encryption) {
            GCMUtil.xor(ctrBlock, 0, input, inOff, remaining);
            AESGCMPacketCipher.gHASHPartial(S, ctrBlock, 0, remaining, mulT);
        } else {
            AESGCMPacketCipher.gHASHPartial(S, input, inOff, remaining, mulT);
            GCMUtil.xor(ctrBlock, 0, input, inOff, remaining);
        }
        inOff += remaining;
        System.arraycopy(ctrBlock, 0, output, outOff, remaining);
        outOff += remaining;
        byte[] X = new byte[16];
        Pack.longToBigEndian(adLen * 8L, X, 0);
        Pack.longToBigEndian(totalLen * 8L, X, 8);
        AESGCMPacketCipher.gHASHBlock(S, X, mulT);
        byte[] tag = new byte[16];
        AESPacketCipher.processBlock(true, workingKey, s, J0, 0, tag, 0);
        GCMUtil.xor(tag, S);
        if (encryption) {
            System.arraycopy(tag, 0, output, outOff, macSizeBytes);
        } else if (!Arrays.constantTimeAreEqual(macSizeBytes, tag, 0, input, inOff)) {
            Arrays.clear(output, outOffStart, (int)totalLen);
            throw PacketCipherException.from(new InvalidCipherTextException("mac check in GCM failed"));
        }
        Arrays.clear(nonceOwned);
        Arrays.clear(S);
        Arrays.clear(J0);
        Arrays.clear(X);
        Arrays.clear(H);
        Arrays.clear(mulT);
        Arrays.clear(workingKey);
        Arrays.clear(keyOwned);
        return outputLen;
    }

    private int assertBlocksRemaining(int blocksRemaining) throws PacketCipherException {
        if (blocksRemaining == 0) {
            throw PacketCipherException.from(new IllegalStateException("Attempt to process too many blocks"));
        }
        return --blocksRemaining;
    }

    private static void getNextCtrBlock(byte[] counter) {
        int c = 1;
        counter[15] = (byte)(c += counter[15] & 0xFF);
        c >>>= 8;
        counter[14] = (byte)(c += counter[14] & 0xFF);
        c >>>= 8;
        counter[13] = (byte)(c += counter[13] & 0xFF);
        c >>>= 8;
        counter[12] = (byte)(c += counter[12] & 0xFF);
    }

    private static void gHASH(byte[] Y, byte[] b, int len, long[][] T) {
        for (int pos = 0; pos < len; pos += 16) {
            int num = Math.min(len - pos, 16);
            AESGCMPacketCipher.gHASHPartial(Y, b, pos, num, T);
        }
    }

    private static void gHASHBlock(byte[] Y, byte[] b, long[][] T) {
        GCMUtil.xor(Y, b);
        AESGCMPacketCipher.multiplyH(Y, T);
    }

    private static void gHASHBlock(byte[] Y, byte[] b, int off, long[][] T) {
        GCMUtil.xor(Y, b, off);
        AESGCMPacketCipher.multiplyH(Y, T);
    }

    private static void gHASHPartial(byte[] Y, byte[] b, int off, int len, long[][] T) {
        GCMUtil.xor(Y, b, off, len);
        AESGCMPacketCipher.multiplyH(Y, T);
    }

    private static void multiplyH(byte[] x, long[][] T) {
        long[] t = T[x[15] & 0xFF];
        long z0 = t[0];
        long z1 = t[1];
        for (int i = 14; i >= 0; --i) {
            t = T[x[i] & 0xFF];
            long c = z1 << 56;
            z1 = t[1] ^ (z1 >>> 8 | z0 << 56);
            z0 = t[0] ^ z0 >>> 8 ^ c ^ c >>> 1 ^ c >>> 2 ^ c >>> 7;
        }
        Pack.longToBigEndian(z0, x, 0);
        Pack.longToBigEndian(z1, x, 8);
    }

    protected static void initMultiplier(long[][] t, byte[] h) {
        GCMUtil.asLongs(h, t[1]);
        GCMUtil.multiplyP7(t[1], t[1]);
        for (int n = 2; n < 256; n += 2) {
            GCMUtil.divideP(t[n >> 1], t[n]);
            GCMUtil.xor(t[n], t[1], t[n + 1]);
        }
    }

    public String toString() {
        return "GCM-PS[Java](AES[Java])";
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.destroyed = true;
        Arrays.clear(this.lastKey);
        Arrays.clear(this.lastIV);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

