/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCTRModePacketCipher
extends PacketCipher {
    default public void checkParameters(CipherParameters parameters) {
        if (parameters instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)parameters;
            int ivLen = ivParam.getIV().length;
            if (16 < ivLen) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: 16 bytes.");
            }
            if (16 - ivLen > 8) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: 8 bytes.");
            }
            KeyParameter keyParameter = (KeyParameter)ivParam.getParameters();
            if (keyParameter == null) {
                throw new IllegalStateException("CTR/SIC cipher unitialized.");
            }
            int keyLen = keyParameter.getKeyLength();
            if (keyLen < 16 || keyLen > 32 || (keyLen & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
    }
}

