/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeCFBPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESCFBModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;

public class AESCFBPacketCipher
implements AESCFBModePacketCipher {
    public static AESCFBModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CFB-PC")) {
            return new AESNativeCFBPacketCipher();
        }
        return new AESCFBPacketCipher();
    }

    protected AESCFBPacketCipher() {
    }

    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        if (parameters instanceof ParametersWithIV) {
            if (((ParametersWithIV)parameters).getIV().length != 16) {
                throw new IllegalArgumentException("iv must be only 16 bytes");
            }
            parameters = ((ParametersWithIV)parameters).getParameters();
        }
        if (parameters instanceof KeyParameter) {
            PacketCipherChecks.checkKeyLenIllegalArgumentException(((KeyParameter)parameters).getKeyLength());
        }
        return len;
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        byte[] ivOwned;
        PacketCipherChecks.checkBoundsInputAndOutput(input, inOff, len, output, outOff);
        if (len == 0) {
            return len;
        }
        if (parameters instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)parameters;
            ivOwned = Arrays.clone(ivParam.getIV());
            if (ivOwned.length != 16) {
                throw PacketCipherException.from(new IllegalArgumentException("iv must be only 16 bytes"));
            }
            parameters = ((ParametersWithIV)parameters).getParameters();
        } else {
            ivOwned = new byte[16];
        }
        if (!(parameters instanceof KeyParameter)) {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameter type"));
        }
        KeyParameter kp = (KeyParameter)parameters;
        PacketCipherChecks.checkKeyLength(kp.getKeyLength());
        byte[] keyOwned = Arrays.clone(kp.getKey());
        byte[] s = AESPacketCipher.createS(true);
        int[][] workingKey = AESPacketCipher.generateWorkingKey(true, keyOwned);
        byte[] keyBlock = new byte[16];
        AESPacketCipher.processBlock(true, workingKey, s, ivOwned, 0, keyBlock, 0);
        int remaining = len;
        if (encryption) {
            while (remaining > 16) {
                Bytes.xor(16, input, inOff, keyBlock, 0, output, outOff);
                AESPacketCipher.processBlock(true, workingKey, s, output, outOff, keyBlock, 0);
                remaining -= 16;
                inOff += 16;
                outOff += 16;
            }
        } else {
            byte[] lastCipherText = new byte[16];
            while (remaining > 16) {
                System.arraycopy(input, inOff, lastCipherText, 0, lastCipherText.length);
                Bytes.xor(16, input, inOff, keyBlock, 0, output, outOff);
                AESPacketCipher.processBlock(true, workingKey, s, lastCipherText, 0, keyBlock, 0);
                remaining -= 16;
                inOff += 16;
                outOff += 16;
            }
        }
        Bytes.xor(remaining, input, inOff, keyBlock, 0, output, outOff);
        return len;
    }

    public String toString() {
        return "CFB-PS[Java](AES[Java])";
    }
}

