/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESGCMSIVModePacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeGCMSIVPacketCipher
implements AESGCMSIVModePacketCipher {
    public static AESGCMSIVModePacketCipher newInstance() {
        return new AESNativeGCMSIVPacketCipher();
    }

    @Override
    public int getOutputSize(boolean encryption, CipherParameters params, int len) {
        this.checkParameters(params);
        return AESNativeGCMSIVPacketCipher.getOutputSize(encryption, len);
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters params, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        int result;
        byte[] key;
        byte[] initialAssociatedText;
        byte[] nonce;
        CipherParameters param;
        if (params instanceof AEADParameters) {
            param = (AEADParameters)params;
            nonce = ((AEADParameters)param).getNonce();
            initialAssociatedText = ((AEADParameters)param).getAssociatedText();
            key = ((AEADParameters)param).getKey().getKey();
        } else if (params instanceof ParametersWithIV) {
            param = (ParametersWithIV)params;
            nonce = (byte[])((ParametersWithIV)param).getIV().clone();
            initialAssociatedText = null;
            key = ((KeyParameter)((ParametersWithIV)param).getParameters()).getKey();
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameters passed to GCM-SIV"));
        }
        int outLen = output != null ? output.length - outOff : 0;
        try {
            result = AESNativeGCMSIVPacketCipher.processPacket(encryption, key, nonce, initialAssociatedText, input, inOff, len, output, outOff, outLen);
        }
        catch (Exception e) {
            throw PacketCipherException.from(e);
        }
        return result;
    }

    static native int getOutputSize(boolean var0, int var1);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9);

    public String toString() {
        return "GCMSIV-PS[Native](AES[Native])";
    }
}

