/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

class SHA224NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;

    SHA224NativeDigest(CryptoServicePurpose purpose) {
        this.purpose = purpose;
        this.nativeRef = new DigestRefWrapper(SHA224NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA224NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA224NativeDigest(SHA224NativeDigest src) {
        this(CryptoServicePurpose.ANY);
        byte[] state = src.getEncodedState();
        SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), state, 0);
    }

    SHA224NativeDigest restoreState(byte[] state, int offset) {
        SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), state, offset);
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-224";
    }

    @Override
    public int getDigestSize() {
        return SHA224NativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte in) {
        SHA224NativeDigest.update(this.nativeRef.getReference(), in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        SHA224NativeDigest.update(this.nativeRef.getReference(), input, inOff, len);
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        return SHA224NativeDigest.doFinal(this.nativeRef.getReference(), output, outOff);
    }

    @Override
    public void reset() {
        SHA224NativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHA224NativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHA224NativeDigest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHA224NativeDigest dig = (SHA224NativeDigest)other;
        SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), dig.getEncodedState(), 0);
    }

    @Override
    public byte[] getEncodedState() {
        int l = SHA224NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] state = new byte[l];
        SHA224NativeDigest.encodeFullState(this.nativeRef.getReference(), state, 0);
        return state;
    }

    void restoreFullState(byte[] encoded, int offset) {
        SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), encoded, offset);
    }

    public String toString() {
        return "SHA224[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 224, this.purpose);
    }

    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long reference) {
            super(reference, "SHA224");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            SHA224NativeDigest.destroy(reference);
        }
    }
}

