/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.validator.SignedMailValidator;
import org.bouncycastle.pkix.jcajce.PKIXCertPathReviewer;
import org.bouncycastle.pkix.util.ErrorBundle;

public class ValidateSignedMail {
    public static final boolean useCaCerts = false;
    public static final int TITLE = 0;
    public static final int TEXT = 1;
    public static final int SUMMARY = 2;
    public static final int DETAIL = 3;
    static int dbgLvl = 3;
    private static final String RESOURCE_NAME = "org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, (InputStream)new FileInputStream("signed.message"));
        HashSet<TrustAnchor> trustanchors = new HashSet<TrustAnchor>();
        TrustAnchor trust = ValidateSignedMail.getTrustAnchor("trustanchor");
        if (trust == null) {
            System.out.println("no trustanchor file found, using a dummy trustanchor");
            trust = ValidateSignedMail.getDummyTrustAnchor();
        }
        trustanchors.add(trust);
        PKIXParameters param = new PKIXParameters(trustanchors);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        X509CRL crl = ValidateSignedMail.loadCRL("crl.file");
        if (crl != null) {
            crls.add(crl);
        }
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(crls), "BC");
        param.addCertStore(certStore);
        param.setRevocationEnabled(true);
        ValidateSignedMail.verifySignedMail(msg, param);
    }

    public static void verifySignedMail(MimeMessage msg, PKIXParameters param) throws Exception {
        Locale loc = Locale.ENGLISH;
        SignedMailValidator validator = new SignedMailValidator(msg, param);
        for (SignerInformation signer : validator.getSignerInformationStore().getSigners()) {
            PKIXCertPathReviewer review;
            ErrorBundle errMsg;
            SignedMailValidator.ValidationResult result = validator.getValidationResult(signer);
            if (result.isValidSignature()) {
                errMsg = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.sigValid");
                errMsg.setClassLoader(SignedMailValidator.class.getClassLoader());
                System.out.println(errMsg.getText(loc));
            } else {
                errMsg = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.sigInvalid");
                errMsg.setClassLoader(SignedMailValidator.class.getClassLoader());
                System.out.println(errMsg.getText(loc));
                System.out.println("Errors:");
                for (ErrorBundle errorMsg : result.getErrors()) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + errorMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + errorMsg.getText(loc));
                }
            }
            if (!result.getNotifications().isEmpty()) {
                System.out.println("Notifications:");
                for (ErrorBundle notMsg : result.getNotifications()) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + notMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + notMsg.getText(loc));
                }
            }
            if ((review = result.getCertPathReview()) == null) continue;
            if (review.isValidCertPath()) {
                System.out.println("Certificate path valid");
            } else {
                System.out.println("Certificate path invalid");
            }
            System.out.println("\nCertificate path validation results:");
            System.out.println("Errors:");
            for (ErrorBundle errorMsg : review.getErrors(-1)) {
                if (dbgLvl == 3) {
                    System.out.println("\t\t" + errorMsg.getDetail(loc));
                    continue;
                }
                System.out.println("\t\t" + errorMsg.getText(loc));
            }
            System.out.println("Notifications:");
            for (ErrorBundle noteMsg : review.getNotifications(-1)) {
                System.out.println("\t" + noteMsg.getText(loc));
            }
            Iterator<? extends Certificate> certIt = review.getCertPath().getCertificates().iterator();
            int i = 0;
            while (certIt.hasNext()) {
                X509Certificate cert = (X509Certificate)certIt.next();
                System.out.println("\nCertificate " + i + "\n========");
                System.out.println("Issuer: " + cert.getIssuerDN().getName());
                System.out.println("Subject: " + cert.getSubjectDN().getName());
                System.out.println("\tErrors:");
                for (ErrorBundle errorMsg : review.getErrors(i)) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + errorMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + errorMsg.getText(loc));
                }
                System.out.println("\tNotifications:");
                for (ErrorBundle noteMsg : review.getNotifications(i)) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + noteMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + noteMsg.getText(loc));
                }
                ++i;
            }
        }
    }

    protected static TrustAnchor getTrustAnchor(String trustcert) throws Exception {
        X509Certificate cert = ValidateSignedMail.loadCert(trustcert);
        if (cert == null) {
            return null;
        }
        byte[] nameConstraints = null;
        byte[] ncExtValue = cert.getExtensionValue(Extension.nameConstraints.getId());
        if (ncExtValue != null) {
            NameConstraints nc = NameConstraints.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])ncExtValue));
            nameConstraints = nc.getEncoded("DER");
        }
        return new TrustAnchor(cert, nameConstraints);
    }

    protected static X509Certificate loadCert(String certfile) {
        X509Certificate cert = null;
        try {
            FileInputStream in = new FileInputStream(certfile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            cert = (X509Certificate)cf.generateCertificate(in);
        }
        catch (Exception e) {
            System.out.println("certfile \"" + certfile + "\" not found - classpath is " + System.getProperty("java.class.path"));
        }
        return cert;
    }

    protected static X509CRL loadCRL(String crlfile) {
        X509CRL crl = null;
        try {
            FileInputStream in = new FileInputStream(crlfile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            crl = (X509CRL)cf.generateCRL(in);
        }
        catch (Exception e) {
            System.out.println("crlfile \"" + crlfile + "\" not found - classpath is " + System.getProperty("java.class.path"));
        }
        return crl;
    }

    private static TrustAnchor getDummyTrustAnchor() throws Exception {
        X500Principal principal = new X500Principal("CN=Dummy Trust Anchor");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(1024, new SecureRandom());
        PublicKey trustPubKey = kpg.generateKeyPair().getPublic();
        return new TrustAnchor(principal, trustPubKey, null);
    }
}

